/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.mwe.dynamic.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.sphinx.emf.mwe.dynamic.internal.Activator;
import org.eclipse.sphinx.emf.util.EcorePlatformUtil;
import org.eclipse.sphinx.emf.util.EcoreResourceUtil;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;
import org.eclipse.xtend.core.xtend.XtendClass;
import org.eclipse.xtend.core.xtend.XtendFile;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;

public class XtendUtil {
    public static boolean isJavaProject(IProject project) {
        Assert.isNotNull((Object)project);
        try {
            return project.hasNature("org.eclipse.jdt.core.javanature");
        }
        catch (CoreException ex) {
            PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)((Object)ex));
            return false;
        }
    }

    public static IJavaProject getJavaProject(IProject project) {
        Assert.isNotNull((Object)project);
        if (XtendUtil.isJavaProject(project)) {
            return JavaCore.create((IProject)project);
        }
        return null;
    }

    public static boolean isJavaFile(IFile file) {
        return file != null && "java".equals(file.getFileExtension());
    }

    public static boolean isXtendFile(IFile file) {
        return file != null && "xtend".equals(file.getFileExtension());
    }

    public static boolean isXtendResource(URI uri) {
        return uri != null && "xtend".equals(uri.fileExtension());
    }

    public static IPath getJavaPath(IPath xtendOrJavaPath) {
        Assert.isNotNull((Object)xtendOrJavaPath);
        Path javaPath = new Path("");
        String[] stringArray = xtendOrJavaPath.segments();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            javaPath = segment.equals("src") ? javaPath.append("xtend-gen") : javaPath.append(segment);
            ++n2;
        }
        return javaPath.removeFileExtension().addFileExtension("java");
    }

    public static IFile getJavaFile(IPath xtendOrJavaPath) {
        IPath javaPath = XtendUtil.getJavaPath(xtendOrJavaPath);
        return ResourcesPlugin.getWorkspace().getRoot().getFile(javaPath);
    }

    public static IFile getJavaFile(IFile xtendOrJavaFile, String className) {
        if (XtendUtil.isJavaFile(xtendOrJavaFile)) {
            return xtendOrJavaFile;
        }
        if (XtendUtil.isXtendFile(xtendOrJavaFile)) {
            if (xtendOrJavaFile.getFullPath().removeFileExtension().lastSegment().equals(className)) {
                return XtendUtil.getJavaFile(xtendOrJavaFile.getFullPath());
            }
            IPath virtualXtendPath = xtendOrJavaFile.getFullPath().removeLastSegments(1).append(className).addFileExtension("java");
            return XtendUtil.getJavaFile(virtualXtendPath);
        }
        return null;
    }

    public static IJavaElement getJavaElement(IFile xtendOrJavaFile) {
        IFile javaFile = XtendUtil.getJavaFile(xtendOrJavaFile.getFullPath());
        IJavaProject javaProject = JavaCore.create((IProject)javaFile.getProject());
        try {
            return javaProject.findElement(javaFile.getProjectRelativePath().removeFirstSegments(1));
        }
        catch (JavaModelException ex) {
            PlatformLogUtil.logAsError((Plugin)Activator.getDefault(), (Object)((Object)ex));
            return null;
        }
    }

    public static List<String> getAvailableClassNames(IFile xtendFile) {
        ArrayList<String> availableClassNames = new ArrayList<String>(1);
        URI uri = EcorePlatformUtil.createURI((IPath)xtendFile.getFullPath());
        Resource resource = EcoreResourceUtil.loadResource(null, (URI)uri, null);
        if (resource != null) {
            for (EObject object : resource.getContents()) {
                if (!(object instanceof XtendFile)) continue;
                EList xtendTypes = ((XtendFile)object).getXtendTypes();
                for (XtendTypeDeclaration declaration : xtendTypes) {
                    if (!(declaration instanceof XtendClass)) continue;
                    XtendClass clazz = (XtendClass)declaration;
                    availableClassNames.add(clazz.getName());
                }
            }
        }
        return availableClassNames;
    }
}

