/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.examples.actions;

import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.sphinx.emf.edit.ITreeItemAncestorProvider;
import org.eclipse.sphinx.emf.util.WorkspaceEditingDomainUtil;
import org.eclipse.sphinx.examples.actions.internal.messages.Messages;
import org.eclipse.ui.actions.BaseSelectionListenerAction;

public class BasicWalkUpAncestorsAction
extends BaseSelectionListenerAction {
    public static long WALK_UP_ANCESTORS_DELAY = 500L;
    protected Viewer viewer;
    protected Object selectedObject = null;
    protected ITreeItemAncestorProvider treeItemAncestorProvider = null;

    public BasicWalkUpAncestorsAction(Viewer viewer) {
        this(Messages.act_WalkUpAncestors_label, viewer);
    }

    public BasicWalkUpAncestorsAction(String text, Viewer viewer) {
        super(text);
        Assert.isNotNull((Object)viewer);
        this.viewer = viewer;
    }

    public boolean updateSelection(IStructuredSelection selection) {
        if (selection.size() == 1) {
            this.selectedObject = selection.getFirstElement();
            TransactionalEditingDomain editingDomain = WorkspaceEditingDomainUtil.getEditingDomain((Object)this.selectedObject);
            AdapterFactory adapterFactory = this.getAdapterFactory(editingDomain);
            if (adapterFactory != null) {
                this.treeItemAncestorProvider = (ITreeItemAncestorProvider)adapterFactory.adapt(this.selectedObject, ITreeItemAncestorProvider.class);
            }
        }
        return this.treeItemAncestorProvider != null;
    }

    public void run() {
        List ancestorPath = this.treeItemAncestorProvider.getAncestorPath(this.selectedObject, false);
        for (Object ancestor : ancestorPath) {
            if (!this.skipAncestor(ancestor)) continue;
            if (this.viewer == null || this.viewer.getControl() == null || this.viewer.getControl().isDisposed()) break;
            System.out.println(ancestor);
            this.viewer.setSelection((ISelection)new StructuredSelection(ancestor));
            try {
                Thread.sleep(WALK_UP_ANCESTORS_DELAY);
            }
            catch (InterruptedException interruptedException) {}
        }
        System.out.println();
    }

    protected boolean skipAncestor(Object ancestor) {
        return !(ancestor instanceof Resource) && !(ancestor instanceof ResourceSet);
    }

    protected AdapterFactory getAdapterFactory(TransactionalEditingDomain editingDomain) {
        AdapterFactory customAdapterFactory = this.getCustomAdapterFactory();
        if (customAdapterFactory != null) {
            return customAdapterFactory;
        }
        if (editingDomain instanceof AdapterFactoryEditingDomain) {
            return ((AdapterFactoryEditingDomain)editingDomain).getAdapterFactory();
        }
        return null;
    }

    protected AdapterFactory getCustomAdapterFactory() {
        return null;
    }
}

