/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.validation.ui.views;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.sphinx.emf.validation.ui.views.MarkerAdapter;
import org.eclipse.sphinx.emf.validation.ui.views.MarkerMessages;
import org.eclipse.sphinx.emf.validation.ui.views.MarkerNode;
import org.eclipse.sphinx.emf.validation.ui.views.MarkerSelectionProviderAction;
import org.eclipse.sphinx.emf.validation.ui.views.MarkerView;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.ide.StatusUtil;
import org.eclipse.ui.statushandlers.StatusManager;

public class ActionSelectAll
extends MarkerSelectionProviderAction {
    private MarkerView view;

    public ActionSelectAll(MarkerView markerView) {
        super((ISelectionProvider)markerView.getViewer(), MarkerMessages.selectAllAction_title);
        this.setEnabled(true);
        this.view = markerView;
    }

    public void run() {
        if (this.view.getMarkerAdapter().isBuilding()) {
            return;
        }
        IRunnableWithProgress selectionRunnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                try {
                    monitor.beginTask(MarkerMessages.selectAllAction_title, 100);
                    monitor.subTask(MarkerMessages.selectAllAction_calculating);
                    if (ActionSelectAll.this.view.getMarkerAdapter().isShowingHierarchy()) {
                        if (monitor.isCanceled()) {
                            return;
                        }
                        monitor.worked(10);
                        PlatformUI.getWorkbench().getDisplay().readAndDispatch();
                        MarkerAdapter.MarkerCategory[] categories = ActionSelectAll.this.view.getMarkerAdapter().getCategories();
                        int totalSize = 0;
                        MarkerAdapter.MarkerCategory[] markerCategoryArray = categories;
                        int n = categories.length;
                        int n2 = 0;
                        while (n2 < n) {
                            MarkerAdapter.MarkerCategory markerCategory = markerCategoryArray[n2];
                            totalSize += markerCategory.getDisplayedSize();
                            ++n2;
                        }
                        monitor.worked(10);
                        PlatformUI.getWorkbench().getDisplay().readAndDispatch();
                        Object[] selection = new Object[totalSize];
                        int index = 0;
                        MarkerAdapter.MarkerCategory[] markerCategoryArray2 = categories;
                        int n3 = categories.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            MarkerAdapter.MarkerCategory categorie = markerCategoryArray2[n4];
                            MarkerNode[] children = categorie.getChildren();
                            System.arraycopy(children, 0, selection, index, children.length);
                            index += children.length;
                            ++n4;
                        }
                        monitor.worked(10);
                        if (monitor.isCanceled()) {
                            return;
                        }
                        PlatformUI.getWorkbench().getDisplay().readAndDispatch();
                        monitor.subTask(MarkerMessages.selectAllAction_applying);
                        ActionSelectAll.this.getSelectionProvider().setSelection((ISelection)new StructuredSelection(selection));
                    } else {
                        if (monitor.isCanceled()) {
                            return;
                        }
                        monitor.worked(10);
                        List selection = ActionSelectAll.this.view.getMarkerAdapter().getCurrentMarkers().asList();
                        monitor.worked(10);
                        monitor.subTask(MarkerMessages.selectAllAction_applying);
                        PlatformUI.getWorkbench().getDisplay().readAndDispatch();
                        ActionSelectAll.this.getSelectionProvider().setSelection((ISelection)new StructuredSelection(selection));
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().run(false, false, selectionRunnableWithProgress);
        }
        catch (InvocationTargetException e) {
            StatusManager.getManager().handle(StatusUtil.newStatus((int)4, (String)e.getLocalizedMessage(), (Throwable)e), 1);
        }
        catch (InterruptedException e) {
            StatusManager.getManager().handle(StatusUtil.newStatus((int)4, (String)e.getLocalizedMessage(), (Throwable)e), 1);
        }
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(!selection.isEmpty());
    }
}

