/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.persist;

import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchResultListener;
import com.unboundid.ldap.sdk.SearchResultReference;
import com.unboundid.ldap.sdk.persist.LDAPPersistException;
import com.unboundid.ldap.sdk.persist.LDAPPersister;
import com.unboundid.ldap.sdk.persist.ObjectSearchListener;
import com.unboundid.util.Debug;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
final class SearchListenerBridge<T>
implements SearchResultListener {
    private static final long serialVersionUID = 1939354785788059032L;
    private final LDAPPersister<T> persister;
    private final ObjectSearchListener<T> listener;

    SearchListenerBridge(LDAPPersister<T> persister, ObjectSearchListener<T> listener) {
        this.persister = persister;
        this.listener = listener;
    }

    @Override
    public void searchEntryReturned(SearchResultEntry searchEntry) {
        try {
            this.listener.objectReturned(this.persister.decode(searchEntry));
        }
        catch (LDAPPersistException lpe) {
            Debug.debugException(lpe);
            this.listener.unparsableEntryReturned(searchEntry, lpe);
        }
    }

    @Override
    public void searchReferenceReturned(SearchResultReference searchReference) {
        this.listener.searchReferenceReturned(searchReference);
    }
}

