/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.cheatsheets.views;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.help.HelpSystem;
import org.eclipse.help.IContext;
import org.eclipse.rwt.graphics.Graphics;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.cheatsheets.AbstractItemExtensionElement;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.eclipse.ui.internal.cheatsheets.CheatSheetPlugin;
import org.eclipse.ui.internal.cheatsheets.CheatSheetStopWatch;
import org.eclipse.ui.internal.cheatsheets.Messages;
import org.eclipse.ui.internal.cheatsheets.data.Item;
import org.eclipse.ui.internal.cheatsheets.views.CheatSheetPage;
import org.eclipse.ui.internal.cheatsheets.views.CheatSheetViewer;
import org.eclipse.ui.internal.cheatsheets.views.SubItemCompositeHolder;
import org.eclipse.ui.internal.cheatsheets.views.ViewUtilities;

public abstract class ViewItem {
    public static final byte VIEWITEM_ADVANCE = 0;
    public static final byte VIEWITEM_DONOT_ADVANCE = 1;
    private Composite bodyComp;
    protected FormText bodyText;
    protected FormText completionText;
    protected Composite bodyWrapperComposite;
    protected Composite buttonComposite;
    protected Composite completionComposite;
    private boolean buttonExpanded = true;
    private boolean completionMessageExpanded = false;
    private Label checkDoneLabel;
    private boolean completed = false;
    protected Item item;
    protected Color itemColor;
    private boolean isSkipped = false;
    private ExpandableComposite mainItemComposite;
    private Composite parent;
    protected CheatSheetViewer viewer;
    protected CheatSheetPage page;
    private Composite titleComposite;
    private boolean bold = true;
    private Font boldFont;
    private Font regularFont;
    private boolean initialized = false;
    protected ArrayList listOfSubItemCompositeHolders;

    public ViewItem(CheatSheetPage page, Item item, Color itemColor, CheatSheetViewer viewer) {
        this.page = page;
        this.parent = page.getForm().getBody();
        this.item = item;
        this.itemColor = itemColor;
        this.viewer = viewer;
        this.addItem();
    }

    private void addItem() {
        CheatSheetStopWatch.startStopWatch("ViewItem.addItem()");
        CheatSheetStopWatch.printLapTime("ViewItem.addItem()", "Time in addItem() after getBannerBackground: ");
        this.checkDoneLabel = this.page.getToolkit().createLabel(this.parent, " ");
        CheatSheetStopWatch.printLapTime("ViewItem.addItem()", "Time in addItem() after create checkDoneLabel: ");
        this.mainItemComposite = this.page.getToolkit().createSection(this.parent, 34);
        this.mainItemComposite.setBackground(this.itemColor);
        this.mainItemComposite.setLayoutData((Object)new TableWrapData(256));
        String title = this.item.getTitle();
        if (title != null) {
            this.mainItemComposite.setText(ViewUtilities.escapeForLabel(title));
        }
        CheatSheetStopWatch.printLapTime("ViewItem.addItem()", "Time in addItem() after create mainItemComposite: ");
        this.mainItemComposite.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                ViewItem.this.page.getForm().reflow(true);
            }
        });
        CheatSheetStopWatch.printLapTime("ViewItem.addItem()", "Time in addItem() after addExpansionListener: ");
        int number = 0;
        ArrayList itemExts = this.item.getItemExtensions();
        if (itemExts != null && itemExts.size() > 0 || this.item.getContextId() != null || this.item.getHref() != null) {
            this.titleComposite = this.page.getToolkit().createComposite((Composite)this.mainItemComposite);
            this.titleComposite.setBackground(this.itemColor);
        }
        if (itemExts != null) {
            int g = 0;
            while (g < itemExts.size()) {
                AbstractItemExtensionElement[] eea = (AbstractItemExtensionElement[])itemExts.get(g);
                number += eea.length;
                int x = 0;
                while (x < eea.length) {
                    eea[x].createControl(this.titleComposite);
                    ++x;
                }
                ++g;
            }
        }
        CheatSheetStopWatch.printLapTime("ViewItem.addItem()", "Time in addItem() after create item extensions: ");
        if (this.item.getContextId() != null || this.item.getHref() != null) {
            ++number;
            ImageHyperlink helpButton = this.createButton(this.titleComposite, CheatSheetPlugin.getPlugin().getImage("CHEATSHEET_ITEM_HELP"), this, this.itemColor, Messages.get().HELP_BUTTON_TOOLTIP);
            helpButton.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    if (ViewItem.this.item.getContextId() != null) {
                        ViewItem.this.openInfopop(e.widget);
                    } else {
                        ViewItem.this.openHelpTopic();
                    }
                }
            });
        }
        CheatSheetStopWatch.printLapTime("ViewItem.addItem()", "Time in addItem() after create help button: ");
        if (number > 0) {
            this.mainItemComposite.setTextClient((Control)this.titleComposite);
            GridLayout layout = new GridLayout(number, false);
            GridData data = new GridData(1808);
            this.titleComposite.setLayout((Layout)layout);
            this.titleComposite.setLayoutData((Object)data);
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            layout.verticalSpacing = 0;
        }
        CheatSheetStopWatch.printLapTime("ViewItem.addItem()", "Time in addItem() after setTextClient: ");
        this.bodyWrapperComposite = this.page.getToolkit().createComposite((Composite)this.mainItemComposite);
        this.mainItemComposite.setClient((Control)this.bodyWrapperComposite);
        TableWrapLayout wrapperLayout = new TableWrapLayout();
        this.bodyWrapperComposite.setLayout((Layout)wrapperLayout);
        this.bodyWrapperComposite.setBackground(this.itemColor);
        CheatSheetStopWatch.printLapTime("ViewItem.addItem()", "Time in addItem() after create bodyWrapperComposite: ");
        this.bodyText = this.page.getToolkit().createFormText(this.bodyWrapperComposite, false);
        this.bodyText.setText(this.item.getDescription(), this.item.getDescription().startsWith("<form><p>"), false);
        this.bodyText.setBackground(this.itemColor);
        this.bodyText.setLayoutData((Object)new TableWrapData(256));
        CheatSheetStopWatch.printLapTime("ViewItem.addItem()", "Time in addItem() after create FormText: ");
        if (!this.item.isDynamic()) {
            this.handleButtons();
        }
        CheatSheetStopWatch.printLapTime("ViewItem.addItem()", "Time in addItem() after handleButtons(): ");
        this.setButtonsVisible(false);
        this.setCollapsed();
        CheatSheetStopWatch.printLapTime("ViewItem.addItem()", "Time in addItem() after setting buttons and item collapsed: ");
        this.boldFont = this.mainItemComposite.getFont();
        FontData[] fontDatas = this.boldFont.getFontData();
        this.regularFont = Graphics.getFont((String)fontDatas[0].getName(), (int)fontDatas[0].getHeight(), (int)(fontDatas[0].getStyle() ^ 1));
        CheatSheetStopWatch.printLapTime("ViewItem.addItem()", "Time in addItem() after font initlization: ");
        this.setBold(false);
        CheatSheetStopWatch.printLapTime("ViewItem.addItem()", "Time in addItem() after setBold: ");
    }

    protected ImageHyperlink createButtonWithText(Composite parent, Image image, ViewItem item, Color color, String linkText) {
        ImageHyperlink button = this.page.getToolkit().createImageHyperlink(parent, 0);
        button.setImage(image);
        button.setData((Object)item);
        button.setBackground(color);
        button.setText(linkText);
        button.setToolTipText(linkText);
        return button;
    }

    protected ImageHyperlink createButton(Composite parent, Image image, ViewItem item, Color color, String toolTipText) {
        ImageHyperlink button = new ImageHyperlink(parent, 0);
        this.page.getToolkit().adapt((Control)button, true, true);
        button.setImage(image);
        button.setData((Object)item);
        button.setBackground(color);
        button.setToolTipText(toolTipText);
        return button;
    }

    public void dispose() {
        ArrayList itemExts;
        if (this.checkDoneLabel != null) {
            this.checkDoneLabel.dispose();
        }
        if (this.bodyText != null) {
            this.bodyText.dispose();
        }
        if (this.buttonComposite != null) {
            this.buttonComposite.dispose();
        }
        if (this.completionComposite != null) {
            this.completionComposite.dispose();
        }
        if (this.bodyComp != null) {
            this.bodyComp.dispose();
        }
        if (this.bodyWrapperComposite != null) {
            this.bodyWrapperComposite.dispose();
        }
        if (this.mainItemComposite != null) {
            this.mainItemComposite.dispose();
        }
        if (this.titleComposite != null) {
            this.titleComposite.dispose();
        }
        if ((itemExts = this.item.getItemExtensions()) != null) {
            int g = 0;
            while (g < itemExts.size()) {
                AbstractItemExtensionElement[] eea = (AbstractItemExtensionElement[])itemExts.get(g);
                int x = 0;
                while (x < eea.length) {
                    eea[x].dispose();
                    ++x;
                }
                ++g;
            }
        }
    }

    Image getCompleteImage() {
        return CheatSheetPlugin.getPlugin().getImage("CHEATSHEET_ITEM_COMPLETE");
    }

    public Item getItem() {
        return this.item;
    }

    Composite getMainItemComposite() {
        return this.mainItemComposite;
    }

    Image getSkipImage() {
        return CheatSheetPlugin.getPlugin().getImage("CHEATSHEET_ITEM_SKIP");
    }

    abstract void handleButtons();

    boolean isBold() {
        return this.bold;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public boolean isExpanded() {
        return this.mainItemComposite.isExpanded();
    }

    public boolean isCompletionMessageExpanded() {
        return this.completionMessageExpanded;
    }

    public boolean isInDialogMode() {
        return this.viewer.isInDialogMode();
    }

    boolean isSkipped() {
        return this.isSkipped;
    }

    private void openHelpTopic() {
        if (this.item == null || this.item.getHref() == null) {
            return;
        }
        PlatformUI.getWorkbench().getHelpSystem().displayHelpResource(this.item.getHref());
    }

    private void openInfopop(Widget widget) {
        if (this.item == null || this.item.getContextId() == null) {
            return;
        }
        IContext context = HelpSystem.getContext((String)this.item.getContextId());
        if (context != null) {
            Point point = widget.getDisplay().getCursorLocation();
            point = new Point(point.x + 15, point.y);
            PlatformUI.getWorkbench().getHelpSystem().displayContext(context, point.x, point.y);
        }
    }

    public void setAsCurrentActiveItem() {
        this.setColorAsCurrent(true);
        this.setButtonsVisible(true);
        this.setBold(true);
        this.setExpanded();
        this.setFocus();
    }

    protected void setFocus() {
        this.mainItemComposite.setFocus();
        FormToolkit.ensureVisible((Control)this.getMainItemComposite());
    }

    void setAsNormalCollapsed() {
        this.setBold(false);
        this.setColorAsCurrent(false);
        if (this.mainItemComposite.isExpanded()) {
            this.setCollapsed();
        }
    }

    void setAsNormalNonCollapsed() {
        this.setColorAsCurrent(false);
        this.setBold(false);
    }

    private void setBodyColor(Color color) {
        this.mainItemComposite.setBackground(color);
        this.setBackgroundColor(this.bodyWrapperComposite, color);
        this.setBackgroundColor(this.buttonComposite, color);
        this.setBackgroundColor(this.completionComposite, color);
    }

    protected void setBackgroundColor(Composite composite, Color color) {
        if (composite != null) {
            composite.setBackground(color);
            Control[] children = composite.getChildren();
            int i = 0;
            while (i < children.length) {
                children[i].setBackground(color);
                ++i;
            }
        }
    }

    void setBold(boolean value) {
        if (value) {
            this.mainItemComposite.setFont(this.boldFont);
            if (this.initialized) {
                this.mainItemComposite.layout();
            }
        } else {
            this.mainItemComposite.setFont(this.regularFont);
            if (this.initialized) {
                this.mainItemComposite.layout();
            }
        }
        this.bold = value;
    }

    void setButtonsVisible(boolean isVisible) {
        if (this.buttonExpanded != isVisible) {
            if (this.listOfSubItemCompositeHolders != null) {
                Iterator iter = this.listOfSubItemCompositeHolders.iterator();
                while (iter.hasNext()) {
                    ((SubItemCompositeHolder)iter.next()).setButtonsVisible(isVisible);
                }
            } else if (this.buttonComposite != null) {
                this.buttonComposite.setVisible(isVisible);
            }
        }
        if (isVisible && this.initialized) {
            FormToolkit.ensureVisible((Control)this.getMainItemComposite());
        }
        this.buttonExpanded = isVisible;
    }

    protected void setCompletionMessageExpanded(boolean isFinalItem) {
        if (this.hasCompletionMessage()) {
            if (this.completionComposite == null) {
                this.createCompletionComposite(isFinalItem);
            }
            if (!this.completionMessageExpanded) {
                this.completionComposite.setVisible(true);
                this.completionMessageExpanded = true;
            }
        }
    }

    abstract void createCompletionComposite(boolean var1);

    protected void setCompletionMessageCollapsed() {
        if (this.completionComposite != null && this.completionMessageExpanded) {
            this.completionComposite.dispose();
            this.completionComposite = null;
            this.page.getForm().reflow(true);
        }
        this.completionMessageExpanded = false;
    }

    void setCollapsed() {
        if (this.mainItemComposite.isExpanded()) {
            this.mainItemComposite.setExpanded(false);
            if (this.initialized) {
                this.page.getForm().reflow(true);
                FormToolkit.ensureVisible((Control)this.getMainItemComposite());
            }
        }
    }

    private void setColorAsCurrent(boolean active) {
        if (active) {
            this.setTitleColor(this.page.getActiveColor());
            this.setBodyColor(this.page.getActiveColor());
        } else {
            this.setTitleColor(this.itemColor);
            this.setBodyColor(this.itemColor);
        }
    }

    void setComplete() {
        this.completed = true;
        this.checkDoneLabel.setImage(this.getCompleteImage());
        if (this.initialized) {
            this.checkDoneLabel.getParent().layout();
        }
    }

    void setExpanded() {
        if (!this.mainItemComposite.isExpanded()) {
            this.mainItemComposite.setExpanded(true);
            if (this.initialized) {
                this.page.getForm().reflow(true);
                FormToolkit.ensureVisible((Control)this.getMainItemComposite());
            }
        }
    }

    void setIncomplete() {
        this.checkDoneLabel.setImage(null);
        this.completed = false;
        this.setStartImage();
    }

    void setItemColor(Color itemColor) {
        this.itemColor = itemColor;
    }

    void setOriginalColor() {
        this.setTitleColor(this.itemColor);
        this.setBodyColor(this.itemColor);
        this.setBold(false);
    }

    abstract void setRestartImage();

    void setSkipped() {
        this.isSkipped = true;
        this.checkDoneLabel.setImage(this.getSkipImage());
        if (this.initialized) {
            this.checkDoneLabel.getParent().layout();
        }
    }

    abstract void setStartImage();

    private void setTitleColor(Color bg) {
        if (this.titleComposite != null) {
            this.titleComposite.setBackground(bg);
            Control[] titlechildren = this.titleComposite.getChildren();
            int i = 0;
            while (i < titlechildren.length) {
                titlechildren[i].setBackground(bg);
                ++i;
            }
        }
    }

    public void initialized() {
        this.initialized = true;
    }

    public boolean canCopy() {
        return false;
    }

    abstract boolean hasCompletionMessage();
}

