/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.demo.controls;

import org.eclipse.rap.demo.controls.ExampleTab;
import org.eclipse.rwt.graphics.Graphics;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class CLabelTab
extends ExampleTab {
    private CLabel left;
    private CLabel center;
    private CLabel right;
    private boolean showBgGradient;
    private static final String IMAGE2 = "resources/newfile_wiz.gif";
    private static final String IMAGE1 = "resources/button-image.gif";

    public CLabelTab(CTabFolder parent) {
        super(parent, "CLabel");
    }

    protected void createStyleControls(Composite parent) {
        this.createStyleButton("LEFT", 16384);
        this.createStyleButton("RIGHT", 131072);
        this.createStyleButton("CENTER", 0x1000000);
        this.createStyleButton("SHADOW_IN", 4);
        this.createStyleButton("SHADOW_OUT", 8);
        this.createStyleButton("SHADOW_NONE", 32);
        this.createVisibilityButton();
        this.createEnablementButton();
        this.createFontChooser();
        this.createCursorCombo();
        this.createFgColorButton();
        this.createBgColorButton();
        this.createBgImageButton();
        this.createBgGradientButton();
    }

    protected void createExampleControls(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        int style = this.getStyle();
        this.left = new CLabel(parent, style);
        this.left.setText("Some Text");
        ClassLoader classLoader = this.getClass().getClassLoader();
        Image image1 = Graphics.getImage((String)IMAGE1, (ClassLoader)classLoader);
        this.left.setImage(image1);
        this.center = new CLabel(parent, style);
        this.center.setText("First Line\nSecond Line\n");
        this.right = new CLabel(parent, style);
        this.right.setText("And more");
        Image image2 = Graphics.getImage((String)IMAGE2, (ClassLoader)classLoader);
        this.right.setImage(image2);
        this.registerControl((Control)this.left);
        this.registerControl((Control)this.center);
        this.registerControl((Control)this.right);
    }

    protected Button createBgGradientButton() {
        final Button button = new Button(this.styleComp, 32);
        button.setText("Background Gradient");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CLabelTab.this.showBgGradient = button.getSelection();
                CLabelTab.this.updateBgGradient();
            }
        });
        return button;
    }

    private void updateBgGradient() {
        if (this.showBgGradient) {
            Color[] gradientColors = new Color[]{BGG_COLOR_BLUE, BGG_COLOR_GREEN, BGG_COLOR_BLUE, BGG_COLOR_GREEN, BGG_COLOR_BLUE};
            int[] percents = new int[]{25, 50, 75, 100};
            this.left.setBackground(gradientColors, percents);
            this.center.setBackground(gradientColors, percents, true);
            this.right.setBackground(gradientColors, percents);
        } else {
            this.left.setBackground(null, null);
            this.center.setBackground(null, null);
            this.right.setBackground(null, null);
        }
    }
}

