/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.reqif10.search.filter.ui;

import java.util.List;
import org.eclipse.rmf.reqif10.AttributeDefinition;
import org.eclipse.rmf.reqif10.AttributeDefinitionString;
import org.eclipse.rmf.reqif10.AttributeDefinitionXHTML;
import org.eclipse.rmf.reqif10.search.filter.AbstractTextFilter;
import org.eclipse.rmf.reqif10.search.filter.IFilter;
import org.eclipse.rmf.reqif10.search.filter.StringFilter;
import org.eclipse.rmf.reqif10.search.filter.XhtmlFilter;
import org.eclipse.rmf.reqif10.search.filter.ui.FilterControl;
import org.eclipse.rmf.reqif10.search.filter.ui.FilterPanel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class FilterControlString
extends FilterControl {
    private Text text;
    private Button caseSensitive;

    public FilterControlString(FilterPanel parent, AbstractTextFilter.InternalAttribute attribute) {
        super(parent, attribute);
    }

    public FilterControlString(FilterPanel parent, AttributeDefinition attribute) {
        super(parent, attribute);
    }

    public FilterControlString(FilterPanel parent, AbstractTextFilter template) {
        super(parent, (IFilter)template);
    }

    @Override
    protected List<IFilter.Operator> getOperators() {
        if (this.attribute instanceof AttributeDefinitionXHTML) {
            return XhtmlFilter.SUPPORTED_OPERATORS.asList();
        }
        return StringFilter.SUPPORTED_OPERATORS.asList();
    }

    @Override
    protected void updateValueControls(boolean initialize) {
        if (this.getOperator() == IFilter.Operator.IS_SET || this.getOperator() == IFilter.Operator.IS_NOT_SET) {
            this.showControl(false);
        } else {
            this.showControl(true);
        }
        if (initialize && this.text != null) {
            this.caseSensitive.setSelection(((AbstractTextFilter)this.templateFilter).isCaseSensitive());
            this.text.setText((String)this.templateFilter.getFilterValue1());
        }
    }

    private void showControl(boolean show) {
        if (show && this.text == null) {
            this.caseSensitive = new Button((Composite)this, 32);
            this.caseSensitive.setText("Aa");
            this.caseSensitive.setToolTipText("Case Sensitive");
            GridData layoutData = new GridData(16384, 0x1000000, false, false);
            this.caseSensitive.setLayoutData((Object)layoutData);
            this.text = new Text((Composite)this, 2052);
            layoutData = new GridData(4, 0x1000000, true, false);
            this.text.setLayoutData((Object)layoutData);
        }
        if (!show && this.text != null) {
            this.text.dispose();
            this.text = null;
            this.caseSensitive.dispose();
            this.caseSensitive = null;
        }
    }

    @Override
    public IFilter getFilter() {
        boolean cv;
        String value = this.text == null ? null : this.text.getText();
        boolean bl = cv = this.caseSensitive == null ? false : this.caseSensitive.getSelection();
        if (this.attribute instanceof AbstractTextFilter.InternalAttribute) {
            return new StringFilter(this.getOperator(), value, (AbstractTextFilter.InternalAttribute)this.attribute, cv);
        }
        if (this.attribute instanceof AttributeDefinitionString) {
            return new StringFilter(this.getOperator(), value, (AttributeDefinitionString)this.attribute, cv);
        }
        if (this.attribute instanceof AttributeDefinitionXHTML) {
            return new XhtmlFilter(this.getOperator(), value, (AttributeDefinitionXHTML)this.attribute, cv);
        }
        throw new IllegalStateException("Can't handle: " + this.attribute);
    }
}

