/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.reqif10.search.filter.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.rmf.reqif10.AttributeDefinition;
import org.eclipse.rmf.reqif10.AttributeDefinitionEnumeration;
import org.eclipse.rmf.reqif10.EnumValue;
import org.eclipse.rmf.reqif10.pror.editor.presentation.EnumSelector;
import org.eclipse.rmf.reqif10.search.filter.EnumFilter;
import org.eclipse.rmf.reqif10.search.filter.IFilter;
import org.eclipse.rmf.reqif10.search.filter.ui.FilterControl;
import org.eclipse.rmf.reqif10.search.filter.ui.FilterPanel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class FilterControlEnum
extends FilterControl {
    private Button valueControl;
    private Collection<EnumValue> items;

    public FilterControlEnum(FilterPanel parent, AttributeDefinitionEnumeration attribute) {
        super(parent, (AttributeDefinition)attribute);
    }

    public FilterControlEnum(FilterPanel parent, EnumFilter template) {
        super(parent, (IFilter)template);
    }

    @Override
    protected List<IFilter.Operator> getOperators() {
        return EnumFilter.SUPPORTED_OPERATORS.asList();
    }

    @Override
    protected void updateValueControls(boolean initialize) {
        if (this.getOperator() == IFilter.Operator.IS_SET || this.getOperator() == IFilter.Operator.IS_NOT_SET) {
            this.showControl(false);
        } else {
            this.showControl(true);
        }
        if (initialize && this.valueControl != null) {
            this.updateItems(((EnumFilter)this.templateFilter).getFilterValue1());
        }
    }

    private void showControl(boolean show) {
        if (show && this.valueControl == null) {
            if (this.items == null) {
                this.items = new ArrayList<EnumValue>();
            }
            this.valueControl = new Button((Composite)this, 0x800048);
            GridData layoutData = new GridData(4, 0x1000000, true, false);
            layoutData.widthHint = 200;
            this.valueControl.setLayoutData((Object)layoutData);
            this.valueControl.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FilterControlEnum.this.popupSelector((Control)FilterControlEnum.this.valueControl);
                }
            });
        }
        if (!show && this.valueControl != null) {
            this.valueControl.dispose();
            this.valueControl = null;
            this.items = null;
        }
    }

    protected void popupSelector(Control control) {
        Shell shell;
        EList specifiedValues = ((AttributeDefinitionEnumeration)this.attribute).getType().getSpecifiedValues();
        EnumSelector selector = new EnumSelector((List)specifiedValues, this.items, (Composite)(shell = EnumSelector.createShell((Control)control)), 2048);
        int status = selector.showEnumSelector(shell);
        if (status == 32) {
            this.updateItems(selector.getItems());
        }
    }

    private void updateItems(Collection<EnumValue> items) {
        EList specifiedValues = ((AttributeDefinitionEnumeration)this.attribute).getType().getSpecifiedValues();
        this.items = items;
        StringBuilder sb = new StringBuilder();
        Iterator<EnumValue> i = items.iterator();
        while (i.hasNext()) {
            EnumValue value = i.next();
            if (!specifiedValues.contains((Object)value)) continue;
            String label = value.getLongName() != null ? value.getLongName() : value.getIdentifier();
            sb.append(label);
            if (!i.hasNext()) continue;
            sb.append(", ");
        }
        this.valueControl.setText(sb.toString());
        this.layout();
        this.getParent().layout();
        this.getParent().getParent().layout();
    }

    @Override
    public IFilter getFilter() {
        return new EnumFilter(this.getOperator(), this.items, (AttributeDefinitionEnumeration)this.attribute);
    }
}

