/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.reqif10.csv.importer.ui.wizards.pages;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class CSVImportWizardPage
extends WizardPage {
    private static final String REQIF_EXTENSION = "reqif";
    private static final String CSV_EXTENSION = "csv";
    private static final String[] CSV_SEPARATOR_ARRAY = new String[]{",", ";", ":", ".", "\t", "|", "^"};
    private String selectedFilePath = "";
    private String separator = CSV_SEPARATOR_ARRAY[0];
    private boolean containsHeader;
    private IFile selectedDestinationFile;

    public CSVImportWizardPage() {
        super("Import requirements from CSV");
        this.setTitle("Import requirements from CSV");
        this.setDescription("Requirements CSV File Import Wizard");
    }

    public void createControl(Composite parent) {
        Composite mainComposite = new Composite(parent, 0);
        mainComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout gridLayout = new GridLayout();
        mainComposite.setLayout((Layout)gridLayout);
        this.createFileSelectionGroup(mainComposite);
        this.createConfigurationGroup(mainComposite);
        this.createReqIFFileSelectionComposite(mainComposite);
        this.validatePage();
        this.setControl((Control)mainComposite);
    }

    protected Group createFileSelectionGroup(Composite parent) {
        Group group = this.createGroup(parent, "File Selection");
        this.createLabel((Composite)group, "File :");
        final Text text = this.createText((Composite)group);
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CSVImportWizardPage.this.selectedFilePath = text.getText();
                CSVImportWizardPage.this.validatePage();
            }
        });
        Button button = this.createButton((Composite)group, "Browse");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String filePath = CSVImportWizardPage.this.browseForFile();
                if (filePath != null && !filePath.isEmpty()) {
                    text.setText(filePath);
                }
            }
        });
        return group;
    }

    protected Group createConfigurationGroup(Composite parent) {
        Group group = this.createGroup(parent, "Configuration");
        this.createLabel((Composite)group, "Separator character");
        ComboViewer comboViewer = new ComboViewer((Composite)group);
        comboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        comboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        comboViewer.setInput((Object)CSV_SEPARATOR_ARRAY);
        comboViewer.setSelection((ISelection)new StructuredSelection((Object)this.separator));
        comboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CSVImportWizardPage.this.separator = ((IStructuredSelection)event.getSelection()).getFirstElement().toString();
            }
        });
        comboViewer.getCombo().setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
        final Button headerButton = new Button((Composite)group, 32);
        headerButton.setLayoutData((Object)new GridData(4, 128, true, false, 3, 1));
        headerButton.setText("The csv file contains a header");
        headerButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                CSVImportWizardPage.this.containsHeader = headerButton.getSelection();
            }
        });
        return group;
    }

    protected Group createFileDestinationSelectionGroup(Composite parent) {
        Group group = this.createGroup(parent, "ReqIF File destination");
        group.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.createReqIFFileSelectionComposite((Composite)group);
        return group;
    }

    private Group createGroup(Composite parent, String groupText) {
        Group group = new Group(parent, 0);
        group.setText(groupText);
        group.setLayout((Layout)new GridLayout(3, false));
        group.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        return group;
    }

    protected Label createLabel(Composite parent, String labelText) {
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        label.setText(labelText);
        return label;
    }

    protected Text createText(Composite parent) {
        Text text = new Text(parent, 2048);
        text.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        return text;
    }

    protected Button createButton(Composite parent, String buttonText) {
        Button button = new Button(parent, 0);
        button.setText(buttonText);
        return button;
    }

    protected void createReqIFFileSelectionComposite(Composite parent) {
        Group group = this.createGroup(parent, "Destination ReqIF File");
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        TreeViewer treeViewer = new TreeViewer((Composite)group);
        treeViewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        treeViewer.setContentProvider((IContentProvider)new BaseWorkbenchContentProvider());
        treeViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        ViewerFilter reqifFilter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IFile) {
                    return CSVImportWizardPage.this.isReqIFFile((IFile)element);
                }
                return true;
            }
        };
        treeViewer.setFilters(new ViewerFilter[]{reqifFilter});
        treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object object;
                IFile file = null;
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (!selection.isEmpty() && (object = selection.getFirstElement()) instanceof IFile && CSVImportWizardPage.this.isReqIFFile((IFile)object)) {
                    file = (IFile)object;
                }
                CSVImportWizardPage.this.selectedDestinationFile = file;
                CSVImportWizardPage.this.validatePage();
            }
        });
        treeViewer.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
    }

    protected boolean isReqIFFile(IFile file) {
        return file.getFileExtension().equals(REQIF_EXTENSION);
    }

    protected String browseForFile() {
        FileDialog dialog = this.createFileDialog();
        String path = dialog.open();
        return path == null ? "" : path;
    }

    protected FileDialog createFileDialog() {
        FileDialog dialog = new FileDialog(this.getShell(), 4096);
        dialog.setFilterExtensions(new String[]{"*.csv"});
        return dialog;
    }

    protected boolean validatePage() {
        boolean valid = true;
        if (this.selectedFilePath.isEmpty()) {
            this.setFieldEmptyErrorMessage();
            valid = false;
        } else if (!this.checkFileExtension(this.selectedFilePath)) {
            this.setExtensionErrorMessage();
            valid = false;
        } else if (!this.isFileExist(this.selectedFilePath)) {
            this.setNoFileErrorMessage(this.selectedFilePath);
            valid = false;
        } else if (this.selectedDestinationFile == null) {
            this.setSelectedReqIFDestinationFileEmptyErrorMessage();
            valid = false;
        }
        if (valid) {
            this.setPageComplete(true);
            this.setMessage(null);
            this.setErrorMessage(null);
        }
        return valid;
    }

    protected boolean checkFileExtension(String path) {
        return path.endsWith(".csv");
    }

    protected boolean isFileExist(String filePath) {
        return new File(filePath).exists();
    }

    protected void setFieldEmptyErrorMessage() {
        this.setMessage(null);
        this.setErrorMessage(" Please select a csv file to import");
        this.setPageComplete(false);
    }

    protected void setExtensionErrorMessage() {
        this.setMessage(null);
        this.setErrorMessage("The file name must end with .csv");
        this.setPageComplete(false);
    }

    protected void setNoFileErrorMessage(String fileName) {
        this.setMessage(null);
        this.setErrorMessage("The file " + fileName + "doesn't exists");
        this.setPageComplete(false);
    }

    protected void setSelectedReqIFDestinationFileEmptyErrorMessage() {
        this.setMessage(null);
        this.setErrorMessage(" Please select the destination ReqIF file (*.reqif)");
        this.setPageComplete(false);
    }

    public String getSelectedFilePath() {
        return this.selectedFilePath;
    }

    public char getSeparator() {
        return this.separator.charAt(0);
    }

    public IFile getSelectedDestinationFile() {
        return this.selectedDestinationFile;
    }

    public boolean isContainsHeader() {
        return this.containsHeader;
    }
}

