/*
 * Decompiled with CFR 0.152.
 */
package org.agilemore.agilegrid.renderers;

import org.agilemore.agilegrid.AgileGrid;
import org.agilemore.agilegrid.ICompositorStrategy;
import org.agilemore.agilegrid.ILayoutAdvisor;
import org.agilemore.agilegrid.SWTResourceManager;
import org.agilemore.agilegrid.renderers.ButtonCellRenderer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;

public class HeaderCellRenderer
extends ButtonCellRenderer {
    public static final Image IMAGE_ARROWDOWN = SWTResourceManager.getImage(HeaderCellRenderer.class, "/icons/arrow_down.png");
    public static final Image IMAGE_ARROWUP = SWTResourceManager.getImage(HeaderCellRenderer.class, "/icons/arrow_up.png");
    public static final Color COLOR_FIXEDBACKGROUND = SWTResourceManager.getColor(22);

    public HeaderCellRenderer(AgileGrid agileGrid, int style) {
        super(agileGrid, style);
        this.style |= 0;
        this.setAlignment(55);
        this.setDefaultBackground(COLOR_FIXEDBACKGROUND);
    }

    @Override
    protected void initialColor(int row, int col) {
        if (this.agileGrid.isHeaderHighlighted(row, col)) {
            if ((this.style & 0x10) != 0) {
                this.background = COLOR_FIXEDHIGHLIGHT;
            }
            if ((this.style & 0x20) != 0) {
                this.foreground = COLOR_FGROWSELECTION;
                this.background = COLOR_BGROWSELECTION;
            }
        }
    }

    @Override
    protected void doDrawCellContent(GC gc, Rectangle rect, int row, int col) {
        String label = "";
        ILayoutAdvisor layoutAdvisor = this.agileGrid.getLayoutAdvisor();
        if (row == -1 && col >= 0 && col < layoutAdvisor.getColumnCount()) {
            label = layoutAdvisor.getTopHeaderLabel(col);
        } else if (col == -1 && row >= 0 && row < layoutAdvisor.getRowCount()) {
            label = layoutAdvisor.getLeftHeaderLabel(row);
        } else if (row == -1 && col == -1) {
            label = "";
        }
        if ((this.style & 0x200) != 0) {
            this.drawVerticalTextImage(gc, rect, label, null, this.foreground, this.background);
        } else {
            int alignment = this.getAlignment();
            this.drawTextImage(gc, label, alignment, null, alignment, rect.x + 3, rect.y + 2, rect.width - 6, rect.height - 4);
        }
        this.drawSortIndicator(gc, rect, row, col, label);
    }

    protected void drawSortIndicator(GC gc, Rectangle rect, int row, int col, Object content) {
        ILayoutAdvisor layoutAdvisor = this.agileGrid.getLayoutAdvisor();
        ICompositorStrategy compositorStrategy = layoutAdvisor.getCompositorStrategy();
        if ((this.style & 8) != 0 && compositorStrategy != null && compositorStrategy.getSortColumn() == col && row == -1) {
            Image indicator = null;
            int sort = compositorStrategy.getSortState();
            if (sort == 1) {
                indicator = IMAGE_ARROWUP;
            } else if (sort == 2) {
                indicator = IMAGE_ARROWDOWN;
            }
            if (indicator != null) {
                int x = 0;
                int y = 0;
                Rectangle indiRect = indicator.getBounds();
                x = rect.x + rect.width - 1 - indiRect.width;
                y = rect.y + rect.height - 1 - indiRect.height;
                if (x >= rect.x && y >= rect.y) {
                    gc.drawImage(indicator, x, y);
                }
            }
        }
    }

    @Override
    public int getOptimalWidth(GC gc, int row, int col) {
        String str = null;
        ILayoutAdvisor layoutAdvisor = this.agileGrid.getLayoutAdvisor();
        if (row == -1 && col >= 0) {
            str = layoutAdvisor.getTopHeaderLabel(col);
        } else if (row >= 0 && col == -1) {
            str = layoutAdvisor.getLeftHeaderLabel(row);
        }
        if (str == null) {
            return 0;
        }
        this.applyFont(gc);
        int result = 0;
        if ((this.style & 0x200) != 0) {
            String text = this.wrapText(gc, str, layoutAdvisor.getRowHeight(row) - 6);
            result = HeaderCellRenderer.getCachedStringExtent((GC)gc, (String)text).y;
            result += 6;
        } else {
            result = HeaderCellRenderer.getCachedStringExtent((GC)gc, (String)str).x;
            result += 8;
        }
        this.resetFont(gc);
        return result;
    }
}

