/*
 * Decompiled with CFR 0.152.
 */
package org.agilemore.agilegrid;

import org.agilemore.agilegrid.AgileGrid;
import org.agilemore.agilegrid.Cell;
import org.agilemore.agilegrid.ICellNavigationStrategy;
import org.agilemore.agilegrid.ILayoutAdvisor;
import org.eclipse.swt.widgets.Event;

public class CellNavigationStrategy
implements ICellNavigationStrategy {
    @Override
    public boolean isNavigationEvent(AgileGrid agileGrid, Event event) {
        switch (event.type) {
            case 1: {
                switch (event.keyCode) {
                    case 9: 
                    case 0x1000001: 
                    case 0x1000002: 
                    case 0x1000003: 
                    case 0x1000004: 
                    case 0x1000005: 
                    case 0x1000006: 
                    case 0x1000007: 
                    case 0x1000008: {
                        return true;
                    }
                }
                return false;
            }
            case 3: {
                Cell cell = agileGrid.getCell(event.x, event.y);
                return cell.row >= 0 && cell.column >= 0;
            }
            case 4: {
                if ((event.stateMask & 0x40000) == 262144) {
                    return false;
                }
                Cell cell = agileGrid.getCell(event.x, event.y);
                if (cell.row < 0 || cell.column < 0) {
                    return false;
                }
                return agileGrid.isCellSelected(cell.row, cell.column) && agileGrid.getCellSelection().length != 1;
            }
            case 15: {
                return true;
            }
        }
        return false;
    }

    @Override
    public Cell findSelectedCell(AgileGrid agileGrid, Cell currentCell, Event event) {
        Cell foundCell = Cell.NULLCELL;
        switch (event.type) {
            case 1: {
                if (currentCell == Cell.NULLCELL) {
                    currentCell = new Cell(agileGrid, 0, 0);
                }
                int newFocusRow = currentCell.row;
                int newFocusCol = currentCell.column;
                ILayoutAdvisor layoutAdvisor = agileGrid.getLayoutAdvisor();
                switch (event.keyCode) {
                    case 0x1000007: {
                        newFocusCol = 0;
                        foundCell = new Cell(agileGrid, newFocusRow, newFocusCol);
                        break;
                    }
                    case 0x1000008: {
                        newFocusCol = layoutAdvisor.getColumnCount() - 1;
                        if (newFocusRow == -1) {
                            newFocusRow = 0;
                        }
                        foundCell = new Cell(agileGrid, newFocusRow, newFocusCol);
                        break;
                    }
                    case 0x1000001: {
                        foundCell = agileGrid.getNeighbor(currentCell, 1, true);
                        break;
                    }
                    case 0x1000002: {
                        foundCell = agileGrid.getNeighbor(currentCell, 2, true);
                        break;
                    }
                    case 0x1000003: {
                        foundCell = agileGrid.getNeighbor(currentCell, 4, true);
                        break;
                    }
                    case 0x1000004: {
                        foundCell = agileGrid.getNeighbor(currentCell, 8, true);
                        break;
                    }
                    case 0x1000006: {
                        if ((newFocusRow += agileGrid.getRowsFullyVisible() - 1) >= layoutAdvisor.getRowCount()) {
                            newFocusRow = layoutAdvisor.getRowCount() - 1;
                        }
                        if (newFocusCol == -1) {
                            newFocusCol = 0;
                        }
                        foundCell = new Cell(agileGrid, newFocusRow, newFocusCol);
                        break;
                    }
                    case 0x1000005: {
                        if (currentCell.row == layoutAdvisor.getFixedRowCount() && (newFocusRow -= agileGrid.getRowsFullyVisible() - 1) < 0) {
                            newFocusRow = 0;
                        } else if (newFocusRow < layoutAdvisor.getFixedRowCount() && currentCell.row != 0) {
                            newFocusRow = layoutAdvisor.getFixedRowCount();
                        }
                        if (newFocusCol == -1) {
                            newFocusCol = layoutAdvisor.getFixedColumnCount();
                        }
                        foundCell = new Cell(agileGrid, newFocusRow, newFocusCol);
                        break;
                    }
                    case 9: {
                        int direction = (event.stateMask & 0x20000) != 0 ? 4 : 8;
                        foundCell = agileGrid.getNeighbor(currentCell, direction, true);
                    }
                }
                break;
            }
            case 3: 
            case 4: {
                if (event.button != 1) break;
                foundCell = agileGrid.getCell(event.x, event.y);
                if (foundCell.row != -1 && foundCell.column != -1) break;
                foundCell = Cell.NULLCELL;
                break;
            }
            case 15: {
                foundCell = currentCell == Cell.NULLCELL ? new Cell(agileGrid, 0, 0) : currentCell;
            }
        }
        return foundCell;
    }

    @Override
    public boolean shouldCancelEvent(AgileGrid agileGrid, Event event) {
        switch (event.type) {
            case 1: {
                switch (event.keyCode) {
                    case 9: 
                    case 0x1000001: 
                    case 0x1000002: 
                    case 0x1000003: 
                    case 0x1000004: 
                    case 0x1000005: 
                    case 0x1000006: 
                    case 0x1000007: 
                    case 0x1000008: {
                        return true;
                    }
                }
                return false;
            }
            case 15: {
                return true;
            }
        }
        return false;
    }
}

