/*
 * Decompiled with CFR 0.152.
 */
package org.agilemore.agilegrid;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import org.agilemore.agilegrid.Cell;
import org.agilemore.agilegrid.IContentProvider;

public abstract class AbstractContentProvider
implements IContentProvider {
    protected PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    @Override
    public Object getContentAt(int row, int col) {
        return this.doGetContentAt(row, col);
    }

    public abstract Object doGetContentAt(int var1, int var2);

    @Override
    public void setContentAt(int row, int col, Object value) {
        Object oldValue = this.getContentAt(row, col);
        if (oldValue != value || oldValue != null && !oldValue.equals(value)) {
            this.doSetContentAt(row, col, value);
            this.firePropertyChange("content", row, col, oldValue, value);
        }
    }

    public abstract void doSetContentAt(int var1, int var2, Object var3);

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void fireIndexedPropertyChange(String propertyName, int index, boolean oldValue, boolean newValue) {
        this.propertyChangeSupport.fireIndexedPropertyChange(propertyName, index, oldValue, newValue);
    }

    public void fireIndexedPropertyChange(String propertyName, int index, int oldValue, int newValue) {
        this.propertyChangeSupport.fireIndexedPropertyChange(propertyName, index, oldValue, newValue);
    }

    public void fireIndexedPropertyChange(String propertyName, int index, Object oldValue, Object newValue) {
        this.propertyChangeSupport.fireIndexedPropertyChange(propertyName, index, oldValue, newValue);
    }

    public void firePropertyChange(PropertyChangeEvent evt) {
        this.propertyChangeSupport.firePropertyChange(evt);
    }

    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void firePropertyChange(String propertyName, int oldValue, int newValue) {
        this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void firePropertyChange(String propertyName, int index, int oldValue, int newValue) {
        if (oldValue == newValue) {
            return;
        }
        this.firePropertyChange(propertyName, index, new Integer(oldValue), new Integer(newValue));
    }

    public void firePropertyChange(String propertyName, int rowIndex, int colIndex, int oldValue, int newValue) {
        if (oldValue == newValue) {
            return;
        }
        this.firePropertyChange(propertyName, rowIndex, colIndex, new Integer(oldValue), new Integer(newValue));
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void firePropertyChange(String propertyName, int index, Object oldValue, Object newValue) {
        Integer indexObject = new Integer(index);
        HashMap<Integer, Object> oldMap = new HashMap<Integer, Object>();
        oldMap.put(indexObject, oldValue);
        HashMap<Integer, Object> newMap = new HashMap<Integer, Object>();
        newMap.put(indexObject, newValue);
        this.propertyChangeSupport.firePropertyChange(propertyName, oldMap, newMap);
    }

    public void firePropertyChange(String propertyName, int rowIndex, int colIndex, Object oldValue, Object newValue) {
        Cell cell = new Cell(null, rowIndex, colIndex);
        HashMap<Cell, Object> oldMap = new HashMap<Cell, Object>();
        oldMap.put(cell, oldValue);
        HashMap<Cell, Object> newMap = new HashMap<Cell, Object>();
        newMap.put(cell, newValue);
        this.propertyChangeSupport.firePropertyChange(propertyName, oldMap, newMap);
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.propertyChangeSupport.getPropertyChangeListeners();
    }

    public PropertyChangeListener[] getPropertyChangeListeners(String propertyName) {
        return this.propertyChangeSupport.getPropertyChangeListeners(propertyName);
    }

    public boolean hasListeners(String propertyName) {
        return this.propertyChangeSupport.hasListeners(propertyName);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }
}

