/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.reqif10.search.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.rmf.reqif10.AttributeDefinition;
import org.eclipse.rmf.reqif10.AttributeValue;
import org.eclipse.rmf.reqif10.SpecElementWithAttributes;
import org.eclipse.rmf.reqif10.SpecHierarchy;
import org.eclipse.rmf.reqif10.SpecObject;
import org.eclipse.rmf.reqif10.Specification;
import org.eclipse.rmf.reqif10.search.criteria.Criteria;
import org.eclipse.rmf.reqif10.search.criteria.Operator;

public class ReqIFSearcher {
    public Map<Resource, Collection<EObject>> search(IProgressMonitor monitor, Collection<Resource> resources, Collection<Criteria> criterias, boolean replace) {
        HashMap<Resource, Collection<EObject>> result = new HashMap<Resource, Collection<EObject>>();
        for (Resource resource : resources) {
            Collection<EObject> searchresult = this.search(monitor, resource, criterias, replace);
            result.put(resource, searchresult);
            if (monitor.isCanceled()) break;
        }
        monitor.done();
        return result;
    }

    protected Collection<EObject> search(IProgressMonitor monitor, Resource resource, Collection<Criteria> criterias, boolean replace) {
        HashSet<EObject> result = new HashSet<EObject>();
        HashSet<Specification> specifications = new HashSet<Specification>();
        TreeIterator contents = resource.getAllContents();
        while (contents.hasNext()) {
            EObject eObject = (EObject)contents.next();
            Entry entry = this.isCompatibleWithCriteria(eObject, criterias);
            if (entry != null) {
                result.add(eObject);
                if (replace) {
                    this.setValue(entry);
                }
            }
            if (!(eObject instanceof Specification)) continue;
            specifications.add((Specification)eObject);
        }
        for (Specification specification : specifications) {
            this.addSpecHierarchies(result, (EList<SpecHierarchy>)specification.getChildren());
        }
        return result;
    }

    private void addSpecHierarchies(Set<EObject> result, EList<SpecHierarchy> children) {
        for (SpecHierarchy specHierarchy : children) {
            SpecObject specObject = specHierarchy.getObject();
            if (specObject == null || !result.contains(specObject)) continue;
            result.add((EObject)specHierarchy);
            this.addSpecHierarchies(result, (EList<SpecHierarchy>)specHierarchy.getChildren());
        }
    }

    protected Entry isCompatibleWithCriteria(EObject eObject, Collection<Criteria> criterias) {
        block6: for (Criteria criteria : criterias) {
            EAttribute feature;
            Entry entry = this.getEntry(eObject, criteria);
            if (entry == null || !((feature = entry.feature) instanceof EAttribute)) continue;
            Object value = entry.getValue();
            Operator operator = criteria.getOperator();
            String textToSearch = criteria.getSerachedText();
            if (value != null) {
                String stringValue = value.toString();
                switch (operator) {
                    case CONTAINS: {
                        if (!stringValue.contains(textToSearch)) continue block6;
                        return entry;
                    }
                    case NOT_CONTAINS: {
                        if (stringValue.contains(textToSearch)) continue block6;
                        return entry;
                    }
                    case EQUALS: {
                        if (!stringValue.contains(textToSearch)) continue block6;
                        return entry;
                    }
                    case NOT_EQUALS: {
                        if (stringValue.equals(textToSearch)) continue block6;
                        return entry;
                    }
                }
                continue;
            }
            if (!operator.equals((Object)Operator.NOT_EQUALS)) continue;
            return entry;
        }
        return null;
    }

    protected void setValue(Entry entry) {
        Criteria criteria = entry.criteria;
        EObject eObject = entry.eObject;
        EAttribute feature = entry.feature;
        String value = criteria.getReplacementText();
        if (criteria.getOperator().equals((Object)Operator.CONTAINS)) {
            value = entry.getValue().toString().replaceAll(criteria.getSerachedText(), criteria.getReplacementText());
        }
        this.doSetValue(eObject, (EStructuralFeature)feature, EcoreUtil.createFromString((EDataType)feature.getEAttributeType(), (String)value));
    }

    protected void doSetValue(EObject eObject, EStructuralFeature feature, Object value) {
        eObject.eSet(feature, value);
    }

    protected Entry getEntry(EObject eObject, Criteria criteria) {
        Entry entry = null;
        String featureName = criteria.getFeatureName();
        EStructuralFeature eStructuralFeature = eObject.eClass().getEStructuralFeature(featureName);
        if (eStructuralFeature instanceof EAttribute) {
            entry = new Entry(eObject, (EAttribute)eStructuralFeature, criteria);
        } else if (eObject instanceof SpecElementWithAttributes) {
            EList values = ((SpecElementWithAttributes)eObject).getValues();
            for (AttributeValue attributeValue : values) {
                AttributeDefinition attributeDefinition;
                EStructuralFeature definitionEStructuralFeature;
                eStructuralFeature = attributeValue.eClass().getEStructuralFeature(featureName);
                if (eStructuralFeature == null && (definitionEStructuralFeature = attributeValue.eClass().getEStructuralFeature("definition")) != null && (attributeDefinition = (AttributeDefinition)attributeValue.eGet(definitionEStructuralFeature)) != null && attributeDefinition.getLongName() != null && attributeDefinition.getLongName().equals(featureName)) {
                    eStructuralFeature = attributeValue.eClass().getEStructuralFeature("theValue");
                }
                if (!(eStructuralFeature instanceof EAttribute)) continue;
                entry = new Entry((EObject)attributeValue, (EAttribute)eStructuralFeature, criteria);
                break;
            }
        }
        return entry;
    }

    protected class Entry {
        private EObject eObject;
        private EAttribute feature;
        private Criteria criteria;

        public Entry(EObject eObject, EAttribute feature, Criteria criteria) {
            this.eObject = eObject;
            this.feature = feature;
            this.criteria = criteria;
        }

        public Criteria getCriteria() {
            return this.criteria;
        }

        public EObject getEObject() {
            return this.eObject;
        }

        public EAttribute getFeature() {
            return this.feature;
        }

        protected Object getValue() {
            return this.eObject.eGet((EStructuralFeature)this.feature);
        }
    }
}

