/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.reqif10.search.filter;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import org.eclipse.rmf.reqif10.AttributeDefinition;
import org.eclipse.rmf.reqif10.AttributeDefinitionBoolean;
import org.eclipse.rmf.reqif10.AttributeValueBoolean;
import org.eclipse.rmf.reqif10.SpecElementWithAttributes;
import org.eclipse.rmf.reqif10.common.util.ReqIF10Util;
import org.eclipse.rmf.reqif10.search.filter.AbstractAttributeFilter;
import org.eclipse.rmf.reqif10.search.filter.IFilter;

public class BoolFilter
extends AbstractAttributeFilter {
    public static final ImmutableSet<IFilter.Operator> SUPPORTED_OPERATORS = Sets.immutableEnumSet((Enum)IFilter.Operator.IS, (Enum[])new IFilter.Operator[]{IFilter.Operator.IS_SET, IFilter.Operator.IS_NOT_SET});
    private IFilter.Operator operator;
    private Boolean filterValue;
    private AttributeDefinitionBoolean attributeDefinition;

    public BoolFilter(IFilter.Operator operator, Boolean filterValue, AttributeDefinitionBoolean attributeDefinition) {
        if (!SUPPORTED_OPERATORS.contains((Object)operator)) {
            throw new IllegalArgumentException("This filter does not support the " + operator.toString() + " operation");
        }
        if (attributeDefinition == null) {
            throw new IllegalArgumentException("AttributeDefinition can not be null");
        }
        this.operator = operator;
        this.filterValue = filterValue;
        this.attributeDefinition = attributeDefinition;
    }

    @Override
    public boolean match(SpecElementWithAttributes element) {
        if (this.operator == IFilter.Operator.IS_SET || this.operator == IFilter.Operator.IS_NOT_SET) {
            return super.match(element);
        }
        AttributeValueBoolean attributeValue = (AttributeValueBoolean)ReqIF10Util.getAttributeValue((SpecElementWithAttributes)element, (AttributeDefinition)this.attributeDefinition);
        if (attributeValue == null && this.attributeDefinition.isSetDefaultValue() && AbstractAttributeFilter.isSetAttribute(element, (AttributeDefinition)this.attributeDefinition)) {
            attributeValue = this.attributeDefinition.getDefaultValue();
        }
        if (attributeValue == null || !attributeValue.isSetTheValue()) {
            return false;
        }
        Boolean theValue = attributeValue.isTheValue();
        switch (this.operator) {
            case IS: {
                return this.filterValue.equals(theValue);
            }
        }
        throw new IllegalArgumentException("This filter does not support the " + (Object)((Object)this.operator) + " operation");
    }

    @Override
    public Object getAttribute() {
        return this.attributeDefinition;
    }

    @Override
    public IFilter.Operator getOperator() {
        return this.operator;
    }

    @Override
    public Object getFilterValue1() {
        return this.filterValue;
    }

    @Override
    public Object getFilterValue2() {
        return null;
    }

    @Override
    public ImmutableSet<IFilter.Operator> getSupportedOperators() {
        return SUPPORTED_OPERATORS;
    }
}

