/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.mutable.primitive;

import java.io.Serializable;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.factory.map.primitive.MutableDoubleIntMapFactory;
import org.eclipse.collections.api.map.primitive.DoubleIntMap;
import org.eclipse.collections.api.map.primitive.MutableDoubleIntMap;
import org.eclipse.collections.impl.factory.primitive.DoubleIntMaps;
import org.eclipse.collections.impl.map.mutable.primitive.DoubleIntHashMap;
import org.eclipse.collections.impl.utility.Iterate;

public enum MutableDoubleIntMapFactoryImpl implements MutableDoubleIntMapFactory
{
    INSTANCE;


    public MutableDoubleIntMap empty() {
        return new DoubleIntHashMap(0);
    }

    public MutableDoubleIntMap of() {
        return this.empty();
    }

    public MutableDoubleIntMap with() {
        return this.empty();
    }

    public MutableDoubleIntMap ofInitialCapacity(int capacity) {
        return this.withInitialCapacity(capacity);
    }

    public MutableDoubleIntMap withInitialCapacity(int capacity) {
        return new DoubleIntHashMap(capacity);
    }

    public MutableDoubleIntMap ofAll(DoubleIntMap map) {
        return this.withAll(map);
    }

    public MutableDoubleIntMap withAll(DoubleIntMap map) {
        if (map.isEmpty()) {
            return this.empty();
        }
        return new DoubleIntHashMap(map);
    }

    public <T> MutableDoubleIntMap from(Iterable<T> iterable, DoubleFunction<? super T> keyFunction, IntFunction<? super T> valueFunction) {
        MutableDoubleIntMap map = DoubleIntMaps.mutable.empty();
        Iterate.forEach(iterable, (Procedure & Serializable)each -> map.put(keyFunction.doubleValueOf(each), valueFunction.intValueOf(each)));
        return map;
    }
}

