/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.lmdb.util;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public final class SignificantBytesBE {
    private SignificantBytesBE() {
    }

    public static long read(ByteBuffer bb, int n) {
        return SignificantBytesBE.readDirect(bb, n);
    }

    private static long u32(int x) {
        return (long)x & 0xFFFFFFFFL;
    }

    private static int u16(short x) {
        return x & 0xFFFF;
    }

    private static short getShortBE(ByteBuffer bb, boolean littleEndian) {
        short s = bb.getShort();
        return littleEndian ? Short.reverseBytes(s) : s;
    }

    private static int getIntBE(ByteBuffer bb, boolean littleEndian) {
        int i = bb.getInt();
        return littleEndian ? Integer.reverseBytes(i) : i;
    }

    private static long getLongBE(ByteBuffer bb, boolean littleEndian) {
        long l = bb.getLong();
        return littleEndian ? Long.reverseBytes(l) : l;
    }

    public static long readDirect(ByteBuffer bb, int n) {
        if (n < 3 || n > 8) {
            throw new IllegalArgumentException("n must be in [3,8]");
        }
        boolean littleEndian = bb.order() == ByteOrder.LITTLE_ENDIAN;
        switch (n) {
            case 8: {
                return SignificantBytesBE.getLongBE(bb, littleEndian);
            }
            case 7: {
                return ((long)bb.get() & 0xFFL) << 48 | SignificantBytesBE.u32(SignificantBytesBE.getIntBE(bb, littleEndian)) << 16 | (long)SignificantBytesBE.u16(SignificantBytesBE.getShortBE(bb, littleEndian));
            }
            case 6: {
                return (long)SignificantBytesBE.u16(SignificantBytesBE.getShortBE(bb, littleEndian)) << 32 | SignificantBytesBE.u32(SignificantBytesBE.getIntBE(bb, littleEndian));
            }
            case 5: {
                return ((long)bb.get() & 0xFFL) << 32 | SignificantBytesBE.u32(SignificantBytesBE.getIntBE(bb, littleEndian));
            }
            case 4: {
                return SignificantBytesBE.u32(SignificantBytesBE.getIntBE(bb, littleEndian));
            }
            case 3: {
                return (long)SignificantBytesBE.u16(SignificantBytesBE.getShortBE(bb, littleEndian)) << 8 | (long)bb.get() & 0xFFL;
            }
        }
        throw new AssertionError((Object)"unreachable");
    }
}

