/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast;

import java.util.Arrays;
import java.util.Objects;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.base.CoreDatatype;
import org.eclipse.rdf4j.model.datatypes.XMLDatatypeUtil;
import org.eclipse.rdf4j.model.impl.BooleanLiteral;
import org.eclipse.rdf4j.model.vocabulary.RSX;
import org.eclipse.rdf4j.query.algebra.evaluation.TripleSource;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.function.Function;

public class XmlDatatypeUtilFunction
implements Function {
    public String getURI() {
        return RSX.valueConformsToXsdDatatypeFunction.stringValue();
    }

    public Value evaluate(ValueFactory valueFactory, Value ... args) throws ValueExprEvaluationException {
        throw new UnsupportedOperationException();
    }

    public Value evaluate(TripleSource tripleSource, Value ... args) {
        if (args.length != 2) {
            throw new ValueExprEvaluationException("valueConformsToXsdDatatypeFunction requires exactly 2 arguments, got " + args.length);
        }
        assert (Arrays.stream(args).noneMatch(Objects::isNull));
        if (!args[0].isLiteral()) {
            throw new ValueExprEvaluationException("invalid first argument (literal expected): " + String.valueOf(args[0]));
        }
        if (!args[1].isIRI()) {
            throw new ValueExprEvaluationException("invalid second argument (IRI expected): " + String.valueOf(args[1]));
        }
        Literal literal = (Literal)args[0];
        CoreDatatype coreDatatype = CoreDatatype.from((IRI)((IRI)args[1]));
        if (literal.getCoreDatatype() != coreDatatype) {
            return BooleanLiteral.FALSE;
        }
        if (coreDatatype == CoreDatatype.NONE && !args[1].equals((Object)literal.getDatatype())) {
            return BooleanLiteral.FALSE;
        }
        if (coreDatatype.isXSDDatatype()) {
            return BooleanLiteral.valueOf((boolean)XMLDatatypeUtil.isValidValue((String)literal.stringValue(), (CoreDatatype)coreDatatype));
        }
        return BooleanLiteral.TRUE;
    }
}

