/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation;

import java.util.function.Function;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.ValueConstant;
import org.eclipse.rdf4j.query.algebra.ValueExpr;
import org.eclipse.rdf4j.query.algebra.evaluation.EvaluationStrategy;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;

public interface QueryValueEvaluationStep {
    public Value evaluate(BindingSet var1) throws QueryEvaluationException;

    default public boolean isConstant() {
        return false;
    }

    public static final class ApplyFunctionForEachBinding
    implements QueryValueEvaluationStep {
        private final Function<BindingSet, Value> function;

        public ApplyFunctionForEachBinding(Function<BindingSet, Value> function) {
            this.function = function;
        }

        @Override
        public Value evaluate(BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
            return this.function.apply(bindings);
        }
    }

    public static final class Fail
    implements QueryValueEvaluationStep {
        private final String message;

        public Fail(String message) {
            this.message = message;
        }

        @Override
        public Value evaluate(BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
            throw new ValueExprEvaluationException(this.message);
        }
    }

    public static final class Minimal
    implements QueryValueEvaluationStep {
        private final ValueExpr ve;
        private final EvaluationStrategy strategy;

        public Minimal(EvaluationStrategy strategy, ValueExpr ve) {
            this.strategy = strategy;
            this.ve = ve;
        }

        @Override
        public Value evaluate(BindingSet bindings) throws QueryEvaluationException {
            return this.strategy.evaluate(this.ve, bindings);
        }
    }

    public static class ConstantQueryValueEvaluationStep
    implements QueryValueEvaluationStep {
        private final Value value;

        public ConstantQueryValueEvaluationStep(ValueConstant valueConstant) {
            this.value = valueConstant.getValue();
        }

        public ConstantQueryValueEvaluationStep(Value valueConstant) {
            this.value = valueConstant;
        }

        @Override
        public Value evaluate(BindingSet bindings) throws QueryEvaluationException {
            return this.value;
        }

        @Override
        public boolean isConstant() {
            return true;
        }
    }
}

