/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.console;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.TypeNameMatch;
import org.eclipse.jdt.core.search.TypeNameMatchRequestor;
import org.eclipse.jdt.internal.debug.core.JavaDebugUtils;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.OpenFromClipboardAction;
import org.eclipse.jdt.internal.debug.ui.actions.OpenTypeAction;
import org.eclipse.jdt.internal.debug.ui.console.ConsoleMessages;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class JavaStackTraceHyperlink
implements IHyperlink {
    static final String ANSI_ESCAPE_REGEX = "\u001b\\[[\\d;]*[A-HJKSTfimnsu]";
    private final TextConsole fConsole;
    private final AtomicReference<String> generatedLink;
    private static final String REGEX_FOR_NORMAL = "([a-zA-Z0-9\\$]+)\\.([a-zA-Z0-9]+)\\(([^)]*)\\)";
    private static final String REGEX_FOR_GENERICS = "([a-zA-Z0-9\\$]+(?:<[a-zA-Z0-9,<>]+>)?)\\.([a-zA-Z0-9]+)\\(([^)]*)\\)";
    private static final String REGEX_FOR_INNER_CLASS = "([a-zA-Z0-9\\$]+(?:\\([a-zA-Z0-9]+\\))?)\\.([a-zA-Z0-9]+)\\(([^)]*)\\)";
    private static final String METHOD_SIGNATURE_REGEX = "\\w+\\([^)]*\\)";
    private static final String METHOD_ARGUMENTS_REGEX = "\\(([^)]*)\\)";
    private static final String INNER_CLASS_ARGUMENTS_REGEX = "\\(([^)]+)\\)";

    public JavaStackTraceHyperlink(TextConsole console) {
        this.fConsole = console;
        this.generatedLink = new AtomicReference();
    }

    public void linkEntered() {
    }

    public void linkExited() {
    }

    public void linkActivated() {
        int lineNumber;
        String typeName;
        try {
            String linkText = this.getLinkText();
            linkText = linkText.replaceAll(ANSI_ESCAPE_REGEX, "");
            this.generatedLink.set(linkText);
            typeName = this.getTypeName(linkText);
            lineNumber = this.getLineNumber(linkText);
        }
        catch (CoreException e1) {
            ErrorDialog.openError((Shell)JDIDebugUIPlugin.getActiveWorkbenchShell(), (String)ConsoleMessages.JavaStackTraceHyperlink_Error, (String)ConsoleMessages.JavaStackTraceHyperlink_Error, (IStatus)e1.getStatus());
            return;
        }
        if (lineNumber > 0) {
            --lineNumber;
        }
        this.startSourceSearch(typeName, lineNumber);
    }

    protected void startSourceSearch(final String typeName, final int lineNumber) {
        Job search = new Job(ConsoleMessages.JavaStackTraceHyperlink_2){

            protected IStatus run(IProgressMonitor monitor) {
                ILaunch launch = JavaStackTraceHyperlink.this.getLaunch();
                Object result = null;
                try {
                    result = OpenTypeAction.findTypeInWorkspace(typeName, true);
                    if (result == null && launch != null) {
                        result = JavaDebugUtils.resolveSourceElement((Object)JavaDebugUtils.generateSourceName((String)typeName), (ILaunch)JavaStackTraceHyperlink.this.getLaunch());
                    }
                    if (result == null) {
                        List<IType> types = JavaStackTraceHyperlink.findTypesInWorkspace(typeName);
                        result = types.isEmpty() ? null : (types.size() == 1 ? types.get(0) : types);
                    }
                    JavaStackTraceHyperlink.this.searchCompleted(result, typeName, lineNumber, null);
                }
                catch (CoreException e) {
                    JavaStackTraceHyperlink.this.searchCompleted(null, typeName, lineNumber, e.getStatus());
                }
                return Status.OK_STATUS;
            }
        };
        search.schedule();
    }

    private static List<IType> findTypesInWorkspace(String typeName) throws CoreException {
        String simpleName;
        char[][] qualifications;
        int dot = typeName.lastIndexOf(46);
        if (dot != -1) {
            qualifications = new char[][]{typeName.substring(0, dot).toCharArray()};
            simpleName = typeName.substring(dot + 1);
        } else {
            qualifications = null;
            simpleName = typeName;
        }
        char[][] typeNames = new char[][]{simpleName.toCharArray()};
        final ArrayList<IType> matchingTypes = new ArrayList<IType>();
        TypeNameMatchRequestor requestor = new TypeNameMatchRequestor(){

            public void acceptTypeNameMatch(TypeNameMatch match) {
                matchingTypes.add(match.getType());
            }
        };
        SearchEngine searchEngine = new SearchEngine();
        searchEngine.searchAllTypeNames((char[][])qualifications, (char[][])typeNames, SearchEngine.createWorkspaceScope(), requestor, 3, null);
        return matchingTypes;
    }

    protected void searchCompleted(final Object source, final String typeName, final int lineNumber, final IStatus status) {
        UIJob job = new UIJob("link search complete"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (source == null) {
                    if (status == null) {
                        MessageDialog.openInformation((Shell)JDIDebugUIPlugin.getActiveWorkbenchShell(), (String)ConsoleMessages.JavaStackTraceHyperlink_Information_1, (String)NLS.bind((String)ConsoleMessages.JavaStackTraceHyperlink_Source_not_found_for__0__2, (Object[])new String[]{typeName}));
                    } else {
                        JDIDebugUIPlugin.statusDialog(ConsoleMessages.JavaStackTraceHyperlink_3, status);
                    }
                } else if (source instanceof List) {
                    List matches = (List)source;
                    int line = lineNumber + 1;
                    String link = JavaStackTraceHyperlink.this.generatedLink.get();
                    if (link == null) {
                        return JavaStackTraceHyperlink.this.openClipboard(matches, line, typeName);
                    }
                    try {
                        return JavaStackTraceHyperlink.this.processAmbiguousResults(matches, typeName, lineNumber, link);
                    }
                    catch (Exception e) {
                        StringBuffer temp = new StringBuffer();
                        temp.append("Unable to parse \"" + link + "\" \n ");
                        temp.append(e.getClass().getSimpleName());
                        JavaStackTraceHyperlink.this.exceptionHandler(temp.toString(), e);
                    }
                } else {
                    JavaStackTraceHyperlink.this.processSearchResult(source, typeName, lineNumber);
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    public IStatus processAmbiguousResults(List<Object> matches, String typeName, int line, String link) {
        ArrayList<Object> exactMatchesFiltered = new ArrayList<Object>();
        Pattern pattern = Pattern.compile(REGEX_FOR_NORMAL);
        Matcher matcher = pattern.matcher(link);
        Object methodSignature = null;
        if (matcher.find()) {
            methodSignature = matcher.group(2) + "(" + matcher.group(3) + ")";
        }
        if (methodSignature == null && (matcher = (pattern = Pattern.compile(REGEX_FOR_GENERICS)).matcher(link)).find()) {
            methodSignature = matcher.group(2) + "(" + matcher.group(3) + ")";
        }
        if (methodSignature == null && (matcher = (pattern = Pattern.compile(REGEX_FOR_INNER_CLASS)).matcher(link)).find()) {
            methodSignature = matcher.group(2) + "(" + matcher.group(3) + ")";
        }
        if (methodSignature == null) {
            return this.openClipboard(matches, line, typeName);
        }
        methodSignature = ((String)methodSignature).replaceAll(" ", "");
        String methodNameExtracted = ((String)methodSignature).substring(0, ((String)methodSignature).indexOf(40));
        for (Object obj : matches) {
            if (!this.filterClasses(obj, (String)methodSignature, methodNameExtracted, link)) continue;
            exactMatchesFiltered.add(obj);
        }
        if (exactMatchesFiltered.size() == 1) {
            this.processSearchResult(exactMatchesFiltered.get(0), typeName, line);
            return Status.OK_STATUS;
        }
        if (exactMatchesFiltered.size() > 0) {
            return this.openClipboard(exactMatchesFiltered, ++line, typeName);
        }
        return this.openClipboard(matches, ++line, typeName);
    }

    public void exceptionHandler(String message, Exception e) {
        throw new RuntimeException(message, e);
    }

    private boolean filterClasses(Object obj, String methodSignature, String methodNameExtracted, String link) {
        if (obj instanceof IType) {
            IType type;
            block5: {
                type = (IType)obj;
                try {
                    if (!this.extractFromResults(type, methodSignature, methodNameExtracted)) break block5;
                    return true;
                }
                catch (Exception e) {
                    DebugUIPlugin.log((Throwable)e);
                    return false;
                }
            }
            if (link.indexOf(36) != -1 && this.extractFromInnerClassResults(type.getTypes(), methodSignature, methodNameExtracted, link)) {
                return true;
            }
        }
        return false;
    }

    private IStatus openClipboard(List<Object> results, int lineNumber, String type) {
        results = this.filterBinaryTypes(results, this.generatedLink.get());
        OpenFromClipboardAction.handleMatches(results, lineNumber, type, ConsoleMessages.JavaDebugStackTraceHyperlink_dialog_title);
        return Status.OK_STATUS;
    }

    private boolean extractFromInnerClassResults(IType[] innerClass, String methodSignature, String methodNameExtracted, String link) throws JavaModelException {
        int innerClasslevel = this.innerClassLevels(link);
        int levelTravelled = 0;
        while (innerClass.length > 0) {
            IType[] iTypeArray = innerClass;
            int n = innerClass.length;
            int n2 = 0;
            while (n2 < n) {
                IType innerType = iTypeArray[n2];
                if (innerClass.length > 0) {
                    innerClass = innerType.getTypes();
                }
                if (this.extractFromResults(innerType, methodSignature, methodNameExtracted) && ++levelTravelled == innerClasslevel) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private int innerClassLevels(String genLink) {
        int level = 0;
        char[] cArray = genLink.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            Character c = Character.valueOf(cArray[n2]);
            if (c.charValue() == '$') {
                ++level;
            }
            ++n2;
        }
        return level;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean extractFromResults(IType type, String methodSignature, String methodNameExtracted) throws JavaModelException {
        if (methodSignature.indexOf(40) == -1) return false;
        if (methodSignature.lastIndexOf(41) == -1) {
            return false;
        }
        boolean paramDetailsNotIncluded = methodSignature.contains(".java:");
        try {
            IMethod[] methods;
            IMethod[] iMethodArray = methods = type.getMethods();
            int n = methods.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IMethod method = iMethodArray[n2];
                if (paramDetailsNotIncluded && method.getElementName().equals(methodNameExtracted)) {
                    return true;
                }
                String methodDetails = method.toString();
                Pattern pattern = Pattern.compile(METHOD_SIGNATURE_REGEX);
                Matcher matcher = pattern.matcher(methodDetails);
                if (!matcher.find()) {
                    return false;
                }
                String methodName = matcher.group();
                methodName = methodName.replaceAll(" ", "");
                pattern = Pattern.compile(METHOD_ARGUMENTS_REGEX);
                matcher = pattern.matcher(methodSignature);
                if (!matcher.find()) {
                    return false;
                }
                int paramCount = matcher.group(1).split(",").length;
                if (methodName.equals(methodSignature)) {
                    return true;
                }
                if (methodNameExtracted.equals(method.getElementName()) && paramCount == method.getNumberOfParameters()) {
                    String methodSignatureGen = this.methodSignatureGenerator(method.getElementName(), methodName);
                    if (methodSignatureGen.equals(methodSignature)) {
                        return true;
                    }
                    if (methodSignature.indexOf(36) == -1) return false;
                    String methodSignatureInnerClass = this.innerClassMethodSignatureGen(methodNameExtracted, methodSignature);
                    if (methodSignatureInnerClass.equals(methodSignatureGen)) {
                        return true;
                    }
                    String paramsExtracted = methodSignature.substring(methodSignature.indexOf(40));
                    String param = paramsExtracted.substring(paramsExtracted.indexOf(36) + 1);
                    if (!(methodSignatureInnerClass = methodSignatureInnerClass.concat(param)).equals(methodSignatureGen)) return false;
                    return true;
                }
                ++n2;
            }
        }
        catch (Exception e) {
            return false;
        }
    }

    private String innerClassMethodSignatureGen(String extractedMethodName, String methodSignature) {
        StringBuilder newSignature = new StringBuilder(extractedMethodName + "(");
        Pattern pattern = Pattern.compile(INNER_CLASS_ARGUMENTS_REGEX);
        Matcher matcher = pattern.matcher(methodSignature);
        matcher.find();
        String paramsExtracted = matcher.group(1);
        if (paramsExtracted.indexOf(44) != -1) {
            String[] parameters;
            String[] stringArray = parameters = paramsExtracted.split(",");
            int n = parameters.length;
            int n2 = 0;
            while (n2 < n) {
                String param = stringArray[n2];
                newSignature.append(param.substring(param.indexOf(36) + 1));
                newSignature.append(",");
                ++n2;
            }
            newSignature.deleteCharAt(newSignature.length() - 1);
            if (newSignature.charAt(newSignature.length() - 1) != ')') {
                newSignature.append(')');
            }
        }
        return newSignature.toString();
    }

    private String methodSignatureGenerator(String methodName, String targetMethod) {
        String[] params;
        StringBuilder methodSignatureBuilder = new StringBuilder(methodName);
        methodSignatureBuilder.append('(');
        String[] stringArray = params = targetMethod.split(",");
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            String block = stringArray[n2];
            if (block.contains("...")) {
                if (params.length > 1) {
                    methodSignatureBuilder = this.varArgsParamBuilder(block, methodSignatureBuilder);
                }
            } else if (block.indexOf(46) == -1) {
                methodSignatureBuilder.append(block.substring(block.lastIndexOf(40) + 1));
                methodSignatureBuilder.append(',');
            } else {
                methodSignatureBuilder.append(block.substring(block.lastIndexOf(46) + 1));
                methodSignatureBuilder.append(',');
            }
            ++n2;
        }
        methodSignatureBuilder.deleteCharAt(methodSignatureBuilder.length() - 1);
        if (methodSignatureBuilder.charAt(methodSignatureBuilder.length() - 1) != ')') {
            methodSignatureBuilder.append(')');
        }
        return methodSignatureBuilder.toString();
    }

    private StringBuilder varArgsParamBuilder(String parameter, StringBuilder current) {
        String sub1 = parameter.substring(0, parameter.indexOf("..."));
        sub1 = sub1.substring(sub1.lastIndexOf(46) + 1);
        current.append(sub1);
        current.append("...,");
        return current;
    }

    protected void processSearchResult(Object source, String typeName, int lineNumber) {
        block5: {
            String editorId;
            IDebugModelPresentation presentation = JDIDebugUIPlugin.getDefault().getModelPresentation();
            IEditorInput editorInput = presentation.getEditorInput(source);
            if (editorInput != null && (editorId = presentation.getEditorId(editorInput, source)) != null) {
                try {
                    IEditorPart editorPart = JDIDebugUIPlugin.getActivePage().openEditor(editorInput, editorId);
                    if (!(editorPart instanceof ITextEditor) || lineNumber < 0) break block5;
                    ITextEditor textEditor = (ITextEditor)editorPart;
                    IDocumentProvider provider = textEditor.getDocumentProvider();
                    provider.connect((Object)editorInput);
                    IDocument document = provider.getDocument((Object)editorInput);
                    try {
                        IRegion line = document.getLineInformation(lineNumber);
                        textEditor.selectAndReveal(line.getOffset(), line.getLength());
                    }
                    catch (BadLocationException e) {
                        MessageDialog.openInformation((Shell)JDIDebugUIPlugin.getActiveWorkbenchShell(), (String)ConsoleMessages.JavaStackTraceHyperlink_0, (String)NLS.bind((String)"{0}{1}{2}", (Object[])new String[]{"" + (lineNumber + 1), ConsoleMessages.JavaStackTraceHyperlink_1, typeName}));
                    }
                    provider.disconnect((Object)editorInput);
                }
                catch (CoreException e) {
                    JDIDebugUIPlugin.statusDialog(e.getStatus());
                }
            }
        }
    }

    private ILaunch getLaunch() {
        IProcess process = (IProcess)this.getConsole().getAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_PROCESS");
        if (process != null) {
            return process.getLaunch();
        }
        return null;
    }

    protected String getTypeName(String linkText) throws CoreException {
        int start = linkText.lastIndexOf(40);
        int end = linkText.indexOf(58);
        if (start >= 0 && end > start) {
            int index;
            Object typeName = linkText.substring(start + 1, end);
            typeName = JavaCore.removeJavaLikeExtension((String)typeName);
            typeName = JavaStackTraceHyperlink.removeModuleInfo((String)typeName);
            String qualifier = linkText.substring(0, start);
            if ((start = qualifier.lastIndexOf(46)) >= 0 && (start = new String((String)qualifier.subSequence(0, start)).lastIndexOf(46)) == -1) {
                start = 0;
            }
            if (start >= 0) {
                qualifier = qualifier.substring(0, start);
            }
            if (qualifier.length() > 0) {
                typeName = qualifier + "." + (String)typeName;
            }
            if ((index = ((String)typeName).lastIndexOf(47)) != -1) {
                typeName = ((String)typeName).substring(index + 1);
            }
            return typeName;
        }
        Status status = new Status(4, JDIDebugUIPlugin.getUniqueIdentifier(), 0, ConsoleMessages.JavaStackTraceHyperlink_Unable_to_parse_type_name_from_hyperlink__5, null);
        throw new CoreException((IStatus)status);
    }

    protected int getLineNumber(String linkText) throws CoreException {
        int index = linkText.lastIndexOf(58);
        if (index >= 0) {
            String numText = linkText.substring(index + 1);
            if ((index = numText.indexOf(41)) >= 0) {
                numText = numText.substring(0, index);
            }
            try {
                return Integer.parseInt(numText);
            }
            catch (NumberFormatException e) {
                Status status = new Status(4, JDIDebugUIPlugin.getUniqueIdentifier(), 0, ConsoleMessages.JavaStackTraceHyperlink_Unable_to_parse_line_number_from_hyperlink__6, (Throwable)e);
                throw new CoreException((IStatus)status);
            }
        }
        Status status = new Status(4, JDIDebugUIPlugin.getUniqueIdentifier(), 0, ConsoleMessages.JavaStackTraceHyperlink_Unable_to_parse_line_number_from_hyperlink__6, null);
        throw new CoreException((IStatus)status);
    }

    protected TextConsole getConsole() {
        return this.fConsole;
    }

    protected String getLinkText() throws CoreException {
        try {
            int lastOpen;
            Object extractedTrace;
            IDocument document = this.getConsole().getDocument();
            IRegion region = this.getConsole().getRegion((IHyperlink)this);
            int regionOffset = region.getOffset();
            int lineNumber = document.getLineOfOffset(regionOffset);
            IRegion lineInformation = document.getLineInformation(lineNumber);
            int lineOffset = lineInformation.getOffset();
            String line = document.get(lineOffset, lineInformation.getLength());
            int regionOffsetInLine = regionOffset - lineOffset;
            int linkEnd = line.indexOf(41, regionOffsetInLine);
            int linkStart = line.lastIndexOf(32, regionOffsetInLine);
            if (linkStart == -1) {
                linkStart = line.lastIndexOf(9, regionOffsetInLine);
            }
            if (((String)(extractedTrace = line.substring(linkStart == -1 ? 0 : linkStart + 1, linkEnd + 1).trim())).charAt(0) == '(' && (lastOpen = line.lastIndexOf(40)) > 0 && Character.isWhitespace(line.charAt(lastOpen - 1))) {
                extractedTrace = line.substring(0, lastOpen - 1).trim() + line.substring(lastOpen);
                linkStart = ((String)extractedTrace).lastIndexOf(32, regionOffsetInLine);
                linkEnd = ((String)extractedTrace).indexOf(41, linkStart);
                return ((String)extractedTrace).substring(linkStart == -1 ? 0 : linkStart + 1, linkEnd + 1).trim();
            }
            return line.substring(linkStart == -1 ? 0 : linkStart + 1, linkEnd + 1).trim();
        }
        catch (BadLocationException e) {
            Status status = new Status(4, JDIDebugUIPlugin.getUniqueIdentifier(), 0, ConsoleMessages.JavaStackTraceHyperlink_Unable_to_retrieve_hyperlink_text__8, (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    private static String removeModuleInfo(String typeName) {
        int atIndex = typeName.lastIndexOf(64);
        int slashIndex = typeName.lastIndexOf(47);
        if (atIndex >= 0 && atIndex < slashIndex && slashIndex + 1 < typeName.length()) {
            typeName = typeName.substring(slashIndex + 1);
        }
        return typeName;
    }

    private List<Object> filterBinaryTypes(List<Object> extracted, String link) {
        if (link != null) {
            ArrayList<Object> filteredResults = new ArrayList<Object>();
            int binaryInserted = 0;
            try {
                Pattern pattern = Pattern.compile("@(.*?)\\/");
                Matcher match = pattern.matcher(link);
                if (match.find()) {
                    String jdkVersion = match.group(1);
                    for (Object ob : extracted) {
                        IType type;
                        if (ob instanceof IType && (type = (IType)ob).isBinary()) {
                            IVMInstall installedJava = JavaRuntime.getVMInstall((IJavaProject)type.getJavaProject());
                            String jdkAvailable = installedJava.getInstallLocation().getAbsolutePath();
                            if (!jdkAvailable.contains(jdkVersion)) continue;
                            filteredResults.add(ob);
                            ++binaryInserted;
                            continue;
                        }
                        filteredResults.add(ob);
                    }
                }
            }
            catch (CoreException e) {
                return extracted;
            }
            if (binaryInserted == 0) {
                return extracted;
            }
            return filteredResults;
        }
        return extracted;
    }
}

