/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.progress;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ICoreRunnable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobFunction;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.misc.UIStats;
import org.eclipse.ui.internal.progress.ProgressMessages;

public abstract class UIJob
extends Job {
    private Display cachedDisplay;

    public static UIJob create(String name, final IJobFunction function) {
        return new UIJob(name){

            @Override
            public IStatus runInUIThread(IProgressMonitor monitor) {
                return function.run(monitor);
            }
        };
    }

    public static UIJob create(String name, final ICoreRunnable runnable) {
        return new UIJob(name){

            @Override
            public IStatus runInUIThread(IProgressMonitor monitor) {
                try {
                    runnable.run(monitor);
                }
                catch (CoreException e) {
                    IStatus st = e.getStatus();
                    return new Status(st.getSeverity(), st.getPlugin(), st.getCode(), st.getMessage(), (Throwable)e);
                }
                return Status.OK_STATUS;
            }
        };
    }

    public UIJob(String name) {
        super(name);
    }

    public UIJob(Display jobDisplay, String name) {
        this(name);
        this.setDisplay(jobDisplay);
    }

    public static IStatus errorStatus(Throwable exception) {
        return WorkbenchPlugin.getStatus(exception);
    }

    public final IStatus run(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        Display asyncDisplay = this.getDisplay();
        if (asyncDisplay == null || asyncDisplay.isDisposed()) {
            return Status.CANCEL_STATUS;
        }
        Runnable runnable = () -> {
            IStatus result = null;
            Throwable throwable = null;
            try {
                try {
                    this.setThread(Thread.currentThread());
                    if (monitor.isCanceled()) {
                        result = Status.CANCEL_STATUS;
                    } else {
                        UIStats.start(13, this.getName());
                        result = this.runInUIThread(monitor);
                    }
                }
                catch (OperationCanceledException e) {
                    result = Status.CANCEL_STATUS;
                    UIStats.end(13, (Object)this, this.getName());
                    if (result == null) {
                        result = Status.error((String)ProgressMessages.InternalError, (Throwable)throwable);
                    }
                    this.done(result);
                }
                catch (Throwable t) {
                    throwable = t;
                    UIStats.end(13, (Object)this, this.getName());
                    if (result == null) {
                        result = Status.error((String)ProgressMessages.InternalError, (Throwable)throwable);
                    }
                    this.done(result);
                }
            }
            finally {
                UIStats.end(13, (Object)this, this.getName());
                if (result == null) {
                    result = Status.error((String)ProgressMessages.InternalError, (Throwable)throwable);
                }
                this.done(result);
            }
        };
        try {
            asyncDisplay.asyncExec(runnable);
        }
        catch (SWTException deviceDisposed) {
            return Status.CANCEL_STATUS;
        }
        return Job.ASYNC_FINISH;
    }

    public abstract IStatus runInUIThread(IProgressMonitor var1);

    public void setDisplay(Display runDisplay) {
        Assert.isNotNull((Object)runDisplay);
        this.cachedDisplay = runDisplay;
    }

    public Display getDisplay() {
        if (this.cachedDisplay == null && PlatformUI.isWorkbenchRunning()) {
            return PlatformUI.getWorkbench().getDisplay();
        }
        return this.cachedDisplay;
    }
}

