/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.source.inlined;

import java.util.function.Consumer;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.inlined.InlinedAnnotationDrawingStrategy;
import org.eclipse.jface.text.source.inlined.InlinedAnnotationSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;

public abstract class AbstractInlinedAnnotation
extends Annotation {
    public static final String TYPE = "org.eclipse.jface.text.source.inlined";
    private final Position position;
    private ISourceViewer fViewer;
    private InlinedAnnotationSupport support;
    int fX;
    int fY;

    protected AbstractInlinedAnnotation(Position position, ISourceViewer viewer) {
        super(TYPE, false, "");
        this.position = position;
    }

    public Position getPosition() {
        return this.position;
    }

    /*
     * WARNING - void declaration
     */
    final Position computeWidgetPosition(ITextViewer viewer) {
        ITextViewer iTextViewer = viewer;
        if (iTextViewer instanceof ITextViewerExtension5) {
            void projectionViewer;
            ITextViewerExtension5 iTextViewerExtension5 = (ITextViewerExtension5)((Object)iTextViewer);
            ITextViewerExtension5 cfr_ignored_0 = (ITextViewerExtension5)((Object)iTextViewer);
            IRegion region = projectionViewer.modelRange2WidgetRange((IRegion)new Region(this.position.getOffset(), this.position.getLength()));
            if (region != null) {
                return new Position(region.getOffset(), region.getLength());
            }
            return null;
        }
        return this.position;
    }

    public StyledText getTextWidget() {
        return this.fViewer.getTextWidget();
    }

    public ISourceViewer getViewer() {
        return this.fViewer;
    }

    public void redraw() {
        StyledText text = this.getTextWidget();
        if (text == null || text.isDisposed()) {
            return;
        }
        text.getDisplay().execute(() -> {
            if (text.isDisposed()) {
                return;
            }
            try {
                Position pos = this.getPosition();
                int offset = pos.getOffset();
                ISourceViewer viewer = this.getViewer();
                if (viewer instanceof ITextViewerExtension5) {
                    offset = ((ITextViewerExtension5)((Object)viewer)).modelOffset2WidgetOffset(offset);
                }
                InlinedAnnotationDrawingStrategy.draw(this, null, text, offset, pos.getLength(), null);
            }
            catch (RuntimeException runtimeException) {}
        });
    }

    public void draw(GC gc, StyledText textWidget, int widgetOffset, int length, Color color, int x, int y) {
        gc.setForeground(color);
        gc.setBackground(textWidget.getBackground());
        gc.drawString(this.getText(), x, y, true);
    }

    public void onMouseHover(MouseEvent e) {
        StyledText styledText = (StyledText)e.widget;
        styledText.setCursor(styledText.getDisplay().getSystemCursor(21));
    }

    public void onMouseOut(MouseEvent e) {
        StyledText styledText = (StyledText)e.widget;
        styledText.setCursor(null);
    }

    public Consumer<MouseEvent> getAction(MouseEvent e) {
        return null;
    }

    void setSupport(InlinedAnnotationSupport support) {
        this.support = support;
        this.fViewer = support.getViewer();
    }

    protected boolean isInVisibleLines() {
        return this.support.isInVisibleLines(this.getPosition().getOffset());
    }

    /*
     * WARNING - void declaration
     */
    boolean isFirstVisibleOffset(int widgetOffset, ITextViewer viewer) {
        ITextViewer iTextViewer;
        if (viewer == null) {
            viewer = this.fViewer;
        }
        if ((iTextViewer = viewer) instanceof ProjectionViewer) {
            void projectionViewer;
            ProjectionViewer projectionViewer2 = (ProjectionViewer)iTextViewer;
            ProjectionViewer cfr_ignored_0 = (ProjectionViewer)iTextViewer;
            IRegion widgetRange = projectionViewer.modelRange2WidgetRange((IRegion)new Region(this.position.getOffset(), this.position.getLength()));
            return widgetRange != null && widgetOffset == widgetRange.getOffset();
        }
        return this.position.getOffset() == widgetOffset;
    }

    protected boolean isInVisibleLines(int offset) {
        return this.support.isInVisibleLines(offset);
    }

    void setLocation(int x, int y) {
        this.fX = x;
        this.fY = y;
    }

    boolean contains(int x, int y) {
        StyledText styledText = this.getTextWidget();
        GC gc = null;
        try {
            gc = new GC((Drawable)styledText);
            boolean bl = x >= this.fX && y >= this.fY && y <= this.fY + styledText.getLineHeight(this.position.getOffset()) && (double)x <= (double)(this.fX + gc.stringExtent((String)this.getText()).x) + 2.0 * gc.getFontMetrics().getAverageCharacterWidth();
            return bl;
        }
        finally {
            if (gc != null) {
                gc.dispose();
            }
        }
    }
}

