/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otredyn.bytecode;

import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.objectteams.otredyn.bytecode.AbstractBoundClass;
import org.eclipse.objectteams.otredyn.bytecode.AbstractTeam;
import org.eclipse.objectteams.otredyn.bytecode.BytecodeProviderFactory;
import org.eclipse.objectteams.otredyn.bytecode.IBytecodeProvider;
import org.eclipse.objectteams.otredyn.bytecode.asm.AsmBoundClass;
import org.eclipse.objectteams.otredyn.bytecode.asm.AsmClassRepository;
import org.eclipse.objectteams.otredyn.runtime.IClassRepository;
import org.eclipse.objectteams.otredyn.runtime.TeamManager;

public abstract class ClassRepository
implements IClassRepository {
    private static ClassRepository instance;
    private static ThreadLocal<Class<?>> classBeingRedefined;
    protected static final String ANONYMOUS_SUBCLASS_NAME = "AnonymousSubclass";
    private Map<String, AbstractTeam> boundClassMap = new HashMap<String, AbstractTeam>();
    private Map<AbstractBoundClass, AbstractBoundClass> anonymousSubclassMap = new IdentityHashMap<AbstractBoundClass, AbstractBoundClass>();

    static {
        classBeingRedefined = new ThreadLocal();
    }

    public static void registerClassBeingRedefined(Class<?> clazz) {
        classBeingRedefined.set(clazz);
    }

    public static Class<?> popClassBeingRedefined(String className) {
        Class<?> clazz = classBeingRedefined.get();
        classBeingRedefined.set(null);
        if (clazz != null && clazz.getName().equals(className)) {
            return clazz;
        }
        return null;
    }

    protected ClassRepository() {
    }

    public static synchronized ClassRepository getInstance() {
        if (instance == null) {
            instance = new AsmClassRepository();
            TeamManager.setup((IClassRepository)instance);
        }
        return instance;
    }

    public synchronized AbstractBoundClass getBoundClass(@NonNull String className, String id, ClassLoader loader) {
        AbstractTeam clazz = this.boundClassMap.get(id);
        if (clazz == null) {
            clazz = this.createClass(className, id, BytecodeProviderFactory.getBytecodeProvider(), loader);
            this.boundClassMap.put(id, clazz);
        }
        return clazz;
    }

    public synchronized AbstractBoundClass peekBoundClass(String id) {
        return this.boundClassMap.get(id);
    }

    public synchronized AbstractBoundClass getBoundClass(@NonNull String className, String id, byte[] classBytes, ClassLoader loader, boolean isHCR) {
        AbstractTeam clazz = this.boundClassMap.get(id);
        IBytecodeProvider bytecodeProvider = BytecodeProviderFactory.getBytecodeProvider();
        bytecodeProvider.setBytecode(id, classBytes);
        if (clazz == null) {
            clazz = this.createClass(className, id, bytecodeProvider, loader);
        } else if (isHCR) {
            clazz.setBytecode(classBytes);
            clazz.restartTransformation();
        }
        this.boundClassMap.put(id, clazz);
        clazz.setLoaded();
        return clazz;
    }

    public void linkClassWithSuperclass(AbstractBoundClass clazz) {
        AbstractBoundClass anonymousSubclass;
        AbstractBoundClass superclass = clazz.getSuperclass();
        if (superclass == null) {
            return;
        }
        if (superclass instanceof AsmBoundClass && !((AsmBoundClass)superclass).parsed) {
            this.linkClassWithSuperclass(superclass);
        }
        if ((anonymousSubclass = this.anonymousSubclassMap.get(superclass)) != null) {
            AbstractTeam newAnonymousSubclass = this.createClass(ANONYMOUS_SUBCLASS_NAME, ANONYMOUS_SUBCLASS_NAME, BytecodeProviderFactory.getBytecodeProvider(), clazz.getClassLoader());
            superclass.removeSubclass(anonymousSubclass);
            superclass.addSubclass(newAnonymousSubclass);
            superclass.addSubclass(clazz);
            newAnonymousSubclass.mergeTasks(anonymousSubclass);
            clazz.mergeTasks(anonymousSubclass);
            anonymousSubclass.performWiringTasks(superclass, clazz);
            this.anonymousSubclassMap.put(superclass, newAnonymousSubclass);
        }
    }

    public AbstractTeam getTeam(@NonNull String teamName, String id, ClassLoader loader) {
        return (AbstractTeam)this.getBoundClass(teamName, id, loader);
    }

    protected AbstractBoundClass getAnonymousSubclass(AbstractBoundClass abstractBoundClass) {
        AbstractBoundClass anonymousSubclass = this.anonymousSubclassMap.get(abstractBoundClass);
        if (anonymousSubclass == null) {
            anonymousSubclass = this.createClass(ANONYMOUS_SUBCLASS_NAME, ANONYMOUS_SUBCLASS_NAME, BytecodeProviderFactory.getBytecodeProvider(), abstractBoundClass.getClassLoader());
            anonymousSubclass.setSuperClassName(abstractBoundClass.getName());
            this.anonymousSubclassMap.put((AbstractTeam)abstractBoundClass, anonymousSubclass);
        }
        return anonymousSubclass;
    }

    protected abstract AbstractTeam createClass(@NonNull String var1, String var2, IBytecodeProvider var3, ClassLoader var4);
}

