/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.internal.jdt.nullity.quickfix;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFix;
import org.eclipse.jdt.internal.corext.fix.IProposableFix;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.text.correction.ProblemLocation;
import org.eclipse.jdt.internal.ui.text.correction.proposals.FixCorrectionProposal;
import org.eclipse.jdt.ui.cleanup.ICleanUp;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jdt.ui.text.java.IQuickFixProcessor;
import org.eclipse.objectteams.internal.jdt.nullity.quickfix.FixMessages;
import org.eclipse.objectteams.internal.jdt.nullity.quickfix.NullAnnotationsCleanUp;
import org.eclipse.objectteams.internal.jdt.nullity.quickfix.RewriteOperations;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuickFixes
implements IQuickFixProcessor {
    public boolean hasCorrections(ICompilationUnit cu, int problemId) {
        switch (problemId) {
            case 67109744: 
            case 67109745: 
            case 67109747: 
            case 67109748: 
            case 67109755: 
            case 536871369: 
            case 536871370: {
                return true;
            }
        }
        return false;
    }

    public IJavaCompletionProposal[] getCorrections(IInvocationContext context, IProblemLocation[] locations) throws CoreException {
        if (locations == null || locations.length == 0) {
            return null;
        }
        HashSet<Integer> handledProblems = new HashSet<Integer>(locations.length);
        ArrayList<IJavaCompletionProposal> resultingCollections = new ArrayList<IJavaCompletionProposal>();
        int i = 0;
        while (i < locations.length) {
            IProblemLocation curr = locations[i];
            Integer id = new Integer(curr.getProblemId());
            if (handledProblems.add(id)) {
                this.process(context, curr, resultingCollections);
            }
            ++i;
        }
        return resultingCollections.toArray(new IJavaCompletionProposal[resultingCollections.size()]);
    }

    void process(IInvocationContext context, IProblemLocation problem, Collection<IJavaCompletionProposal> proposals) {
        int id = problem.getProblemId();
        if (id == 0) {
            return;
        }
        switch (id) {
            case 67109744: 
            case 67109745: 
            case 67109747: 
            case 67109748: 
            case 67109755: 
            case 67109756: 
            case 67109757: {
                this.addNullAnnotationInSignatureProposal(context, problem, proposals);
                break;
            }
            case 536871369: 
            case 536871370: {
                if (!this.isComplainingAboutArgument(context, problem)) break;
                this.addNullAnnotationInSignatureProposal(context, problem, proposals);
            }
        }
    }

    void addNullAnnotationInSignatureProposal(IInvocationContext context, IProblemLocation problem, Collection proposals) {
        MyCURewriteOperationsFix fix = this.createNullAnnotationInSignatureFix(context.getASTRoot(), problem);
        if (fix != null) {
            Image image = JavaPluginImages.get((String)"org.eclipse.jdt.ui.correction_change.gif");
            Hashtable<String, String> options = new Hashtable<String, String>();
            if (fix.cu != context.getASTRoot()) {
                final CompilationUnit cu = fix.cu;
                final IInvocationContext originalContext = context;
                context = new IInvocationContext(){

                    public int getSelectionOffset() {
                        return originalContext.getSelectionOffset();
                    }

                    public int getSelectionLength() {
                        return originalContext.getSelectionLength();
                    }

                    public ASTNode getCoveringNode() {
                        return originalContext.getCoveringNode();
                    }

                    public ASTNode getCoveredNode() {
                        return originalContext.getCoveredNode();
                    }

                    public ICompilationUnit getCompilationUnit() {
                        return (ICompilationUnit)cu.getJavaElement();
                    }

                    public CompilationUnit getASTRoot() {
                        return cu;
                    }
                };
            }
            FixCorrectionProposal proposal = new FixCorrectionProposal((IProposableFix)fix, (ICleanUp)new NullAnnotationsCleanUp(options, this, problem.getProblemId()), 15, image, context);
            proposals.add(proposal);
        }
    }

    boolean isComplainingAboutArgument(IInvocationContext context, IProblemLocation problem) {
        CompilationUnit astRoot = context.getASTRoot();
        ASTNode selectedNode = problem.getCoveringNode(astRoot);
        if (!(selectedNode instanceof SimpleName)) {
            return false;
        }
        SimpleName nameNode = (SimpleName)selectedNode;
        IBinding binding = nameNode.resolveBinding();
        return binding.getKind() == 3 && ((IVariableBinding)binding).isParameter();
    }

    MyCURewriteOperationsFix createNullAnnotationInSignatureFix(CompilationUnit compilationUnit, IProblemLocation problem) {
        String nullableAnnotationName = QuickFixes.getNullableAnnotationName(compilationUnit.getJavaElement(), false);
        String nonNullAnnotationName = QuickFixes.getNonNullAnnotationName(compilationUnit.getJavaElement(), false);
        String annotationToAdd = nullableAnnotationName;
        String annotationToRemove = nonNullAnnotationName;
        switch (problem.getProblemId()) {
            case 67109756: 
            case 67109757: {
                annotationToAdd = nonNullAnnotationName;
                annotationToRemove = nullableAnnotationName;
            }
        }
        RewriteOperations.SignatureAnnotationRewriteOperation operation = RewriteOperations.createAddAnnotationOperation(compilationUnit, problem, annotationToAdd, annotationToRemove, null, false, true);
        if (operation == null) {
            return null;
        }
        return new MyCURewriteOperationsFix(operation.getMessage(), operation.getCompilationUnit(), new RewriteOperations.SignatureAnnotationRewriteOperation[]{operation});
    }

    public ICleanUpFix createCleanUp(CompilationUnit compilationUnit, IProblemLocation[] locations, int problemID) {
        ICompilationUnit cu = (ICompilationUnit)compilationUnit.getJavaElement();
        if (!JavaModelUtil.is50OrHigher((IJavaProject)cu.getJavaProject())) {
            return null;
        }
        ArrayList operations = new ArrayList();
        if (locations == null) {
            IProblem[] problems = compilationUnit.getProblems();
            locations = new IProblemLocation[problems.length];
            int i = 0;
            while (i < problems.length) {
                if (problems[i].getID() == problemID) {
                    locations[i] = new ProblemLocation(problems[i]);
                }
                ++i;
            }
        }
        this.createAddNullAnnotationOperations(compilationUnit, locations, operations);
        if (operations.size() == 0) {
            return null;
        }
        CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation[] operationsArray = operations.toArray(new CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation[operations.size()]);
        return new MyCURewriteOperationsFix(FixMessages.QuickFixes_add_annotation_change_name, compilationUnit, operationsArray);
    }

    void createAddNullAnnotationOperations(CompilationUnit compilationUnit, IProblemLocation[] locations, List result) {
        String nullableAnnotationName = QuickFixes.getNullableAnnotationName(compilationUnit.getJavaElement(), false);
        String nonNullAnnotationName = QuickFixes.getNonNullAnnotationName(compilationUnit.getJavaElement(), false);
        HashSet<String> handledPositions = new HashSet<String>();
        int i = 0;
        while (i < locations.length) {
            IProblemLocation problem = locations[i];
            if (problem != null) {
                String annotationToAdd = nullableAnnotationName;
                String annotationToRemove = nonNullAnnotationName;
                switch (problem.getProblemId()) {
                    case 67109756: 
                    case 67109757: {
                        annotationToAdd = nonNullAnnotationName;
                        annotationToRemove = nullableAnnotationName;
                    }
                }
                RewriteOperations.SignatureAnnotationRewriteOperation fix = RewriteOperations.createAddAnnotationOperation(compilationUnit, problem, annotationToAdd, annotationToRemove, handledPositions, true, false);
                if (fix != null) {
                    result.add(fix);
                }
            }
            ++i;
        }
    }

    public static boolean isMissingNullAnnotationProblem(int id) {
        return id == 67109744 || id == 67109745 || id == 67109747 || id == 67109748 || id == 67109755 || QuickFixes.mayIndicateParameterNullcheck(id);
    }

    public static boolean mayIndicateParameterNullcheck(int problemId) {
        return problemId == 536871370 || problemId == 536871369;
    }

    public static boolean hasExplicitNullAnnotation(ICompilationUnit compilationUnit, int offset) {
        return false;
    }

    public static String getNullableAnnotationName(IJavaElement javaElement, boolean makeSimple) {
        int lastDot;
        String qualifiedName = javaElement.getJavaProject().getOption("org.eclipse.jdt.core.compiler.annotation.nullable", true);
        if (makeSimple && qualifiedName != null && (lastDot = qualifiedName.lastIndexOf(46)) != -1) {
            return qualifiedName.substring(lastDot + 1);
        }
        return qualifiedName;
    }

    public static String getNonNullAnnotationName(IJavaElement javaElement, boolean makeSimple) {
        int lastDot;
        String qualifiedName = javaElement.getJavaProject().getOption("org.eclipse.jdt.core.compiler.annotation.nonnull", true);
        if (makeSimple && qualifiedName != null && (lastDot = qualifiedName.lastIndexOf(46)) != -1) {
            return qualifiedName.substring(lastDot + 1);
        }
        return qualifiedName;
    }

    static class MyCURewriteOperationsFix
    extends CompilationUnitRewriteOperationsFix {
        CompilationUnit cu;

        public MyCURewriteOperationsFix(String name, CompilationUnit compilationUnit, CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation[] operations) {
            super(name, compilationUnit, operations);
            this.cu = compilationUnit;
        }
    }
}

