/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.commonmark.internal.blocks;

import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.commonmark.internal.CommonMark;
import org.eclipse.mylyn.wikitext.commonmark.internal.Line;
import org.eclipse.mylyn.wikitext.commonmark.internal.LinePredicates;
import org.eclipse.mylyn.wikitext.commonmark.internal.LineSequence;
import org.eclipse.mylyn.wikitext.commonmark.internal.ProcessingContext;
import org.eclipse.mylyn.wikitext.commonmark.internal.ProcessingContextBuilder;
import org.eclipse.mylyn.wikitext.commonmark.internal.SourceBlock;
import org.eclipse.mylyn.wikitext.commonmark.internal.SourceBlocks;
import org.eclipse.mylyn.wikitext.commonmark.internal.blocks.BlockWithNestedBlocks;
import org.eclipse.mylyn.wikitext.commonmark.internal.blocks.ParagraphBlock;
import org.eclipse.mylyn.wikitext.parser.Attributes;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;

public class BlockQuoteBlock
extends BlockWithNestedBlocks {
    private static final Pattern START_PATTERN = Pattern.compile("\\s{0,3}>\\s?(.*)");

    @Override
    public void process(ProcessingContext context, DocumentBuilder builder, LineSequence lineSequence) {
        builder.setLocator(lineSequence.getCurrentLine().toLocator());
        builder.beginBlock(DocumentBuilder.BlockType.QUOTE, new Attributes());
        SourceBlocks sourceBlocks = CommonMark.sourceBlocks();
        BlockQuoteState blockQuoteState = new BlockQuoteState();
        sourceBlocks.process(context, builder, blockQuoteState.blockQuoteLineSequence(lineSequence), blockQuoteState.contextPredicate());
        builder.endBlock();
    }

    @Override
    public void createContext(ProcessingContextBuilder contextBuilder, LineSequence lineSequence) {
        SourceBlocks sourceBlocks = CommonMark.sourceBlocks();
        BlockQuoteState blockQuoteState = new BlockQuoteState();
        sourceBlocks.createContext(contextBuilder, blockQuoteState.blockQuoteLineSequence(lineSequence), blockQuoteState.contextPredicate());
    }

    @Override
    public boolean canStart(LineSequence lineSequence) {
        return this.canStart(lineSequence.getCurrentLine());
    }

    private boolean canStart(Line line) {
        return line != null && START_PATTERN.matcher(line.getText()).matches();
    }

    private static class BlockQuoteState {
        private SourceBlock currentBlock;

        private BlockQuoteState() {
        }

        Predicate<SourceBlocks.BlockContext> contextPredicate() {
            return context -> {
                this.currentBlock = context.getCurrentBlock();
                return true;
            };
        }

        LineSequence blockQuoteLineSequence(LineSequence lineSequence) {
            return lineSequence.with(this.blockQuoteLinePredicate(lineSequence)).transform(this.blockQuoteLineTransform());
        }

        private Function<Line, Line> blockQuoteLineTransform() {
            return line -> {
                Matcher matcher = START_PATTERN.matcher(line.getText());
                if (matcher.matches()) {
                    int start = matcher.start(1);
                    return line.segment(start, matcher.end(1) - start);
                }
                return line;
            };
        }

        private Predicate<Line> blockQuoteLinePredicate(LineSequence lineSequence) {
            return LinePredicates.empty().negate().and(this.blockStructureStart(lineSequence).negate());
        }

        private Predicate<Line> blockStructureStart(final LineSequence lineSequence) {
            return new Predicate<Line>(){

                @Override
                public boolean test(Line line) {
                    LineSequence lookAhead = this.createLookAhead(lineSequence, line);
                    SourceBlock lineBlock = CommonMark.sourceBlocks().selectBlock(lookAhead);
                    return lineBlock != null && !this.isLazyContinuation(lineBlock) && !(lineBlock instanceof BlockQuoteBlock);
                }

                private boolean isLazyContinuation(SourceBlock lineBlock) {
                    return lineBlock instanceof ParagraphBlock && (currentBlock instanceof BlockQuoteBlock || currentBlock instanceof ParagraphBlock);
                }

                private LineSequence createLookAhead(LineSequence lineSequence2, Line line) {
                    LineSequence lookAhead = lineSequence2.lookAhead();
                    while (lookAhead.getCurrentLine() != null && lookAhead.getCurrentLine().getLineNumber() < line.getLineNumber()) {
                        lookAhead.advance();
                    }
                    return lookAhead;
                }
            };
        }
    }
}

