/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.external;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.IOUtils;
import org.apache.tika.io.NullOutputStream;
import org.apache.tika.io.TemporaryResources;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ExternalParser
extends AbstractParser {
    private static final long serialVersionUID = -1079128990650687037L;
    public static final String INPUT_FILE_TOKEN = "${INPUT}";
    public static final String OUTPUT_FILE_TOKEN = "${OUTPUT}";
    private Set<MediaType> supportedTypes = Collections.emptySet();
    private Map<Pattern, String> metadataPatterns = null;
    private String[] command = new String[]{"cat"};

    @Override
    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return this.getSupportedTypes();
    }

    public Set<MediaType> getSupportedTypes() {
        return this.supportedTypes;
    }

    public void setSupportedTypes(Set<MediaType> supportedTypes) {
        this.supportedTypes = Collections.unmodifiableSet(new HashSet<MediaType>(supportedTypes));
    }

    public String[] getCommand() {
        return this.command;
    }

    public void setCommand(String ... command) {
        this.command = command;
    }

    public Map<Pattern, String> getMetadataExtractionPatterns() {
        return this.metadataPatterns;
    }

    public void setMetadataExtractionPatterns(Map<Pattern, String> patterns) {
        this.metadataPatterns = patterns;
    }

    @Override
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        TemporaryResources tmp = new TemporaryResources();
        try {
            this.parse(TikaInputStream.get(stream, tmp), xhtml, metadata, tmp);
        }
        finally {
            tmp.dispose();
        }
    }

    private void parse(TikaInputStream stream, XHTMLContentHandler xhtml, Metadata metadata, TemporaryResources tmp) throws IOException, SAXException, TikaException {
        boolean inputToStdIn = true;
        boolean outputFromStdOut = true;
        boolean hasPatterns = this.metadataPatterns != null && !this.metadataPatterns.isEmpty();
        File output = null;
        String[] cmd = new String[this.command.length];
        System.arraycopy(this.command, 0, cmd, 0, this.command.length);
        int i = 0;
        while (i < cmd.length) {
            if (cmd[i].indexOf(INPUT_FILE_TOKEN) != -1) {
                cmd[i] = cmd[i].replace(INPUT_FILE_TOKEN, stream.getFile().getPath());
                inputToStdIn = false;
            }
            if (cmd[i].indexOf(OUTPUT_FILE_TOKEN) != -1) {
                output = tmp.createTemporaryFile();
                outputFromStdOut = false;
            }
            ++i;
        }
        Process process = cmd.length == 1 ? Runtime.getRuntime().exec(cmd[0]) : Runtime.getRuntime().exec(cmd);
        try {
            if (inputToStdIn) {
                this.sendInput(process, stream);
            } else {
                process.getOutputStream().close();
            }
            InputStream out = process.getInputStream();
            InputStream err = process.getErrorStream();
            if (hasPatterns) {
                this.extractMetadata(err, metadata);
                if (outputFromStdOut) {
                    this.extractOutput(out, xhtml);
                } else {
                    this.extractMetadata(out, metadata);
                }
            } else {
                this.ignoreStream(err);
                if (outputFromStdOut) {
                    this.extractOutput(out, xhtml);
                } else {
                    this.ignoreStream(out);
                }
            }
        }
        finally {
            try {
                process.waitFor();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (!outputFromStdOut) {
            this.extractOutput(new FileInputStream(output), xhtml);
        }
    }

    private void extractOutput(InputStream stream, XHTMLContentHandler xhtml) throws SAXException, IOException {
        InputStreamReader reader = new InputStreamReader(stream);
        try {
            xhtml.startDocument();
            xhtml.startElement("p");
            char[] buffer = new char[1024];
            int n = reader.read(buffer);
            while (n != -1) {
                xhtml.characters(buffer, 0, n);
                n = reader.read(buffer);
            }
            xhtml.endElement("p");
            xhtml.endDocument();
        }
        finally {
            ((Reader)reader).close();
        }
    }

    private void sendInput(final Process process, final InputStream stream) {
        new Thread(){

            @Override
            public void run() {
                OutputStream stdin = process.getOutputStream();
                try {
                    IOUtils.copy(stream, stdin);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }.start();
    }

    private void ignoreStream(final InputStream stream) {
        new Thread(){

            @Override
            public void run() {
                try {
                    try {
                        IOUtils.copy(stream, (OutputStream)new NullOutputStream());
                    }
                    catch (IOException iOException) {
                        IOUtils.closeQuietly(stream);
                    }
                }
                finally {
                    IOUtils.closeQuietly(stream);
                }
            }
        }.start();
    }

    private void extractMetadata(final InputStream stream, final Metadata metadata) {
        new Thread(){

            @Override
            public void run() {
                BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
                try {
                    try {
                        String line;
                        while ((line = reader.readLine()) != null) {
                            for (Pattern p : ExternalParser.this.metadataPatterns.keySet()) {
                                Matcher m = p.matcher(line);
                                if (!m.find()) continue;
                                metadata.add((String)ExternalParser.this.metadataPatterns.get(p), m.group(1));
                            }
                        }
                    }
                    catch (IOException iOException) {
                        IOUtils.closeQuietly(reader);
                        IOUtils.closeQuietly(stream);
                    }
                }
                finally {
                    IOUtils.closeQuietly(reader);
                    IOUtils.closeQuietly(stream);
                }
            }
        }.start();
    }

    public static boolean check(String checkCmd, int ... errorValue) {
        return ExternalParser.check(new String[]{checkCmd}, errorValue);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean check(String[] checkCmd, int ... errorValue) {
        if (errorValue.length == 0) {
            errorValue = new int[]{127};
        }
        try {
            Process process = checkCmd.length == 1 ? Runtime.getRuntime().exec(checkCmd[0]) : Runtime.getRuntime().exec(checkCmd);
            int result = process.waitFor();
            int[] nArray = errorValue;
            int n = errorValue.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return true;
                }
                int err = nArray[n2];
                if (result == err) {
                    return false;
                }
                ++n2;
            }
        }
        catch (IOException e) {
            return false;
        }
        catch (InterruptedException ie) {
            return false;
        }
    }
}

