/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.converter.ui;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionDelegate;

public abstract class OpenWizardActionDelegate
extends ActionDelegate
implements IEditorActionDelegate {
    protected boolean fixedFile = false;
    protected IFile file;

    public OpenWizardActionDelegate() {
    }

    public OpenWizardActionDelegate(IEditorPart editorPart) {
        this();
    }

    public void dispose() {
        this.file = null;
        super.dispose();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (this.fixedFile) {
            return;
        }
        if (selection instanceof IStructuredSelection) {
            URI uri;
            GenModel genModel;
            Resource resource;
            Object object = ((IStructuredSelection)selection).getFirstElement();
            if (object instanceof IFile) {
                this.file = (IFile)object;
                action.setEnabled(true);
                return;
            }
            if (object instanceof GenModel && (resource = (genModel = (GenModel)object).eResource()) != null && (uri = resource.getURI()).isPlatformResource()) {
                this.file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uri.toPlatformString(true)));
                if (this.file.exists()) {
                    action.setEnabled(true);
                    return;
                }
            }
        }
        this.file = null;
        action.setEnabled(false);
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        IEditorInput input;
        if (targetEditor != null && (input = targetEditor.getEditorInput()) instanceof IFileEditorInput) {
            this.file = ((IFileEditorInput)input).getFile();
            this.fixedFile = true;
            action.setEnabled(true);
            return;
        }
        this.file = null;
        action.setEnabled(false);
    }

    public void run(IAction action) {
        this.run(PlatformUI.getWorkbench(), PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), this.file);
    }

    protected void run(IWorkbench workbench, Shell shell, IFile file) {
        IWizard wizard = this.createWizard(workbench, shell, file);
        WizardDialog wizardDialog = new WizardDialog(shell, wizard);
        wizardDialog.create();
        wizardDialog.getShell().setSize(Math.max(540, wizardDialog.getShell().getSize().x), 580);
        wizardDialog.open();
    }

    protected abstract IWizard createWizard(IWorkbench var1, Shell var2, IFile var3);
}

