/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.examples.jet.article2.codegen;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.codegen.jet.JETEmitter;
import org.eclipse.emf.codegen.jet.JETException;
import org.eclipse.emf.codegen.merge.java.JControlModel;
import org.eclipse.emf.codegen.merge.java.JMerger;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.DiagnosticException;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.examples.jet.article2.codegen.Config;

public class JETGateway {
    private Config mConfig = null;

    public JETGateway(Config config) {
        this.mConfig = config;
    }

    public String generate(IProgressMonitor monitor) throws CoreException {
        try {
            monitor = this.createIfNull(monitor);
            Config config = this.getConfig();
            JETEmitter emitter = new JETEmitter(config.getTemplateFullUri(), this.getClass().getClassLoader());
            emitter.addVariable(config.getClasspathVariable(), config.getPluginId());
            BasicMonitor.EclipseSubProgress sub = new BasicMonitor.EclipseSubProgress(monitor, 1);
            String result = emitter.generate((Monitor)sub, new Object[]{config.getModel()});
            monitor.worked(1);
            return result;
        }
        catch (JETException exception) {
            throw DiagnosticException.toCoreException((DiagnosticException)exception);
        }
    }

    public String merge(IProgressMonitor monitor, String emitterResult) throws CoreException {
        Config config;
        IContainer container = this.findOrCreateContainer(monitor = this.createIfNull(monitor), (config = this.getConfig()).getTargetFolder(), config.getPackageName());
        if (container == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.emf.examples.jet.article2", 0, "Could not find or create container for package " + config.getPackageName() + " in " + config.getTargetFolder(), null));
        }
        IFile targetFile = container.getFile((IPath)new Path(config.getTargetFile()));
        if (!targetFile.exists()) {
            monitor.worked(1);
            return emitterResult;
        }
        JControlModel jControlModel = new JControlModel();
        jControlModel.initialize(CodeGenUtil.instantiateFacadeHelper((String)JMerger.DEFAULT_FACADE_HELPER_CLASS), config.getMergeXmlFullUri());
        JMerger jMerger = new JMerger(jControlModel);
        jMerger.setSourceCompilationUnit(jMerger.createCompilationUnitForContents(emitterResult));
        jMerger.setTargetCompilationUnit(jMerger.createCompilationUnitForInputStream(targetFile.getContents(true)));
        String oldContents = jControlModel.getFacadeHelper().getOriginalContents(jMerger.getTargetCompilationUnit());
        jMerger.merge();
        monitor.worked(1);
        String result = jMerger.getTargetCompilationUnitContents();
        if (oldContents.equals(result)) {
            return result;
        }
        if (!targetFile.isReadOnly()) {
            return result;
        }
        if (targetFile.getWorkspace().validateEdit(new IFile[]{targetFile}, (Object)new SubProgressMonitor(monitor, 1)).isOK()) {
            jMerger.setTargetCompilationUnit(jMerger.createCompilationUnitForInputStream(targetFile.getContents(true)));
            jMerger.remerge();
            return jMerger.getTargetCompilationUnitContents();
        }
        return result;
    }

    public IFile save(IProgressMonitor monitor, byte[] contents) throws CoreException {
        Config config;
        IContainer container = this.findOrCreateContainer(monitor = this.createIfNull(monitor), (config = this.getConfig()).getTargetFolder(), config.getPackageName());
        if (container == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.emf.examples.jet.article2", 0, "Could not find or create container for package " + config.getPackageName() + " in " + config.getTargetFolder(), null));
        }
        IFile targetFile = container.getFile((IPath)new Path(config.getTargetFile()));
        IFile result = this.getWritableTargetFile(targetFile, container, config.getTargetFile());
        ByteArrayInputStream newContents = new ByteArrayInputStream(contents);
        if (result.exists()) {
            result.setContents((InputStream)newContents, true, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        } else {
            result.create((InputStream)newContents, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        return result;
    }

    private IProgressMonitor createIfNull(IProgressMonitor monitor) {
        if (monitor == null) {
            return new NullProgressMonitor();
        }
        return monitor;
    }

    private IContainer findOrCreateContainer(IProgressMonitor progressMonitor, String targetDirectory, String packageName) throws CoreException {
        Path outputPath = new Path(String.valueOf(targetDirectory) + "/" + packageName.replace('.', '/'));
        progressMonitor.beginTask("", 4);
        SubProgressMonitor sub = new SubProgressMonitor(progressMonitor, 1);
        IPath localLocation = null;
        IContainer container = CodeGenUtil.EclipseUtil.findOrCreateContainer((IPath)outputPath, (boolean)true, localLocation, (IProgressMonitor)sub);
        return container;
    }

    private IFile getWritableTargetFile(IFile targetFile, IContainer container, String fileName) {
        if (targetFile.isReadOnly()) {
            if (this.getConfig().isForceOverwrite()) {
                ResourceAttributes attributes = targetFile.getResourceAttributes();
                attributes.setReadOnly(false);
                try {
                    targetFile.setResourceAttributes(attributes);
                }
                catch (CoreException coreException) {}
            } else {
                targetFile = container.getFile((IPath)new Path("." + fileName + ".new"));
            }
        }
        return targetFile;
    }

    protected Config getConfig() {
        return this.mConfig;
    }
}

