/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.common.links;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.uml2.diagram.common.links.InterfaceLinkFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterfaceLinkManager<T> {
    protected static boolean ourHideReferencedGenuine;
    protected static boolean ourHideDerived;
    protected final List<InterfaceLinkFilter<T>> myLinkManagers = new ArrayList<InterfaceLinkFilter<T>>(3);

    public InterfaceLinkManager(Collection<T> linkDescriptors, IPreferenceStore store) {
        InterfaceLinkManager.refreshOptions(store);
        this.buildTable(linkDescriptors);
    }

    public Collection<T> getFilteredLinkDescriptors() {
        ArrayList<T> result = new ArrayList<T>();
        for (InterfaceLinkFilter<T> manager : this.myLinkManagers) {
            result.addAll(manager.getFilteredLinks());
        }
        return result;
    }

    protected void initFilters() {
    }

    private static void refreshOptions(IPreferenceStore store) {
        ourHideDerived = store.getBoolean("org.eclipse.uml2.diagram.preferences.required_links_group.hide_derived");
        ourHideReferencedGenuine = store.getBoolean("org.eclipse.uml2.diagram.preferences.required_links_group.hide_genuine");
    }

    private void buildTable(Collection<T> linkDescriptors) {
        this.initFilters();
        for (T next : linkDescriptors) {
            for (InterfaceLinkFilter<T> manager : this.myLinkManagers) {
                manager.visit(next);
            }
        }
    }
}

