/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eodm.impl;

import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.eodm.impl.EODMImplPackage;
import org.eclipse.eodm.impl.InternalCore;
import org.eclipse.eodm.rdf.rdfbase.RDFGraph;
import org.eclipse.eodm.rdf.rdfbase.RDFSLiteral;
import org.eclipse.eodm.rdf.rdfbase.RDFSResource;
import org.eclipse.eodm.rdf.rdfbase.URIReference;
import org.eclipse.eodm.rdf.rdfbase.impl.RDFGraphImpl;
import org.eclipse.eodm.util.RDFUtility;
import org.eclipse.eodm.util.Triple;

public class GraphIterator
implements Iterator {
    protected RDFGraphImpl graph;
    protected Iterator entityIterator;
    protected InternalCore coreObject;
    protected int[] entityMark = new int[RDFUtility.getPredicates().size() + 1];

    protected boolean isMarksEmpty() {
        int i = 0;
        while (i < RDFUtility.getPredicates().size() + 1) {
            if (this.entityMark[i] > 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void calculateMarks(InternalCore coreObject) {
        int i = 0;
        while (i < RDFUtility.getPredicates().size() + 1) {
            this.entityMark[i] = 0;
            ++i;
        }
        i = 0;
        while (i < RDFUtility.getPredicates().size()) {
            String predicate = (String)RDFUtility.getPredicates().get(i);
            int featureId = RDFUtility.getFeatureIDbyPredicateURI(predicate);
            EStructuralFeature eStructuralFeature = EODMImplPackage.eINSTANCE.getInternalCore().getEStructuralFeature(featureId);
            if (coreObject.eIsSet(eStructuralFeature)) {
                this.entityMark[i] = eStructuralFeature.getUpperBound() == -1 ? ((EList)coreObject.eGet(eStructuralFeature)).size() : 1;
            }
            ++i;
        }
        this.entityMark[RDFUtility.getPredicates().size()] = coreObject.getCustomTriples().size();
    }

    public GraphIterator(RDFGraph graph) {
        this.graph = (RDFGraphImpl)graph;
        this.entityIterator = this.graph.getEntityHashMap().keySet().iterator();
        if (this.entityIterator.hasNext()) {
            this.coreObject = (InternalCore)this.graph.getEntityHashMap().get(this.entityIterator.next());
            this.calculateMarks(this.coreObject);
        } else {
            this.coreObject = null;
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean hasNext() {
        if (this.coreObject == null) {
            return false;
        }
        if (this.isMarksEmpty()) ** GOTO lbl9
        return true;
lbl-1000:
        // 1 sources

        {
            this.coreObject = (InternalCore)this.graph.getEntityHashMap().get((String)this.entityIterator.next());
            this.calculateMarks(this.coreObject);
            if (this.isMarksEmpty()) continue;
            return true;
lbl9:
            // 2 sources

            ** while (this.entityIterator.hasNext())
        }
lbl10:
        // 1 sources

        this.coreObject = null;
        return false;
    }

    public Object next() {
        if (!this.hasNext()) {
            return null;
        }
        int i = 0;
        while (i < RDFUtility.getPredicates().size()) {
            if (this.entityMark[i] > 0) {
                RDFSResource rdfsResource;
                Triple triple = new Triple();
                if (this.coreObject.getNodeID() != null && !this.coreObject.getNodeID().equals("")) {
                    triple.setSubjectNodeID(this.coreObject.getNodeID());
                } else {
                    triple.setSubjectUriRef((URIReference)this.coreObject.getUriRef().get(0));
                }
                String predicate = (String)RDFUtility.getPredicates().get(i);
                triple.setPredicate(predicate);
                int featureId = RDFUtility.getFeatureIDbyPredicateURI(predicate);
                EStructuralFeature eStructuralFeature = EODMImplPackage.eINSTANCE.getInternalCore().getEStructuralFeature(featureId);
                if (eStructuralFeature.getUpperBound() == -1) {
                    EList objectList = (EList)this.coreObject.eGet(eStructuralFeature);
                    rdfsResource = (RDFSResource)objectList.get(this.entityMark[i] - 1);
                    int n = i;
                    this.entityMark[n] = this.entityMark[n] - 1;
                } else {
                    rdfsResource = (RDFSResource)this.coreObject.eGet(eStructuralFeature);
                    this.entityMark[i] = 0;
                }
                if (rdfsResource.getNodeID() != null && !rdfsResource.getNodeID().equals("")) {
                    triple.setObjectNodeID(rdfsResource.getNodeID());
                } else if (rdfsResource instanceof RDFSLiteral) {
                    triple.setObjectLiteral((RDFSLiteral)rdfsResource);
                } else {
                    triple.setObjectUriRef((URIReference)rdfsResource.getUriRef().get(0));
                }
                return triple;
            }
            ++i;
        }
        Triple triple = (Triple)this.coreObject.getCustomTriples().get(this.entityMark[RDFUtility.getPredicates().size()] - 1);
        int n = RDFUtility.getPredicates().size();
        this.entityMark[n] = this.entityMark[n] - 1;
        return triple;
    }

    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }
}

