/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.common.providers;

import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.edit.provider.ComposedImage;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.uml2.diagram.common.UMLCommonPlugin;
import org.osgi.framework.Bundle;

public class ImageUtils {
    private static final Bundle UML_BUNDLE = UMLCommonPlugin.getInstance().getBundle();
    private static final String IMG_SYNC_DIAGRAM = "icons/ovr16/SyncDiagram.gif";
    public static final String IMG_COLLAPSE_ALL = "icons/collapseall.gif";

    public static ImageDescriptor overlay(ImageDescriptor original, ImageDescriptor overlay) {
        ArrayList<ImageDescriptor> images = new ArrayList<ImageDescriptor>(2);
        images.add(original);
        images.add(overlay);
        ComposedImage ci = new ComposedImage(images);
        return ExtendedImageRegistry.INSTANCE.getImageDescriptor((Object)ci);
    }

    public static ImageDescriptor getPackageImage(ImageDescriptor original, boolean isSync) {
        if (!isSync) {
            return original;
        }
        return ImageUtils.overlay(original, ImageUtils.getSyncPackageImage());
    }

    public static ImageDescriptor getImageDescriptor(String location) {
        ImageRegistry ir = UMLCommonPlugin.getInstance().getImageRegistry();
        ImageDescriptor imageDescriptor = ir.getDescriptor(location);
        if (imageDescriptor == null) {
            imageDescriptor = ImageDescriptor.createFromURL((URL)FileLocator.find((Bundle)UML_BUNDLE, (IPath)new Path(location), null));
            if (imageDescriptor == null) {
                return null;
            }
            ir.put(location, imageDescriptor);
        }
        return imageDescriptor;
    }

    private static ImageDescriptor getSyncPackageImage() {
        return ImageUtils.getImageDescriptor(IMG_SYNC_DIAGRAM);
    }
}

