/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.clazz.part;

import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.uml2.diagram.clazz.expressions.UMLAbstractExpression;
import org.eclipse.uml2.diagram.clazz.expressions.UMLOCLFactory;
import org.eclipse.uml2.diagram.clazz.part.UMLDiagramEditorPlugin;
import org.eclipse.uml2.diagram.clazz.part.UMLNodeDescriptor;
import org.eclipse.uml2.diagram.common.genapi.IVisualIDRegistry;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.Generalization;
import org.eclipse.uml2.uml.InterfaceRealization;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Realization;
import org.eclipse.uml2.uml.Slot;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.Usage;

public class UMLVisualIDRegistry {
    private static final String DEBUG_KEY = "org.eclipse.uml2.diagram.clazz/debug/visualID";
    private static UMLAbstractExpression Class_2001_Constraint;
    private static UMLAbstractExpression DataType_2004_Constraint;
    private static UMLAbstractExpression Dependency_2009_Constraint;
    private static UMLAbstractExpression Class_3007_Constraint;
    private static UMLAbstractExpression DataType_3008_Constraint;
    private static UMLAbstractExpression Property_3001_Constraint;
    private static UMLAbstractExpression Class_3003_Constraint;
    private static UMLAbstractExpression Slot_3017_Constraint;
    private static UMLAbstractExpression Property_3028_Constraint;
    private static UMLAbstractExpression Class_3030_Constraint;
    private static UMLAbstractExpression Class_3033_Constraint;
    private static UMLAbstractExpression DataType_3036_Constraint;
    private static UMLAbstractExpression Generalization_4001_Constraint;
    private static UMLAbstractExpression Dependency_4002_Constraint;
    private static UMLAbstractExpression Property_4003_Constraint;
    private static UMLAbstractExpression Association_4005_Constraint;
    private static UMLAbstractExpression InterfaceRealization_4008_Constraint;
    private static UMLAbstractExpression Realization_4010_Constraint;
    private static UMLAbstractExpression Usage_4013_Constraint;
    private static UMLAbstractExpression Slot_4015_Constraint;
    public static final IVisualIDRegistry TYPED_ADAPTER;

    static {
        TYPED_ADAPTER = new IVisualIDRegistry(){

            public String getModelID(View view) {
                return UMLVisualIDRegistry.getModelID(view);
            }

            public int getVisualID(View view) {
                return UMLVisualIDRegistry.getVisualID(view);
            }

            public int getNodeVisualID(View containerView, EObject domainElement) {
                return UMLVisualIDRegistry.getNodeVisualID(containerView, domainElement);
            }

            public boolean checkNodeVisualID(View containerView, EObject domainElement, int candidate) {
                return UMLVisualIDRegistry.checkNodeVisualID(containerView, domainElement, candidate);
            }

            public boolean isCompartmentVisualID(int visualID) {
                return UMLVisualIDRegistry.isCompartmentVisualID(visualID);
            }

            public boolean isSemanticLeafVisualID(int visualID) {
                return UMLVisualIDRegistry.isSemanticLeafVisualID(visualID);
            }

            public boolean isShortcutDescendant(View view) {
                return UMLVisualIDRegistry.isShortcutDescendant(view);
            }
        };
    }

    public static int getVisualID(View view) {
        if (view instanceof Diagram) {
            if ("UMLClass".equals(view.getType())) {
                return 1000;
            }
            return -1;
        }
        return UMLVisualIDRegistry.getVisualID(view.getType());
    }

    public static String getModelID(View view) {
        Diagram diagram = view.getDiagram();
        while (view != diagram) {
            EAnnotation annotation = view.getEAnnotation("Shortcut");
            if (annotation != null) {
                return (String)annotation.getDetails().get((Object)"modelID");
            }
            view = (View)view.eContainer();
        }
        return diagram != null ? diagram.getType() : null;
    }

    public static int getVisualID(String type) {
        try {
            return Integer.parseInt(type);
        }
        catch (NumberFormatException numberFormatException) {
            if (Boolean.TRUE.toString().equalsIgnoreCase(Platform.getDebugOption((String)DEBUG_KEY))) {
                UMLDiagramEditorPlugin.getInstance().logError("Unable to parse view type as a visualID number: " + type);
            }
            return -1;
        }
    }

    public static String getType(int visualID) {
        return String.valueOf(visualID);
    }

    public static int getDiagramVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        if (UMLPackage.eINSTANCE.getPackage().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isDiagram((Package)domainElement)) {
            return 1000;
        }
        return -1;
    }

    public static int getNodeVisualID(View containerView, EObject domainElement) {
        int containerVisualID;
        if (domainElement == null) {
            return -1;
        }
        String containerModelID = UMLVisualIDRegistry.getModelID(containerView);
        if (!"UMLClass".equals(containerModelID) && !"UMLClass".equals(containerModelID)) {
            return -1;
        }
        if ("UMLClass".equals(containerModelID)) {
            containerVisualID = UMLVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 1000;
        } else {
            return -1;
        }
        switch (containerVisualID) {
            case 2001: {
                if (UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) {
                    return 3025;
                }
                if (!UMLPackage.eINSTANCE.getRedefinableTemplateSignature().isSuperTypeOf(domainElement.eClass())) break;
                return 3027;
            }
            case 2007: {
                if (!UMLPackage.eINSTANCE.getRedefinableTemplateSignature().isSuperTypeOf(domainElement.eClass())) break;
                return 3027;
            }
            case 2004: {
                if (!UMLPackage.eINSTANCE.getRedefinableTemplateSignature().isSuperTypeOf(domainElement.eClass())) break;
                return 3027;
            }
            case 2005: {
                if (!UMLPackage.eINSTANCE.getRedefinableTemplateSignature().isSuperTypeOf(domainElement.eClass())) break;
                return 3027;
            }
            case 2003: {
                if (!UMLPackage.eINSTANCE.getRedefinableTemplateSignature().isSuperTypeOf(domainElement.eClass())) break;
                return 3027;
            }
            case 2017: {
                if (!UMLPackage.eINSTANCE.getLiteralInteger().isSuperTypeOf(domainElement.eClass())) break;
                return 3039;
            }
            case 3033: {
                if (UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) {
                    return 3025;
                }
                if (!UMLPackage.eINSTANCE.getRedefinableTemplateSignature().isSuperTypeOf(domainElement.eClass())) break;
                return 3027;
            }
            case 3034: {
                if (!UMLPackage.eINSTANCE.getRedefinableTemplateSignature().isSuperTypeOf(domainElement.eClass())) break;
                return 3027;
            }
            case 3036: {
                if (!UMLPackage.eINSTANCE.getRedefinableTemplateSignature().isSuperTypeOf(domainElement.eClass())) break;
                return 3027;
            }
            case 3037: {
                if (!UMLPackage.eINSTANCE.getRedefinableTemplateSignature().isSuperTypeOf(domainElement.eClass())) break;
                return 3027;
            }
            case 7010: {
                if (!UMLPackage.eINSTANCE.getPackage().isSuperTypeOf(domainElement.eClass())) break;
                return 3006;
            }
            case 7011: {
                if (UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isClass_3007((Class)domainElement)) {
                    return 3007;
                }
                if (UMLPackage.eINSTANCE.getDataType().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isDataType_3008((DataType)domainElement)) {
                    return 3008;
                }
                if (UMLPackage.eINSTANCE.getPrimitiveType().isSuperTypeOf(domainElement.eClass())) {
                    return 3009;
                }
                if (UMLPackage.eINSTANCE.getEnumeration().isSuperTypeOf(domainElement.eClass())) {
                    return 3011;
                }
                if (UMLPackage.eINSTANCE.getAssociationClass().isSuperTypeOf(domainElement.eClass())) {
                    return 3012;
                }
                if (!UMLPackage.eINSTANCE.getInterface().isSuperTypeOf(domainElement.eClass())) break;
                return 3041;
            }
            case 7012: {
                if (!UMLPackage.eINSTANCE.getInstanceSpecification().isSuperTypeOf(domainElement.eClass())) break;
                return 3013;
            }
            case 7001: {
                if (!UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isProperty_3001((Property)domainElement)) break;
                return 3001;
            }
            case 7002: {
                if (!UMLPackage.eINSTANCE.getOperation().isSuperTypeOf(domainElement.eClass())) break;
                return 3002;
            }
            case 7003: {
                if (!UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isClass_3003((Class)domainElement)) break;
                return 3003;
            }
            case 7024: {
                if (!UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass())) break;
                return 3019;
            }
            case 7025: {
                if (!UMLPackage.eINSTANCE.getOperation().isSuperTypeOf(domainElement.eClass())) break;
                return 3020;
            }
            case 7026: {
                if (!UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isClass_3003((Class)domainElement)) break;
                return 3003;
            }
            case 7017: {
                if (!UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass())) break;
                return 3014;
            }
            case 7018: {
                if (!UMLPackage.eINSTANCE.getOperation().isSuperTypeOf(domainElement.eClass())) break;
                return 3015;
            }
            case 7020: {
                if (!UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass())) break;
                return 3021;
            }
            case 7021: {
                if (!UMLPackage.eINSTANCE.getOperation().isSuperTypeOf(domainElement.eClass())) break;
                return 3022;
            }
            case 7013: {
                if (!UMLPackage.eINSTANCE.getEnumerationLiteral().isSuperTypeOf(domainElement.eClass())) break;
                return 3016;
            }
            case 7014: {
                if (!UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass())) break;
                return 3023;
            }
            case 7015: {
                if (!UMLPackage.eINSTANCE.getOperation().isSuperTypeOf(domainElement.eClass())) break;
                return 3024;
            }
            case 7028: {
                if (!UMLPackage.eINSTANCE.getSlot().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isSlot_3017((Slot)domainElement)) break;
                return 3017;
            }
            case 7029: {
                if (!UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isProperty_3028((Property)domainElement)) break;
                return 3028;
            }
            case 7030: {
                if (!UMLPackage.eINSTANCE.getOperation().isSuperTypeOf(domainElement.eClass())) break;
                return 3029;
            }
            case 7031: {
                if (!UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isClass_3030((Class)domainElement)) break;
                return 3030;
            }
            case 7032: {
                if (!UMLPackage.eINSTANCE.getElementImport().isSuperTypeOf(domainElement.eClass())) break;
                return 3031;
            }
            case 7033: {
                if (UMLPackage.eINSTANCE.getPackage().isSuperTypeOf(domainElement.eClass())) {
                    return 3032;
                }
                if (UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isClass_3033((Class)domainElement)) {
                    return 3033;
                }
                if (UMLPackage.eINSTANCE.getEnumeration().isSuperTypeOf(domainElement.eClass())) {
                    return 3034;
                }
                if (UMLPackage.eINSTANCE.getInstanceSpecification().isSuperTypeOf(domainElement.eClass())) {
                    return 3035;
                }
                if (UMLPackage.eINSTANCE.getDataType().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isDataType_3036((DataType)domainElement)) {
                    return 3036;
                }
                if (!UMLPackage.eINSTANCE.getPrimitiveType().isSuperTypeOf(domainElement.eClass())) break;
                return 3037;
            }
            case 7034: {
                if (UMLPackage.eINSTANCE.getPackage().isSuperTypeOf(domainElement.eClass())) {
                    return 3032;
                }
                if (UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isClass_3033((Class)domainElement)) {
                    return 3033;
                }
                if (UMLPackage.eINSTANCE.getEnumeration().isSuperTypeOf(domainElement.eClass())) {
                    return 3034;
                }
                if (UMLPackage.eINSTANCE.getInstanceSpecification().isSuperTypeOf(domainElement.eClass())) {
                    return 3035;
                }
                if (UMLPackage.eINSTANCE.getDataType().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isDataType_3036((DataType)domainElement)) {
                    return 3036;
                }
                if (!UMLPackage.eINSTANCE.getPrimitiveType().isSuperTypeOf(domainElement.eClass())) break;
                return 3037;
            }
            case 7035: {
                if (!UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isProperty_3001((Property)domainElement)) break;
                return 3001;
            }
            case 7036: {
                if (!UMLPackage.eINSTANCE.getOperation().isSuperTypeOf(domainElement.eClass())) break;
                return 3002;
            }
            case 7037: {
                if (!UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isClass_3003((Class)domainElement)) break;
                return 3003;
            }
            case 7038: {
                if (!UMLPackage.eINSTANCE.getEnumerationLiteral().isSuperTypeOf(domainElement.eClass())) break;
                return 3016;
            }
            case 7039: {
                if (!UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass())) break;
                return 3023;
            }
            case 7040: {
                if (!UMLPackage.eINSTANCE.getOperation().isSuperTypeOf(domainElement.eClass())) break;
                return 3024;
            }
            case 7041: {
                if (!UMLPackage.eINSTANCE.getSlot().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isSlot_3017((Slot)domainElement)) break;
                return 3017;
            }
            case 7042: {
                if (!UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass())) break;
                return 3014;
            }
            case 7043: {
                if (!UMLPackage.eINSTANCE.getOperation().isSuperTypeOf(domainElement.eClass())) break;
                return 3015;
            }
            case 7044: {
                if (!UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass())) break;
                return 3021;
            }
            case 7045: {
                if (!UMLPackage.eINSTANCE.getOperation().isSuperTypeOf(domainElement.eClass())) break;
                return 3022;
            }
            case 7046: {
                if (UMLPackage.eINSTANCE.getLiteralString().isSuperTypeOf(domainElement.eClass())) {
                    return 3038;
                }
                if (!UMLPackage.eINSTANCE.getExpression().isSuperTypeOf(domainElement.eClass())) break;
                return 3040;
            }
            case 1000: {
                if (containerView instanceof Diagram && domainElement != null && domainElement.equals(containerView.getElement())) {
                    return 2014;
                }
                if (UMLPackage.eINSTANCE.getPackage().isSuperTypeOf(domainElement.eClass())) {
                    return 2002;
                }
                if (UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isClass_2001((Class)domainElement)) {
                    return 2001;
                }
                if (UMLPackage.eINSTANCE.getAssociationClass().isSuperTypeOf(domainElement.eClass()) && !UMLVisualIDRegistry.hasViewChild(containerView, domainElement, 2007)) {
                    return 2007;
                }
                if (UMLPackage.eINSTANCE.getDataType().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isDataType_2004((DataType)domainElement)) {
                    return 2004;
                }
                if (UMLPackage.eINSTANCE.getPrimitiveType().isSuperTypeOf(domainElement.eClass())) {
                    return 2005;
                }
                if (UMLPackage.eINSTANCE.getEnumeration().isSuperTypeOf(domainElement.eClass())) {
                    return 2003;
                }
                if (UMLPackage.eINSTANCE.getInterface().isSuperTypeOf(domainElement.eClass())) {
                    return 2010;
                }
                if (UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 2006;
                }
                if (UMLPackage.eINSTANCE.getInstanceSpecification().isSuperTypeOf(domainElement.eClass())) {
                    return 2008;
                }
                if (UMLPackage.eINSTANCE.getDependency().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isDependency_2009((Dependency)domainElement)) {
                    return 2009;
                }
                if (UMLPackage.eINSTANCE.getGeneralizationSet().isSuperTypeOf(domainElement.eClass())) {
                    return 2012;
                }
                if (UMLPackage.eINSTANCE.getInterface().isSuperTypeOf(domainElement.eClass())) {
                    return 2013;
                }
                if (UMLPackage.eINSTANCE.getAssociationClass().isSuperTypeOf(domainElement.eClass()) && !UMLVisualIDRegistry.hasViewChild(containerView, domainElement, 2015)) {
                    return 2015;
                }
                if (UMLPackage.eINSTANCE.getPackage().isSuperTypeOf(domainElement.eClass())) {
                    return 2016;
                }
                if (UMLPackage.eINSTANCE.getInstanceSpecification().isSuperTypeOf(domainElement.eClass())) {
                    return 2017;
                }
                if (UMLPackage.eINSTANCE.getAssociationClass().isSuperTypeOf(domainElement.eClass())) {
                    return 2007;
                }
                if (!UMLPackage.eINSTANCE.getAssociationClass().isSuperTypeOf(domainElement.eClass())) break;
                return 2015;
            }
        }
        return -1;
    }

    public static boolean canCreateNode(View containerView, int nodeVisualID) {
        int containerVisualID;
        String containerModelID = UMLVisualIDRegistry.getModelID(containerView);
        if (!"UMLClass".equals(containerModelID) && !"UMLClass".equals(containerModelID)) {
            return false;
        }
        if ("UMLClass".equals(containerModelID)) {
            containerVisualID = UMLVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 1000;
        } else {
            return false;
        }
        switch (containerVisualID) {
            case 2002: {
                if (5004 == nodeVisualID) {
                    return true;
                }
                if (7010 == nodeVisualID) {
                    return true;
                }
                if (7011 == nodeVisualID) {
                    return true;
                }
                if (7012 != nodeVisualID) break;
                return true;
            }
            case 2001: {
                if (5003 == nodeVisualID) {
                    return true;
                }
                if (5019 == nodeVisualID) {
                    return true;
                }
                if (7001 == nodeVisualID) {
                    return true;
                }
                if (7002 == nodeVisualID) {
                    return true;
                }
                if (7003 == nodeVisualID) {
                    return true;
                }
                if (3025 == nodeVisualID) {
                    return true;
                }
                if (3027 != nodeVisualID) break;
                return true;
            }
            case 2007: {
                if (5009 == nodeVisualID) {
                    return true;
                }
                if (7024 == nodeVisualID) {
                    return true;
                }
                if (7025 == nodeVisualID) {
                    return true;
                }
                if (7026 == nodeVisualID) {
                    return true;
                }
                if (3027 != nodeVisualID) break;
                return true;
            }
            case 2004: {
                if (5006 == nodeVisualID) {
                    return true;
                }
                if (7017 == nodeVisualID) {
                    return true;
                }
                if (7018 == nodeVisualID) {
                    return true;
                }
                if (3027 != nodeVisualID) break;
                return true;
            }
            case 2005: {
                if (5007 == nodeVisualID) {
                    return true;
                }
                if (7020 == nodeVisualID) {
                    return true;
                }
                if (7021 == nodeVisualID) {
                    return true;
                }
                if (3027 != nodeVisualID) break;
                return true;
            }
            case 2003: {
                if (5005 == nodeVisualID) {
                    return true;
                }
                if (7013 == nodeVisualID) {
                    return true;
                }
                if (7014 == nodeVisualID) {
                    return true;
                }
                if (7015 == nodeVisualID) {
                    return true;
                }
                if (3027 != nodeVisualID) break;
                return true;
            }
            case 2010: {
                if (5012 != nodeVisualID) break;
                return true;
            }
            case 2006: {
                if (5008 != nodeVisualID) break;
                return true;
            }
            case 2008: {
                if (5010 == nodeVisualID) {
                    return true;
                }
                if (7028 != nodeVisualID) break;
                return true;
            }
            case 2009: {
                if (5011 != nodeVisualID) break;
                return true;
            }
            case 2012: {
                if (5016 == nodeVisualID) {
                    return true;
                }
                if (5017 != nodeVisualID) break;
                return true;
            }
            case 2013: {
                if (5018 == nodeVisualID) {
                    return true;
                }
                if (7029 == nodeVisualID) {
                    return true;
                }
                if (7030 == nodeVisualID) {
                    return true;
                }
                if (7031 != nodeVisualID) break;
                return true;
            }
            case 2014: {
                if (5020 == nodeVisualID) {
                    return true;
                }
                if (7032 != nodeVisualID) break;
                return true;
            }
            case 2016: {
                if (5026 == nodeVisualID) {
                    return true;
                }
                if (7033 != nodeVisualID) break;
                return true;
            }
            case 2017: {
                if (5029 == nodeVisualID) {
                    return true;
                }
                if (7046 == nodeVisualID) {
                    return true;
                }
                if (3039 != nodeVisualID) break;
                return true;
            }
            case 3025: {
                if (5013 != nodeVisualID) break;
                return true;
            }
            case 3027: {
                if (5015 != nodeVisualID) break;
                return true;
            }
            case 3032: {
                if (5025 == nodeVisualID) {
                    return true;
                }
                if (7034 != nodeVisualID) break;
                return true;
            }
            case 3033: {
                if (5021 == nodeVisualID) {
                    return true;
                }
                if (5022 == nodeVisualID) {
                    return true;
                }
                if (7035 == nodeVisualID) {
                    return true;
                }
                if (7036 == nodeVisualID) {
                    return true;
                }
                if (7037 == nodeVisualID) {
                    return true;
                }
                if (3025 == nodeVisualID) {
                    return true;
                }
                if (3027 != nodeVisualID) break;
                return true;
            }
            case 3034: {
                if (5023 == nodeVisualID) {
                    return true;
                }
                if (7038 == nodeVisualID) {
                    return true;
                }
                if (7039 == nodeVisualID) {
                    return true;
                }
                if (7040 == nodeVisualID) {
                    return true;
                }
                if (3027 != nodeVisualID) break;
                return true;
            }
            case 3035: {
                if (5024 == nodeVisualID) {
                    return true;
                }
                if (7041 != nodeVisualID) break;
                return true;
            }
            case 3036: {
                if (5027 == nodeVisualID) {
                    return true;
                }
                if (7042 == nodeVisualID) {
                    return true;
                }
                if (7043 == nodeVisualID) {
                    return true;
                }
                if (3027 != nodeVisualID) break;
                return true;
            }
            case 3037: {
                if (5028 == nodeVisualID) {
                    return true;
                }
                if (7044 == nodeVisualID) {
                    return true;
                }
                if (7045 == nodeVisualID) {
                    return true;
                }
                if (3027 != nodeVisualID) break;
                return true;
            }
            case 7010: {
                if (3006 != nodeVisualID) break;
                return true;
            }
            case 7011: {
                if (3007 == nodeVisualID) {
                    return true;
                }
                if (3008 == nodeVisualID) {
                    return true;
                }
                if (3009 == nodeVisualID) {
                    return true;
                }
                if (3011 == nodeVisualID) {
                    return true;
                }
                if (3012 == nodeVisualID) {
                    return true;
                }
                if (3041 != nodeVisualID) break;
                return true;
            }
            case 7012: {
                if (3013 != nodeVisualID) break;
                return true;
            }
            case 7001: {
                if (3001 != nodeVisualID) break;
                return true;
            }
            case 7002: {
                if (3002 != nodeVisualID) break;
                return true;
            }
            case 7003: {
                if (3003 != nodeVisualID) break;
                return true;
            }
            case 7024: {
                if (3019 != nodeVisualID) break;
                return true;
            }
            case 7025: {
                if (3020 != nodeVisualID) break;
                return true;
            }
            case 7026: {
                if (3003 != nodeVisualID) break;
                return true;
            }
            case 7017: {
                if (3014 != nodeVisualID) break;
                return true;
            }
            case 7018: {
                if (3015 != nodeVisualID) break;
                return true;
            }
            case 7020: {
                if (3021 != nodeVisualID) break;
                return true;
            }
            case 7021: {
                if (3022 != nodeVisualID) break;
                return true;
            }
            case 7013: {
                if (3016 != nodeVisualID) break;
                return true;
            }
            case 7014: {
                if (3023 != nodeVisualID) break;
                return true;
            }
            case 7015: {
                if (3024 != nodeVisualID) break;
                return true;
            }
            case 7028: {
                if (3017 != nodeVisualID) break;
                return true;
            }
            case 7029: {
                if (3028 != nodeVisualID) break;
                return true;
            }
            case 7030: {
                if (3029 != nodeVisualID) break;
                return true;
            }
            case 7031: {
                if (3030 != nodeVisualID) break;
                return true;
            }
            case 7032: {
                if (3031 != nodeVisualID) break;
                return true;
            }
            case 7033: {
                if (3032 == nodeVisualID) {
                    return true;
                }
                if (3033 == nodeVisualID) {
                    return true;
                }
                if (3034 == nodeVisualID) {
                    return true;
                }
                if (3035 == nodeVisualID) {
                    return true;
                }
                if (3036 == nodeVisualID) {
                    return true;
                }
                if (3037 != nodeVisualID) break;
                return true;
            }
            case 7034: {
                if (3032 == nodeVisualID) {
                    return true;
                }
                if (3033 == nodeVisualID) {
                    return true;
                }
                if (3034 == nodeVisualID) {
                    return true;
                }
                if (3035 == nodeVisualID) {
                    return true;
                }
                if (3036 == nodeVisualID) {
                    return true;
                }
                if (3037 != nodeVisualID) break;
                return true;
            }
            case 7035: {
                if (3001 != nodeVisualID) break;
                return true;
            }
            case 7036: {
                if (3002 != nodeVisualID) break;
                return true;
            }
            case 7037: {
                if (3003 != nodeVisualID) break;
                return true;
            }
            case 7038: {
                if (3016 != nodeVisualID) break;
                return true;
            }
            case 7039: {
                if (3023 != nodeVisualID) break;
                return true;
            }
            case 7040: {
                if (3024 != nodeVisualID) break;
                return true;
            }
            case 7041: {
                if (3017 != nodeVisualID) break;
                return true;
            }
            case 7042: {
                if (3014 != nodeVisualID) break;
                return true;
            }
            case 7043: {
                if (3015 != nodeVisualID) break;
                return true;
            }
            case 7044: {
                if (3021 != nodeVisualID) break;
                return true;
            }
            case 7045: {
                if (3022 != nodeVisualID) break;
                return true;
            }
            case 7046: {
                if (3038 == nodeVisualID) {
                    return true;
                }
                if (3040 != nodeVisualID) break;
                return true;
            }
            case 1000: {
                if (2002 == nodeVisualID) {
                    return true;
                }
                if (2001 == nodeVisualID) {
                    return true;
                }
                if (2007 == nodeVisualID) {
                    return true;
                }
                if (2004 == nodeVisualID) {
                    return true;
                }
                if (2005 == nodeVisualID) {
                    return true;
                }
                if (2003 == nodeVisualID) {
                    return true;
                }
                if (2010 == nodeVisualID) {
                    return true;
                }
                if (2006 == nodeVisualID) {
                    return true;
                }
                if (2008 == nodeVisualID) {
                    return true;
                }
                if (2009 == nodeVisualID) {
                    return true;
                }
                if (2012 == nodeVisualID) {
                    return true;
                }
                if (2013 == nodeVisualID) {
                    return true;
                }
                if (2014 == nodeVisualID) {
                    return true;
                }
                if (2015 == nodeVisualID) {
                    return true;
                }
                if (2016 == nodeVisualID) {
                    return true;
                }
                if (2017 != nodeVisualID) break;
                return true;
            }
            case 4002: {
                if (6001 == nodeVisualID) {
                    return true;
                }
                if (6010 != nodeVisualID) break;
                return true;
            }
            case 4003: {
                if (6002 == nodeVisualID) {
                    return true;
                }
                if (6012 == nodeVisualID) {
                    return true;
                }
                if (6017 != nodeVisualID) break;
                return true;
            }
            case 4005: {
                if (6003 == nodeVisualID) {
                    return true;
                }
                if (6004 == nodeVisualID) {
                    return true;
                }
                if (6005 == nodeVisualID) {
                    return true;
                }
                if (6006 == nodeVisualID) {
                    return true;
                }
                if (6007 == nodeVisualID) {
                    return true;
                }
                if (6008 == nodeVisualID) {
                    return true;
                }
                if (6009 != nodeVisualID) break;
                return true;
            }
            case 4010: {
                if (6011 != nodeVisualID) break;
                return true;
            }
            case 4015: {
                if (6015 == nodeVisualID) {
                    return true;
                }
                if (6016 != nodeVisualID) break;
                return true;
            }
            case 4016: {
                if (6013 == nodeVisualID) {
                    return true;
                }
                if (6014 != nodeVisualID) break;
                return true;
            }
        }
        return false;
    }

    public static int getLinkWithClassVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        if (UMLPackage.eINSTANCE.getGeneralization().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isGeneralization_4001((Generalization)domainElement)) {
            return 4001;
        }
        if (UMLPackage.eINSTANCE.getDependency().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isDependency_4002((Dependency)domainElement)) {
            return 4002;
        }
        if (UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isProperty_4003((Property)domainElement)) {
            return 4003;
        }
        if (UMLPackage.eINSTANCE.getAssociation().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isAssociation_4005((Association)domainElement)) {
            return 4005;
        }
        if (UMLPackage.eINSTANCE.getInterfaceRealization().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isInterfaceRealization_4008((InterfaceRealization)domainElement)) {
            return 4008;
        }
        if (UMLPackage.eINSTANCE.getRealization().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isRealization_4010((Realization)domainElement)) {
            return 4010;
        }
        if (UMLPackage.eINSTANCE.getGeneralization().isSuperTypeOf(domainElement.eClass())) {
            return 4011;
        }
        if (UMLPackage.eINSTANCE.getUsage().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isUsage_4013((Usage)domainElement)) {
            return 4013;
        }
        if (UMLPackage.eINSTANCE.getAssociationClass().isSuperTypeOf(domainElement.eClass())) {
            return 4014;
        }
        if (UMLPackage.eINSTANCE.getSlot().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isSlot_4015((Slot)domainElement)) {
            return 4015;
        }
        if (UMLPackage.eINSTANCE.getTemplateBinding().isSuperTypeOf(domainElement.eClass())) {
            return 4016;
        }
        return -1;
    }

    private static boolean isDiagram(Package element) {
        return true;
    }

    private static boolean isClass_2001(Class domainElement) {
        Object result;
        if (Class_2001_Constraint == null) {
            Class_2001_Constraint = UMLOCLFactory.getExpression("not oclIsKindOf(uml::AssociationClass) and not oclIsKindOf(uml::StateMachine)", (EClassifier)UMLPackage.eINSTANCE.getClass_());
        }
        return (result = Class_2001_Constraint.evaluate(domainElement)) instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isDataType_2004(DataType domainElement) {
        Object result;
        if (DataType_2004_Constraint == null) {
            DataType_2004_Constraint = UMLOCLFactory.getExpression("not oclIsKindOf(uml::PrimitiveType) and not oclIsKindOf(uml::Enumeration)", (EClassifier)UMLPackage.eINSTANCE.getDataType());
        }
        return (result = DataType_2004_Constraint.evaluate(domainElement)) instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isDependency_2009(Dependency domainElement) {
        Object result;
        if (Dependency_2009_Constraint == null) {
            Dependency_2009_Constraint = UMLOCLFactory.getExpression("self.supplier->size() > 1 or self.client->size() > 1", (EClassifier)UMLPackage.eINSTANCE.getDependency());
        }
        return (result = Dependency_2009_Constraint.evaluate(domainElement)) instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isClass_3007(Class domainElement) {
        Object result;
        if (Class_3007_Constraint == null) {
            Class_3007_Constraint = UMLOCLFactory.getExpression("not oclIsKindOf(uml::AssociationClass) and not oclIsKindOf(uml::StateMachine)", (EClassifier)UMLPackage.eINSTANCE.getClass_());
        }
        return (result = Class_3007_Constraint.evaluate(domainElement)) instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isDataType_3008(DataType domainElement) {
        Object result;
        if (DataType_3008_Constraint == null) {
            DataType_3008_Constraint = UMLOCLFactory.getExpression("not oclIsKindOf(uml::PrimitiveType) and not oclIsKindOf(uml::Enumeration)", (EClassifier)UMLPackage.eINSTANCE.getDataType());
        }
        return (result = DataType_3008_Constraint.evaluate(domainElement)) instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isProperty_3001(Property domainElement) {
        Object result;
        if (Property_3001_Constraint == null) {
            Property_3001_Constraint = UMLOCLFactory.getExpression("not oclIsKindOf(uml::Port) and self.association = null", (EClassifier)UMLPackage.eINSTANCE.getProperty());
        }
        return (result = Property_3001_Constraint.evaluate(domainElement)) instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isClass_3003(Class domainElement) {
        Object result;
        if (Class_3003_Constraint == null) {
            Class_3003_Constraint = UMLOCLFactory.getExpression("not oclIsKindOf(uml::AssociationClass) and not oclIsKindOf(uml::StateMachine)", (EClassifier)UMLPackage.eINSTANCE.getClass_());
        }
        return (result = Class_3003_Constraint.evaluate(domainElement)) instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isSlot_3017(Slot domainElement) {
        Object result;
        if (Slot_3017_Constraint == null) {
            Slot_3017_Constraint = UMLOCLFactory.getExpression("self.value->size() = 0 or not self.value->exists(v : ValueSpecification | v.oclIsKindOf(InstanceValue) and not v.oclAsType(InstanceValue).oclIsUndefined())", (EClassifier)UMLPackage.eINSTANCE.getSlot());
        }
        return (result = Slot_3017_Constraint.evaluate(domainElement)) instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isProperty_3028(Property domainElement) {
        Object result;
        if (Property_3028_Constraint == null) {
            Property_3028_Constraint = UMLOCLFactory.getExpression("not oclIsKindOf(uml::Port)", (EClassifier)UMLPackage.eINSTANCE.getProperty());
        }
        return (result = Property_3028_Constraint.evaluate(domainElement)) instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isClass_3030(Class domainElement) {
        Object result;
        if (Class_3030_Constraint == null) {
            Class_3030_Constraint = UMLOCLFactory.getExpression("not oclIsKindOf(uml::AssociationClass) and not oclIsKindOf(uml::StateMachine)", (EClassifier)UMLPackage.eINSTANCE.getClass_());
        }
        return (result = Class_3030_Constraint.evaluate(domainElement)) instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isClass_3033(Class domainElement) {
        Object result;
        if (Class_3033_Constraint == null) {
            Class_3033_Constraint = UMLOCLFactory.getExpression("not oclIsKindOf(uml::AssociationClass) and not oclIsKindOf(uml::StateMachine)", (EClassifier)UMLPackage.eINSTANCE.getClass_());
        }
        return (result = Class_3033_Constraint.evaluate(domainElement)) instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isDataType_3036(DataType domainElement) {
        Object result;
        if (DataType_3036_Constraint == null) {
            DataType_3036_Constraint = UMLOCLFactory.getExpression("not oclIsKindOf(uml::PrimitiveType) and not oclIsKindOf(uml::Enumeration)", (EClassifier)UMLPackage.eINSTANCE.getDataType());
        }
        return (result = DataType_3036_Constraint.evaluate(domainElement)) instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isGeneralization_4001(Generalization domainElement) {
        Object result;
        if (Generalization_4001_Constraint == null) {
            Generalization_4001_Constraint = UMLOCLFactory.getExpression("self.generalizationSet ->size() = 0", (EClassifier)UMLPackage.eINSTANCE.getGeneralization());
        }
        return (result = Generalization_4001_Constraint.evaluate(domainElement)) instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isDependency_4002(Dependency domainElement) {
        Object result;
        if (Dependency_4002_Constraint == null) {
            Dependency_4002_Constraint = UMLOCLFactory.getExpression("(self.oclIsTypeOf(uml::Dependency) or self.oclIsTypeOf(uml::Abstraction) or self.oclIsTypeOf(uml::Substitution) or self.oclIsTypeOf(uml::Usage)) and self.supplier->size() = 1 and self.client->size() = 1 and self.supplier->forAll(e|not e.oclIsKindOf(uml::Interface))", (EClassifier)UMLPackage.eINSTANCE.getDependency());
        }
        return (result = Dependency_4002_Constraint.evaluate(domainElement)) instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isProperty_4003(Property domainElement) {
        Object result;
        if (Property_4003_Constraint == null) {
            Property_4003_Constraint = UMLOCLFactory.getExpression("self.association.oclIsTypeOf(uml::AssociationClass)", (EClassifier)UMLPackage.eINSTANCE.getProperty());
        }
        return (result = Property_4003_Constraint.evaluate(domainElement)) instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isAssociation_4005(Association domainElement) {
        Object result;
        if (Association_4005_Constraint == null) {
            Association_4005_Constraint = UMLOCLFactory.getExpression("not self.oclIsTypeOf(uml::AssociationClass)", (EClassifier)UMLPackage.eINSTANCE.getAssociation());
        }
        return (result = Association_4005_Constraint.evaluate(domainElement)) instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isInterfaceRealization_4008(InterfaceRealization domainElement) {
        Object result;
        if (InterfaceRealization_4008_Constraint == null) {
            InterfaceRealization_4008_Constraint = UMLOCLFactory.getExpression("self.supplier->forAll(e|e.oclIsKindOf(uml::Interface))", (EClassifier)UMLPackage.eINSTANCE.getInterfaceRealization());
        }
        return (result = InterfaceRealization_4008_Constraint.evaluate(domainElement)) instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isRealization_4010(Realization domainElement) {
        Object result;
        if (Realization_4010_Constraint == null) {
            Realization_4010_Constraint = UMLOCLFactory.getExpression("self.oclIsTypeOf(uml::Realization)", (EClassifier)UMLPackage.eINSTANCE.getRealization());
        }
        return (result = Realization_4010_Constraint.evaluate(domainElement)) instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isUsage_4013(Usage domainElement) {
        Object result;
        if (Usage_4013_Constraint == null) {
            Usage_4013_Constraint = UMLOCLFactory.getExpression("self.supplier->forAll(e|e.oclIsKindOf(uml::Interface))", (EClassifier)UMLPackage.eINSTANCE.getUsage());
        }
        return (result = Usage_4013_Constraint.evaluate(domainElement)) instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isSlot_4015(Slot domainElement) {
        Object result;
        if (Slot_4015_Constraint == null) {
            Slot_4015_Constraint = UMLOCLFactory.getExpression("self.value->exists(v : ValueSpecification | v.oclIsKindOf(InstanceValue) and not v.oclAsType(InstanceValue).oclIsUndefined())", (EClassifier)UMLPackage.eINSTANCE.getSlot());
        }
        return (result = Slot_4015_Constraint.evaluate(domainElement)) instanceof Boolean && (Boolean)result != false;
    }

    protected static boolean hasViewChild(View containerView, EObject domainElement, int visualId) {
        if (containerView == null) {
            return false;
        }
        if (domainElement == null) {
            return false;
        }
        for (Object next : containerView.getChildren()) {
            View nextView = (View)next;
            if (!domainElement.equals(nextView.getElement()) || !UMLVisualIDRegistry.getType(visualId).equals(nextView.getType())) continue;
            return true;
        }
        return false;
    }

    public static int getChildDescriptorVisualID(UMLNodeDescriptor container, EObject domainElement) {
        View containerView = null;
        if (domainElement == null) {
            return -1;
        }
        switch (container.getVisualID()) {
            case 2002: {
                if (UMLPackage.eINSTANCE.getPackage().isSuperTypeOf(domainElement.eClass())) {
                    return 3006;
                }
                if (UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isClass_3007((Class)domainElement)) {
                    return 3007;
                }
                if (UMLPackage.eINSTANCE.getDataType().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isDataType_3008((DataType)domainElement)) {
                    return 3008;
                }
                if (UMLPackage.eINSTANCE.getPrimitiveType().isSuperTypeOf(domainElement.eClass())) {
                    return 3009;
                }
                if (UMLPackage.eINSTANCE.getEnumeration().isSuperTypeOf(domainElement.eClass())) {
                    return 3011;
                }
                if (UMLPackage.eINSTANCE.getAssociationClass().isSuperTypeOf(domainElement.eClass())) {
                    return 3012;
                }
                if (UMLPackage.eINSTANCE.getInterface().isSuperTypeOf(domainElement.eClass())) {
                    return 3041;
                }
                if (!UMLPackage.eINSTANCE.getInstanceSpecification().isSuperTypeOf(domainElement.eClass())) break;
                return 3013;
            }
            case 2001: {
                if (UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) {
                    return 3025;
                }
                if (UMLPackage.eINSTANCE.getRedefinableTemplateSignature().isSuperTypeOf(domainElement.eClass())) {
                    return 3027;
                }
                if (UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isProperty_3001((Property)domainElement)) {
                    return 3001;
                }
                if (UMLPackage.eINSTANCE.getOperation().isSuperTypeOf(domainElement.eClass())) {
                    return 3002;
                }
                if (!UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isClass_3003((Class)domainElement)) break;
                return 3003;
            }
            case 2007: {
                if (UMLPackage.eINSTANCE.getRedefinableTemplateSignature().isSuperTypeOf(domainElement.eClass())) {
                    return 3027;
                }
                if (UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass())) {
                    return 3019;
                }
                if (UMLPackage.eINSTANCE.getOperation().isSuperTypeOf(domainElement.eClass())) {
                    return 3020;
                }
                if (!UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isClass_3003((Class)domainElement)) break;
                return 3003;
            }
            case 2004: {
                if (UMLPackage.eINSTANCE.getRedefinableTemplateSignature().isSuperTypeOf(domainElement.eClass())) {
                    return 3027;
                }
                if (UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass())) {
                    return 3014;
                }
                if (!UMLPackage.eINSTANCE.getOperation().isSuperTypeOf(domainElement.eClass())) break;
                return 3015;
            }
            case 2005: {
                if (UMLPackage.eINSTANCE.getRedefinableTemplateSignature().isSuperTypeOf(domainElement.eClass())) {
                    return 3027;
                }
                if (UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass())) {
                    return 3021;
                }
                if (!UMLPackage.eINSTANCE.getOperation().isSuperTypeOf(domainElement.eClass())) break;
                return 3022;
            }
            case 2003: {
                if (UMLPackage.eINSTANCE.getRedefinableTemplateSignature().isSuperTypeOf(domainElement.eClass())) {
                    return 3027;
                }
                if (UMLPackage.eINSTANCE.getEnumerationLiteral().isSuperTypeOf(domainElement.eClass())) {
                    return 3016;
                }
                if (UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass())) {
                    return 3023;
                }
                if (!UMLPackage.eINSTANCE.getOperation().isSuperTypeOf(domainElement.eClass())) break;
                return 3024;
            }
            case 2008: {
                if (!UMLPackage.eINSTANCE.getSlot().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isSlot_3017((Slot)domainElement)) break;
                return 3017;
            }
            case 2013: {
                if (UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isProperty_3028((Property)domainElement)) {
                    return 3028;
                }
                if (UMLPackage.eINSTANCE.getOperation().isSuperTypeOf(domainElement.eClass())) {
                    return 3029;
                }
                if (!UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isClass_3030((Class)domainElement)) break;
                return 3030;
            }
            case 2014: {
                if (!UMLPackage.eINSTANCE.getElementImport().isSuperTypeOf(domainElement.eClass())) break;
                return 3031;
            }
            case 2016: {
                if (UMLPackage.eINSTANCE.getPackage().isSuperTypeOf(domainElement.eClass())) {
                    return 3032;
                }
                if (UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isClass_3033((Class)domainElement)) {
                    return 3033;
                }
                if (UMLPackage.eINSTANCE.getEnumeration().isSuperTypeOf(domainElement.eClass())) {
                    return 3034;
                }
                if (UMLPackage.eINSTANCE.getInstanceSpecification().isSuperTypeOf(domainElement.eClass())) {
                    return 3035;
                }
                if (UMLPackage.eINSTANCE.getDataType().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isDataType_3036((DataType)domainElement)) {
                    return 3036;
                }
                if (!UMLPackage.eINSTANCE.getPrimitiveType().isSuperTypeOf(domainElement.eClass())) break;
                return 3037;
            }
            case 2017: {
                if (UMLPackage.eINSTANCE.getLiteralInteger().isSuperTypeOf(domainElement.eClass())) {
                    return 3039;
                }
                if (UMLPackage.eINSTANCE.getLiteralString().isSuperTypeOf(domainElement.eClass())) {
                    return 3038;
                }
                if (!UMLPackage.eINSTANCE.getExpression().isSuperTypeOf(domainElement.eClass())) break;
                return 3040;
            }
            case 3032: {
                if (UMLPackage.eINSTANCE.getPackage().isSuperTypeOf(domainElement.eClass())) {
                    return 3032;
                }
                if (UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isClass_3033((Class)domainElement)) {
                    return 3033;
                }
                if (UMLPackage.eINSTANCE.getEnumeration().isSuperTypeOf(domainElement.eClass())) {
                    return 3034;
                }
                if (UMLPackage.eINSTANCE.getInstanceSpecification().isSuperTypeOf(domainElement.eClass())) {
                    return 3035;
                }
                if (UMLPackage.eINSTANCE.getDataType().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isDataType_3036((DataType)domainElement)) {
                    return 3036;
                }
                if (!UMLPackage.eINSTANCE.getPrimitiveType().isSuperTypeOf(domainElement.eClass())) break;
                return 3037;
            }
            case 3033: {
                if (UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) {
                    return 3025;
                }
                if (UMLPackage.eINSTANCE.getRedefinableTemplateSignature().isSuperTypeOf(domainElement.eClass())) {
                    return 3027;
                }
                if (UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isProperty_3001((Property)domainElement)) {
                    return 3001;
                }
                if (UMLPackage.eINSTANCE.getOperation().isSuperTypeOf(domainElement.eClass())) {
                    return 3002;
                }
                if (!UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isClass_3003((Class)domainElement)) break;
                return 3003;
            }
            case 3034: {
                if (UMLPackage.eINSTANCE.getRedefinableTemplateSignature().isSuperTypeOf(domainElement.eClass())) {
                    return 3027;
                }
                if (UMLPackage.eINSTANCE.getEnumerationLiteral().isSuperTypeOf(domainElement.eClass())) {
                    return 3016;
                }
                if (UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass())) {
                    return 3023;
                }
                if (!UMLPackage.eINSTANCE.getOperation().isSuperTypeOf(domainElement.eClass())) break;
                return 3024;
            }
            case 3035: {
                if (!UMLPackage.eINSTANCE.getSlot().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isSlot_3017((Slot)domainElement)) break;
                return 3017;
            }
            case 3036: {
                if (UMLPackage.eINSTANCE.getRedefinableTemplateSignature().isSuperTypeOf(domainElement.eClass())) {
                    return 3027;
                }
                if (UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass())) {
                    return 3014;
                }
                if (!UMLPackage.eINSTANCE.getOperation().isSuperTypeOf(domainElement.eClass())) break;
                return 3015;
            }
            case 3037: {
                if (UMLPackage.eINSTANCE.getRedefinableTemplateSignature().isSuperTypeOf(domainElement.eClass())) {
                    return 3027;
                }
                if (UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass())) {
                    return 3021;
                }
                if (!UMLPackage.eINSTANCE.getOperation().isSuperTypeOf(domainElement.eClass())) break;
                return 3022;
            }
            case 1000: {
                if (UMLPackage.eINSTANCE.getPackage().isSuperTypeOf(domainElement.eClass())) {
                    return 2002;
                }
                if (UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isClass_2001((Class)domainElement)) {
                    return 2001;
                }
                if (UMLPackage.eINSTANCE.getAssociationClass().isSuperTypeOf(domainElement.eClass()) && !UMLVisualIDRegistry.hasViewChild(containerView, domainElement, 2007)) {
                    return 2007;
                }
                if (UMLPackage.eINSTANCE.getDataType().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isDataType_2004((DataType)domainElement)) {
                    return 2004;
                }
                if (UMLPackage.eINSTANCE.getPrimitiveType().isSuperTypeOf(domainElement.eClass())) {
                    return 2005;
                }
                if (UMLPackage.eINSTANCE.getEnumeration().isSuperTypeOf(domainElement.eClass())) {
                    return 2003;
                }
                if (UMLPackage.eINSTANCE.getInterface().isSuperTypeOf(domainElement.eClass())) {
                    return 2010;
                }
                if (UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 2006;
                }
                if (UMLPackage.eINSTANCE.getInstanceSpecification().isSuperTypeOf(domainElement.eClass())) {
                    return 2008;
                }
                if (UMLPackage.eINSTANCE.getDependency().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isDependency_2009((Dependency)domainElement)) {
                    return 2009;
                }
                if (UMLPackage.eINSTANCE.getGeneralizationSet().isSuperTypeOf(domainElement.eClass())) {
                    return 2012;
                }
                if (UMLPackage.eINSTANCE.getInterface().isSuperTypeOf(domainElement.eClass())) {
                    return 2013;
                }
                if (UMLPackage.eINSTANCE.getAssociationClass().isSuperTypeOf(domainElement.eClass()) && !UMLVisualIDRegistry.hasViewChild(containerView, domainElement, 2015)) {
                    return 2015;
                }
                if (UMLPackage.eINSTANCE.getPackage().isSuperTypeOf(domainElement.eClass())) {
                    return 2016;
                }
                if (UMLPackage.eINSTANCE.getInstanceSpecification().isSuperTypeOf(domainElement.eClass())) {
                    return 2017;
                }
                if (UMLPackage.eINSTANCE.getPackage().isSuperTypeOf(domainElement.eClass())) {
                    return 3006;
                }
                if (UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isClass_3007((Class)domainElement)) {
                    return 3007;
                }
                if (UMLPackage.eINSTANCE.getDataType().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isDataType_3008((DataType)domainElement)) {
                    return 3008;
                }
                if (UMLPackage.eINSTANCE.getPrimitiveType().isSuperTypeOf(domainElement.eClass())) {
                    return 3009;
                }
                if (UMLPackage.eINSTANCE.getEnumeration().isSuperTypeOf(domainElement.eClass())) {
                    return 3011;
                }
                if (UMLPackage.eINSTANCE.getAssociationClass().isSuperTypeOf(domainElement.eClass())) {
                    return 3012;
                }
                if (UMLPackage.eINSTANCE.getInterface().isSuperTypeOf(domainElement.eClass())) {
                    return 3041;
                }
                if (UMLPackage.eINSTANCE.getInstanceSpecification().isSuperTypeOf(domainElement.eClass())) {
                    return 3013;
                }
                if (UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isProperty_3001((Property)domainElement)) {
                    return 3001;
                }
                if (UMLPackage.eINSTANCE.getOperation().isSuperTypeOf(domainElement.eClass())) {
                    return 3002;
                }
                if (UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isClass_3003((Class)domainElement)) {
                    return 3003;
                }
                if (UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass())) {
                    return 3019;
                }
                if (UMLPackage.eINSTANCE.getOperation().isSuperTypeOf(domainElement.eClass())) {
                    return 3020;
                }
                if (UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isClass_3003((Class)domainElement)) {
                    return 3003;
                }
                if (UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass())) {
                    return 3014;
                }
                if (UMLPackage.eINSTANCE.getOperation().isSuperTypeOf(domainElement.eClass())) {
                    return 3015;
                }
                if (UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass())) {
                    return 3021;
                }
                if (UMLPackage.eINSTANCE.getOperation().isSuperTypeOf(domainElement.eClass())) {
                    return 3022;
                }
                if (UMLPackage.eINSTANCE.getEnumerationLiteral().isSuperTypeOf(domainElement.eClass())) {
                    return 3016;
                }
                if (UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass())) {
                    return 3023;
                }
                if (UMLPackage.eINSTANCE.getOperation().isSuperTypeOf(domainElement.eClass())) {
                    return 3024;
                }
                if (UMLPackage.eINSTANCE.getSlot().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isSlot_3017((Slot)domainElement)) {
                    return 3017;
                }
                if (UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isProperty_3028((Property)domainElement)) {
                    return 3028;
                }
                if (UMLPackage.eINSTANCE.getOperation().isSuperTypeOf(domainElement.eClass())) {
                    return 3029;
                }
                if (UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isClass_3030((Class)domainElement)) {
                    return 3030;
                }
                if (UMLPackage.eINSTANCE.getElementImport().isSuperTypeOf(domainElement.eClass())) {
                    return 3031;
                }
                if (UMLPackage.eINSTANCE.getPackage().isSuperTypeOf(domainElement.eClass())) {
                    return 3032;
                }
                if (UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isClass_3033((Class)domainElement)) {
                    return 3033;
                }
                if (UMLPackage.eINSTANCE.getEnumeration().isSuperTypeOf(domainElement.eClass())) {
                    return 3034;
                }
                if (UMLPackage.eINSTANCE.getInstanceSpecification().isSuperTypeOf(domainElement.eClass())) {
                    return 3035;
                }
                if (UMLPackage.eINSTANCE.getDataType().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isDataType_3036((DataType)domainElement)) {
                    return 3036;
                }
                if (UMLPackage.eINSTANCE.getPrimitiveType().isSuperTypeOf(domainElement.eClass())) {
                    return 3037;
                }
                if (UMLPackage.eINSTANCE.getPackage().isSuperTypeOf(domainElement.eClass())) {
                    return 3032;
                }
                if (UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isClass_3033((Class)domainElement)) {
                    return 3033;
                }
                if (UMLPackage.eINSTANCE.getEnumeration().isSuperTypeOf(domainElement.eClass())) {
                    return 3034;
                }
                if (UMLPackage.eINSTANCE.getInstanceSpecification().isSuperTypeOf(domainElement.eClass())) {
                    return 3035;
                }
                if (UMLPackage.eINSTANCE.getDataType().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isDataType_3036((DataType)domainElement)) {
                    return 3036;
                }
                if (UMLPackage.eINSTANCE.getPrimitiveType().isSuperTypeOf(domainElement.eClass())) {
                    return 3037;
                }
                if (UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isProperty_3001((Property)domainElement)) {
                    return 3001;
                }
                if (UMLPackage.eINSTANCE.getOperation().isSuperTypeOf(domainElement.eClass())) {
                    return 3002;
                }
                if (UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isClass_3003((Class)domainElement)) {
                    return 3003;
                }
                if (UMLPackage.eINSTANCE.getEnumerationLiteral().isSuperTypeOf(domainElement.eClass())) {
                    return 3016;
                }
                if (UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass())) {
                    return 3023;
                }
                if (UMLPackage.eINSTANCE.getOperation().isSuperTypeOf(domainElement.eClass())) {
                    return 3024;
                }
                if (UMLPackage.eINSTANCE.getSlot().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isSlot_3017((Slot)domainElement)) {
                    return 3017;
                }
                if (UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass())) {
                    return 3014;
                }
                if (UMLPackage.eINSTANCE.getOperation().isSuperTypeOf(domainElement.eClass())) {
                    return 3015;
                }
                if (UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass())) {
                    return 3021;
                }
                if (UMLPackage.eINSTANCE.getOperation().isSuperTypeOf(domainElement.eClass())) {
                    return 3022;
                }
                if (UMLPackage.eINSTANCE.getLiteralString().isSuperTypeOf(domainElement.eClass())) {
                    return 3038;
                }
                if (!UMLPackage.eINSTANCE.getExpression().isSuperTypeOf(domainElement.eClass())) break;
                return 3040;
            }
        }
        return -1;
    }

    protected static boolean canSubstitute(int visualId, int substituteCandidate) {
        if (visualId == substituteCandidate) {
            return true;
        }
        switch (visualId) {
            case 2002: {
                return substituteCandidate == 2016;
            }
            case 2007: {
                return substituteCandidate == 2015;
            }
            case 2010: {
                return substituteCandidate == 2013;
            }
            case 2008: {
                return substituteCandidate == 2017;
            }
            case 2013: {
                return substituteCandidate == 2010;
            }
            case 2015: {
                return substituteCandidate == 2007;
            }
            case 2016: {
                return substituteCandidate == 2002;
            }
            case 2017: {
                return substituteCandidate == 2008;
            }
        }
        return false;
    }

    public static boolean checkNodeVisualID(View containerView, EObject domainElement, int candidate) {
        if (candidate == -1) {
            return false;
        }
        int basic = UMLVisualIDRegistry.getNodeVisualID(containerView, domainElement);
        return basic == candidate || UMLVisualIDRegistry.canSubstitute(basic, candidate);
    }

    public static boolean isCompartmentVisualID(int visualID) {
        switch (visualID) {
            case 7001: 
            case 7002: 
            case 7003: 
            case 7010: 
            case 7011: 
            case 7012: 
            case 7013: 
            case 7014: 
            case 7015: 
            case 7017: 
            case 7018: 
            case 7020: 
            case 7021: 
            case 7024: 
            case 7025: 
            case 7026: 
            case 7028: 
            case 7029: 
            case 7030: 
            case 7031: 
            case 7032: 
            case 7033: 
            case 7034: 
            case 7035: 
            case 7036: 
            case 7037: 
            case 7038: 
            case 7039: 
            case 7040: 
            case 7041: 
            case 7042: 
            case 7043: 
            case 7044: 
            case 7045: 
            case 7046: {
                return true;
            }
        }
        return false;
    }

    public static boolean isSemanticLeafVisualID(int visualID) {
        switch (visualID) {
            case 2002: 
            case 2006: 
            case 2008: 
            case 2009: 
            case 2010: 
            case 2012: 
            case 2013: 
            case 2014: 
            case 2015: 
            case 2016: 
            case 3001: 
            case 3002: 
            case 3003: 
            case 3006: 
            case 3007: 
            case 3008: 
            case 3009: 
            case 3011: 
            case 3012: 
            case 3013: 
            case 3014: 
            case 3015: 
            case 3016: 
            case 3017: 
            case 3019: 
            case 3020: 
            case 3021: 
            case 3022: 
            case 3023: 
            case 3024: 
            case 3025: 
            case 3027: 
            case 3028: 
            case 3029: 
            case 3030: 
            case 3031: 
            case 3032: 
            case 3035: 
            case 3038: 
            case 3039: 
            case 3040: 
            case 3041: {
                return true;
            }
        }
        return false;
    }

    public static boolean isShortcutDescendant(View view) {
        Diagram diagram = view.getDiagram();
        while (view != diagram && view != null) {
            EAnnotation annotation = view.getEAnnotation("Shortcut");
            if (annotation != null) {
                return true;
            }
            view = (View)view.eContainer();
        }
        return false;
    }
}

