/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.clazz.edit.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.eclipse.uml2.diagram.clazz.edit.policies.UMLBaseItemSemanticEditPolicy;
import org.eclipse.uml2.uml.AssociationClass;
import org.eclipse.uml2.uml.CollaborationUse;
import org.eclipse.uml2.uml.Package;

public class AssociationClassConnectorReorientCommand
extends EditElementCommand {
    private final int reorientDirection;
    private final EObject oldEnd;
    private final EObject newEnd;

    public AssociationClassConnectorReorientCommand(ReorientRelationshipRequest request) {
        super(request.getLabel(), request.getRelationship(), (IEditCommandRequest)request);
        this.reorientDirection = request.getDirection();
        this.oldEnd = request.getOldRelationshipEnd();
        this.newEnd = request.getNewRelationshipEnd();
    }

    public boolean canExecute() {
        if (!(this.getElementToEdit() instanceof AssociationClass)) {
            return false;
        }
        if (this.reorientDirection == 1) {
            return this.canReorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.canReorientTarget();
        }
        return false;
    }

    protected boolean canReorientSource() {
        if (!(this.oldEnd instanceof CollaborationUse) || !(this.newEnd instanceof CollaborationUse)) {
            return false;
        }
        if (this.getLink().getCollaborationUses().size() != 1) {
            return false;
        }
        CollaborationUse target = (CollaborationUse)this.getLink().getCollaborationUses().get(0);
        if (!(this.getLink().eContainer() instanceof Package)) {
            return false;
        }
        Package container = (Package)this.getLink().eContainer();
        return UMLBaseItemSemanticEditPolicy.LinkConstraints.canExistAssociationClass_4014(container, this.getNewSource(), target);
    }

    protected boolean canReorientTarget() {
        if (!(this.oldEnd instanceof CollaborationUse) || !(this.newEnd instanceof CollaborationUse)) {
            return false;
        }
        if (this.getLink().getCollaborationUses().size() != 1) {
            return false;
        }
        CollaborationUse source = (CollaborationUse)this.getLink().getCollaborationUses().get(0);
        if (!(this.getLink().eContainer() instanceof Package)) {
            return false;
        }
        Package container = (Package)this.getLink().eContainer();
        return UMLBaseItemSemanticEditPolicy.LinkConstraints.canExistAssociationClass_4014(container, source, this.getNewTarget());
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in reorient link command");
        }
        if (this.reorientDirection == 1) {
            return this.reorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.reorientTarget();
        }
        throw new IllegalStateException();
    }

    protected CommandResult reorientSource() throws ExecutionException {
        this.getLink().getCollaborationUses().remove((Object)this.getOldSource());
        this.getLink().getCollaborationUses().add((Object)this.getNewSource());
        return CommandResult.newOKCommandResult((Object)this.getLink());
    }

    protected CommandResult reorientTarget() throws ExecutionException {
        this.getLink().getCollaborationUses().remove((Object)this.getOldTarget());
        this.getLink().getCollaborationUses().add((Object)this.getNewTarget());
        return CommandResult.newOKCommandResult((Object)this.getLink());
    }

    protected AssociationClass getLink() {
        return (AssociationClass)this.getElementToEdit();
    }

    protected CollaborationUse getOldSource() {
        return (CollaborationUse)this.oldEnd;
    }

    protected CollaborationUse getNewSource() {
        return (CollaborationUse)this.newEnd;
    }

    protected CollaborationUse getOldTarget() {
        return (CollaborationUse)this.oldEnd;
    }

    protected CollaborationUse getNewTarget() {
        return (CollaborationUse)this.newEnd;
    }
}

