/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.clazz.action;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.actions.DiagramAction;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.emf.type.core.commands.SetValueCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.uml2.diagram.clazz.part.CustomMessages;
import org.eclipse.uml2.diagram.common.commands.ChangeAssociationKindCommand;
import org.eclipse.uml2.diagram.common.conventions.AssociationEndConvention;
import org.eclipse.uml2.uml.AggregationKind;
import org.eclipse.uml2.uml.Association;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeAssociationKind
extends DiagramAction {
    private AggregationKind kind;
    private static Map<AggregationKind, String> oursKindToLabelTable;
    private static final String LABEL_NONE;
    private static final String LABEL_COMPOSITE;
    private static final String LABEL_SHARED;

    static {
        LABEL_NONE = CustomMessages.ChangeAssociationKind_none_action_label;
        LABEL_COMPOSITE = CustomMessages.ChangeAssociationKind_composite_action_label;
        LABEL_SHARED = CustomMessages.ChangeAssociationKind_shared_action_label;
    }

    public ChangeAssociationKind(IWorkbenchPage workbenchPage, AggregationKind aggregationKind) {
        super(workbenchPage);
        this.kind = aggregationKind;
        this.setText(this.getLabelTable().get(this.kind));
    }

    protected Command getCommand() {
        Association association = this.getAssociation();
        if (association == null) {
            return UnexecutableCommand.INSTANCE;
        }
        AggregationKind currentKind = AssociationEndConvention.getSourceEnd((Association)association).getAggregation();
        if (currentKind != null && currentKind.getValue() == this.kind.getValue()) {
            return UnexecutableCommand.INSTANCE;
        }
        ChangeAssociationKindCommand.SetAggregationKindRequest request = new ChangeAssociationKindCommand.SetAggregationKindRequest(association, this.kind);
        SetValueCommand setValueCommand = new SetValueCommand((SetRequest)request);
        return new ICommandProxy((ICommand)setValueCommand);
    }

    protected Request createTargetRequest() {
        return null;
    }

    protected boolean isSelectionListener() {
        return true;
    }

    private Association getAssociation() {
        ConnectionEditPart editPart = this.getSelectedEditPart();
        View view = editPart.getNotationView();
        return view != null ? (Association)view.getElement() : null;
    }

    private ConnectionEditPart getSelectedEditPart() {
        for (Object ob : this.getSelectedObjects()) {
            if (!(ob instanceof ConnectionEditPart)) continue;
            return (ConnectionEditPart)ob;
        }
        return null;
    }

    private Map<AggregationKind, String> getLabelTable() {
        if (oursKindToLabelTable == null) {
            oursKindToLabelTable = new HashMap<AggregationKind, String>();
            oursKindToLabelTable.put(AggregationKind.COMPOSITE_LITERAL, LABEL_COMPOSITE);
            oursKindToLabelTable.put(AggregationKind.NONE_LITERAL, LABEL_NONE);
            oursKindToLabelTable.put(AggregationKind.SHARED_LITERAL, LABEL_SHARED);
        }
        return oursKindToLabelTable;
    }
}

