/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.ecore;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ocl.AbstractEnvironment;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.EnvironmentFactory;
import org.eclipse.ocl.TypeResolver;
import org.eclipse.ocl.ecore.CallOperationAction;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.EcoreEnvironmentFactory;
import org.eclipse.ocl.ecore.EcorePackage;
import org.eclipse.ocl.ecore.SendSignalAction;
import org.eclipse.ocl.ecore.TypeResolverImpl;
import org.eclipse.ocl.ecore.internal.EcoreForeignMethods;
import org.eclipse.ocl.ecore.internal.OCLFactoryImpl;
import org.eclipse.ocl.ecore.internal.OCLStandardLibraryImpl;
import org.eclipse.ocl.ecore.internal.UMLReflectionImpl;
import org.eclipse.ocl.expressions.ExpressionsPackage;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.expressions.Variable;
import org.eclipse.ocl.expressions.impl.ExpressionsPackageImpl;
import org.eclipse.ocl.types.OCLStandardLibrary;
import org.eclipse.ocl.types.TypesPackage;
import org.eclipse.ocl.utilities.OCLFactory;
import org.eclipse.ocl.utilities.UMLReflection;
import org.eclipse.ocl.utilities.UtilitiesPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EcoreEnvironment
extends AbstractEnvironment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> {
    private static final Map<List<String>, EPackage> OCL_PACKAGES = new HashMap<List<String>, EPackage>();
    private EPackage.Registry registry;
    private EnvironmentFactory<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> factory;
    private TypeResolver<EClassifier, EOperation, EStructuralFeature> typeResolver;

    static {
        ArrayList<String> names = new ArrayList<String>();
        names.add(ExpressionsPackageImpl.OCL_ROOT_PACKAGE.getName());
        OCL_PACKAGES.put(names, ExpressionsPackageImpl.OCL_ROOT_PACKAGE);
        names = new ArrayList(names);
        names.add(ExpressionsPackage.eINSTANCE.getName());
        OCL_PACKAGES.put(names, (EPackage)ExpressionsPackage.eINSTANCE);
        names = new ArrayList(names);
        names.set(1, TypesPackage.eINSTANCE.getName());
        OCL_PACKAGES.put(names, (EPackage)TypesPackage.eINSTANCE);
        names = new ArrayList(names);
        names.set(1, UtilitiesPackage.eINSTANCE.getName());
        OCL_PACKAGES.put(names, (EPackage)UtilitiesPackage.eINSTANCE);
        names = new ArrayList(names);
        names.set(1, EcorePackage.eINSTANCE.getName());
        OCL_PACKAGES.put(names, EcorePackage.eINSTANCE);
    }

    protected EcoreEnvironment(EPackage.Registry reg) {
        this.registry = reg;
        this.typeResolver = this.createTypeResolver();
    }

    protected EcoreEnvironment(EPackage.Registry reg, Resource resource) {
        this.registry = reg;
        this.typeResolver = this.createTypeResolver(resource);
    }

    protected EcoreEnvironment(Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> parent) {
        super((AbstractEnvironment)((EcoreEnvironment)parent));
        EcoreEnvironment eparent = (EcoreEnvironment)parent;
        if (eparent != null) {
            this.registry = eparent.registry;
            this.typeResolver = eparent.getTypeResolver();
        } else {
            this.registry = EPackage.Registry.INSTANCE;
            this.typeResolver = this.createTypeResolver();
        }
    }

    public EnvironmentFactory<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> getFactory() {
        if (this.factory != null) {
            return this.factory;
        }
        if (this.getInternalParent() != null) {
            this.factory = this.getInternalParent().getFactory();
            if (this.factory != null) {
                return this.factory;
            }
        }
        this.factory = this.registry == EPackage.Registry.INSTANCE ? EcoreEnvironmentFactory.INSTANCE : new EcoreEnvironmentFactory(this.registry);
        return this.factory;
    }

    protected void setFactory(EnvironmentFactory<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> factory) {
        this.factory = factory;
    }

    public void setParent(Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> env) {
        super.setParent((AbstractEnvironment)((EcoreEnvironment)env));
    }

    public OCLStandardLibrary<EClassifier> getOCLStandardLibrary() {
        return OCLStandardLibraryImpl.INSTANCE;
    }

    public TypeResolver<EClassifier, EOperation, EStructuralFeature> getTypeResolver() {
        return this.typeResolver;
    }

    public OCLFactory getOCLFactory() {
        return OCLFactoryImpl.INSTANCE;
    }

    public UMLReflection<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint> getUMLReflection() {
        return UMLReflectionImpl.INSTANCE;
    }

    @Deprecated
    protected TypeResolver<EClassifier, EOperation, EStructuralFeature> createTypeResolver() {
        return this.createTypeResolver(null);
    }

    protected TypeResolver<EClassifier, EOperation, EStructuralFeature> createTypeResolver(Resource resource) {
        return new TypeResolverImpl(this, resource);
    }

    public EPackage lookupPackage(List<String> path) {
        if (!path.isEmpty() && OCL_PACKAGES.containsKey(path)) {
            return OCL_PACKAGES.get(path);
        }
        EPackage pkg = null;
        EPackage currPkg = (EPackage)this.getContextPackage();
        if (currPkg != null) {
            List<String> lookup = path;
            while (currPkg != null) {
                pkg = currPkg;
                int i = 0;
                while (i < lookup.size()) {
                    String name = lookup.get(i);
                    if ((pkg = EcoreForeignMethods.getESubpackage(pkg, name)) == null) break;
                    ++i;
                }
                if (pkg != null) {
                    return pkg;
                }
                if (currPkg == this.getContextPackage() && lookup.size() > 0 && EcoreForeignMethods.isNamed(lookup.get(0), (ENamedElement)currPkg)) {
                    lookup = lookup.subList(1, lookup.size());
                    continue;
                }
                lookup = path;
                currPkg = currPkg.getESuperPackage();
            }
        }
        return EcoreEnvironment.findPackage(path, this.registry);
    }

    public EClassifier lookupClassifier(List<String> names) {
        EPackage pkg = null;
        EPackage currPkg = (EPackage)this.getContextPackage();
        if (names.size() > 1) {
            List<String> newNames;
            List<String> lookup = names;
            if (currPkg != null) {
                while (currPkg != null) {
                    pkg = currPkg;
                    int i = 0;
                    while (i < lookup.size() - 1) {
                        String name = lookup.get(i);
                        if ((pkg = EcoreForeignMethods.getESubpackage(pkg, name)) == null) break;
                        ++i;
                    }
                    if (pkg != null) {
                        return EcoreForeignMethods.getEClassifier(pkg, lookup.get(lookup.size() - 1));
                    }
                    if (currPkg == this.getContextPackage() && lookup.size() > 1 && EcoreForeignMethods.isNamed(lookup.get(0), (ENamedElement)currPkg)) {
                        lookup = lookup.subList(1, lookup.size());
                        continue;
                    }
                    lookup = names;
                    currPkg = currPkg.getESuperPackage();
                }
            }
            if ((pkg = EcoreEnvironment.findPackage(newNames = names.subList(0, names.size() - 1), this.registry)) == null) {
                return null;
            }
            return EcoreForeignMethods.getEClassifier(pkg, names.get(names.size() - 1));
        }
        if (this.getContextPackage() != null) {
            String name = names.get(0);
            EClassifier result = null;
            while (currPkg != null) {
                result = EcoreForeignMethods.getEClassifier(currPkg, name);
                if (result != null) {
                    return result;
                }
                currPkg = currPkg.getESuperPackage();
            }
        }
        return null;
    }

    public List<EObject> getStates(EClassifier owner, List<String> pathPrefix) {
        BasicEList result = new BasicEList();
        this.collectStates(owner, pathPrefix, (List<EObject>)result);
        if (owner instanceof EClass) {
            for (EClass superclass : ((EClass)owner).getEAllSuperTypes()) {
                this.collectStates((EClassifier)superclass, pathPrefix, (List<EObject>)result);
            }
        }
        return result;
    }

    protected void collectStates(EClassifier owner, List<String> pathPrefix, List<EObject> states) {
    }

    public EStructuralFeature defineAttribute(EClassifier owner, Variable<EClassifier, EParameter> variable, Constraint constraint) {
        String name = variable.getName();
        EClassifier type = (EClassifier)variable.getType();
        Object result = type instanceof EClass ? EcoreFactory.eINSTANCE.createEReference() : EcoreFactory.eINSTANCE.createEAttribute();
        result.setName(name);
        result.setEType(type);
        Constraint existing = this.getDefinition(result);
        if (existing != null) {
            EcoreUtil.replace((EObject)existing, (EObject)constraint);
        } else {
            EAnnotation ann = result.getEAnnotation("http://www.eclipse.org/ocl/1.1.0/OCL");
            if (ann == null) {
                ann = EcoreFactory.eINSTANCE.createEAnnotation();
                ann.setSource("http://www.eclipse.org/ocl/1.1.0/OCL");
                result.getEAnnotations().add((Object)ann);
            }
            ann.getContents().add((Object)constraint);
        }
        this.addHelperProperty(owner, result);
        return result;
    }

    public EOperation defineOperation(EClassifier owner, String name, EClassifier type, List<Variable<EClassifier, EParameter>> params, Constraint constraint) {
        EOperation result = EcoreFactory.eINSTANCE.createEOperation();
        result.setName(name);
        result.setEType(type == null ? (EClassifier)this.getOCLStandardLibrary().getOclVoid() : type);
        for (Variable<EClassifier, EParameter> next : params) {
            EParameter param = EcoreFactory.eINSTANCE.createEParameter();
            param.setName(next.getName());
            param.setEType(next.getType() == null ? (EClassifier)this.getOCLStandardLibrary().getOclVoid() : (EClassifier)next.getType());
            result.getEParameters().add((Object)param);
        }
        Constraint existing = this.getDefinition(result);
        if (existing != null) {
            EcoreUtil.replace((EObject)existing, (EObject)constraint);
        } else {
            EAnnotation ann = result.getEAnnotation("http://www.eclipse.org/ocl/1.1.0/OCL");
            if (ann == null) {
                ann = EcoreFactory.eINSTANCE.createEAnnotation();
                ann.setSource("http://www.eclipse.org/ocl/1.1.0/OCL");
                result.getEAnnotations().add((Object)ann);
            }
            ann.getContents().add((Object)constraint);
        }
        this.addHelperOperation(owner, result);
        return result;
    }

    public void undefine(Object feature) {
        Constraint definition = this.getDefinition(feature);
        if (definition == null) {
            throw new IllegalArgumentException("not an additional feature: " + feature);
        }
        EcoreUtil.remove((EObject)((EObject)feature));
        EcoreUtil.remove((EObject)definition);
        definition.getConstrainedElements().clear();
    }

    public Constraint getDefinition(Object feature) {
        Constraint result = null;
        ETypedElement typedFeature = (ETypedElement)feature;
        EAnnotation ann = typedFeature.getEAnnotation("http://www.eclipse.org/ocl/1.1.0/OCL");
        if (ann != null && !ann.getContents().isEmpty()) {
            for (EObject o : ann.getContents()) {
                if (!(o instanceof Constraint) || !"definition".equals(((Constraint)o).getStereotype())) continue;
                result = (Constraint)o;
                break;
            }
        }
        return result;
    }

    public static EPackage findPackage(List<String> packageNames) {
        return EcoreEnvironment.findPackage(packageNames, EPackage.Registry.INSTANCE);
    }

    public static EPackage findPackage(List<String> packageNames, EPackage.Registry registry) {
        if (packageNames.isEmpty()) {
            return null;
        }
        if (OCL_PACKAGES.containsKey(packageNames)) {
            return OCL_PACKAGES.get(packageNames);
        }
        String name = packageNames.get(0);
        for (Object next : registry.values()) {
            EPackage tentativeResult;
            EPackage ePackage;
            if (!(next instanceof EPackage) || (ePackage = (EPackage)next).getESuperPackage() != null || !EcoreForeignMethods.isNamed(name, (ENamedElement)ePackage) || (tentativeResult = EcoreEnvironment.findNestedPackage(packageNames.subList(1, packageNames.size()), ePackage)) == null) continue;
            return tentativeResult;
        }
        return EcoreEnvironment.findPackageByNSPrefix(packageNames, registry);
    }

    private static EPackage findNestedPackage(List<String> packageNames, EPackage epackage) {
        EPackage result = epackage;
        for (String name : packageNames) {
            if ((result = EcoreForeignMethods.getESubpackage(result, name)) == null) break;
        }
        return result;
    }

    private static EPackage findPackageByNSPrefix(List<String> packageNames, EPackage.Registry registry) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator<String> it = packageNames.iterator();
        while (it.hasNext()) {
            stringBuffer.append(it.next());
            if (!it.hasNext()) continue;
            stringBuffer.append(".");
        }
        String nsPrefix = stringBuffer.toString();
        for (Object next : registry.values()) {
            EPackage ePackage;
            if (!(next instanceof EPackage) || !nsPrefix.equals((ePackage = (EPackage)next).getNsPrefix())) continue;
            return ePackage;
        }
        return null;
    }

    public boolean isInPostcondition(OCLExpression<EClassifier> exp) {
        Constraint constraint = null;
        EObject parent = exp;
        while (parent != null) {
            if (parent instanceof Constraint) {
                constraint = (Constraint)parent;
                break;
            }
            parent = parent.eContainer();
        }
        return constraint != null && "postcondition".equals(constraint.getStereotype());
    }
}

