/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.sequence.draw2d.layouts;

import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;

public class AbsoluteXYLayout
extends XYLayout {
    public Point getOrigin(IFigure parent) {
        return new Point(0, 0);
    }

    public Dimension getPreferredSize(IFigure container, int wHint, int hHint) {
        return this.calculatePreferredSize(container, wHint, hHint);
    }

    protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
        Point location = container.getClientArea().getLocation();
        Rectangle rect = new Rectangle();
        rect.setLocation(location);
        List children = container.getChildren();
        int i = 0;
        while (i < children.size()) {
            IFigure child = (IFigure)children.get(i);
            Rectangle constraint = (Rectangle)this.constraints.get(child);
            if (constraint != null) {
                if (constraint.x < location.x) {
                    constraint = constraint.getCopy();
                    constraint.x = location.x;
                }
                if (constraint.y < location.y) {
                    constraint = constraint.getCopy();
                    constraint.y = location.y;
                }
                if (constraint.width == -1 || constraint.height == -1) {
                    Dimension childPreferredSize = child.getPreferredSize(constraint.width, constraint.height);
                    constraint = constraint.getCopy();
                    if (constraint.width == -1) {
                        constraint.width = childPreferredSize.width;
                    }
                    if (constraint.height == -1) {
                        constraint.height = childPreferredSize.height;
                    }
                }
                rect.union(constraint);
            }
            ++i;
        }
        Dimension d = rect.getSize();
        Insets insets = container.getInsets();
        d.width += insets.getWidth();
        d.height += insets.getHeight();
        return d.union(this.getBorderPreferredSize(container));
    }
}

