/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.common.parser.association.end;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.uml2.diagram.common.conventions.AssociationEndConvention;
import org.eclipse.uml2.diagram.common.parser.property.PropertyToString;
import org.eclipse.uml2.diagram.parser.ExternalToString;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.TypedElement;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;

public abstract class AssociationEndToString
extends PropertyToString {
    private final boolean mySourceNotTarget;

    public AssociationEndToString(boolean sourceNotTarget) {
        this.mySourceNotTarget = sourceNotTarget;
    }

    protected Property asProperty(EObject object) {
        return AssociationEndToString.asProperty(object, this.mySourceNotTarget);
    }

    protected static Property asProperty(EObject object, boolean sourceNotTarget) {
        if (object instanceof Property) {
            return (Property)object;
        }
        if (!(object instanceof Association)) {
            throw new IllegalStateException("I can not provide toString for:" + object);
        }
        Association association = (Association)object;
        if (!association.isBinary()) {
            throw new IllegalStateException("I can not provide toString for not binary association:" + object);
        }
        return AssociationEndConvention.getMemberEnd(association, sourceNotTarget);
    }

    public static class EDIT
    extends PropertyToString.EDIT {
        private final boolean myIsSource;

        public EDIT(boolean isSource) {
            this.myIsSource = isSource;
        }

        protected void appendType(StringBuffer result, TypedElement typedElement) {
        }

        protected void appendDefault(StringBuffer result, Property property) {
        }

        protected Property asProperty(EObject object) {
            return AssociationEndToString.asProperty(object, this.myIsSource);
        }
    }

    public static class MODIFIERS_VIEW
    extends AssociationEndToString
    implements ExternalToString.WithReferences {
        private static final List AFFECTING = Arrays.asList(UMLPackage.eINSTANCE.getMultiplicityElement_IsOrdered(), UMLPackage.eINSTANCE.getMultiplicityElement_IsUnique(), UMLPackage.eINSTANCE.getProperty_IsDerivedUnion(), UMLPackage.eINSTANCE.getProperty_SubsettedProperty(), UMLPackage.eINSTANCE.getRedefinableElement_RedefinedElement(), UMLPackage.eINSTANCE.getNamedElement_Name());

        public MODIFIERS_VIEW(boolean sourceNotTarget) {
            super(sourceNotTarget);
        }

        public boolean isAffectingFeature(EStructuralFeature feature) {
            return AFFECTING.contains(feature);
        }

        public String getToString(EObject object, int flags) {
            Property property = this.asProperty(object);
            StringBuffer result = new StringBuffer();
            this.appendPropertyModifiers(result, property);
            return result.toString();
        }

        public List getAdditionalReferencedElements(EObject object) {
            Property property = this.asProperty(object);
            LinkedList<Property> result = new LinkedList<Property>();
            result.add(property);
            result.addAll((Collection<Property>)property.getSubsettedProperties());
            result.addAll((Collection<Property>)property.getRedefinedElements());
            return result;
        }
    }

    public static class MULTIPLICITY_VIEW
    extends AssociationEndToString
    implements ExternalToString.WithReferences {
        private static final List AFFECTING = Arrays.asList(UMLPackage.eINSTANCE.getMultiplicityElement_UpperValue(), UMLPackage.eINSTANCE.getMultiplicityElement_LowerValue(), UMLPackage.eINSTANCE.getLiteralUnlimitedNatural_Value(), UMLPackage.eINSTANCE.getLiteralInteger_Value(), UMLPackage.eINSTANCE.getLiteralString_Value());

        public MULTIPLICITY_VIEW(boolean sourceNotTarget) {
            super(sourceNotTarget);
        }

        public String getToString(EObject object, int flags) {
            Property property = this.asProperty(object);
            StringBuffer result = new StringBuffer();
            this.appendMultiplicity(result, (MultiplicityElement)property);
            return result.toString();
        }

        public boolean isAffectingFeature(EStructuralFeature feature) {
            return AFFECTING.contains(feature);
        }

        public List getAdditionalReferencedElements(EObject object) {
            ValueSpecification lower;
            Property property = this.asProperty(object);
            LinkedList<Object> result = new LinkedList<Object>();
            result.add(property);
            ValueSpecification upper = property.getUpperValue();
            if (upper != null) {
                result.add(upper);
            }
            if ((lower = property.getLowerValue()) != null) {
                result.add(lower);
            }
            return result;
        }
    }

    public static class ROLE_VIEW
    extends AssociationEndToString
    implements ExternalToString.WithReferences {
        private static final List AFFECTING = Arrays.asList(UMLPackage.eINSTANCE.getNamedElement_Visibility(), UMLPackage.eINSTANCE.getProperty_IsDerived(), UMLPackage.eINSTANCE.getNamedElement_Name());

        public ROLE_VIEW(boolean sourceNotTarget) {
            super(sourceNotTarget);
        }

        public String getToString(EObject object, int flags) {
            Property property = this.asProperty(object);
            StringBuffer result = new StringBuffer();
            this.appendVisibility(result, property);
            this.appendIsDerived(result, property);
            this.appendName(result, (NamedElement)property);
            return result.toString();
        }

        public boolean isAffectingFeature(EStructuralFeature feature) {
            return AFFECTING.contains(feature);
        }

        public List getAdditionalReferencedElements(EObject object) {
            Property property = this.asProperty(object);
            LinkedList<Property> result = new LinkedList<Property>();
            result.add(property);
            return result;
        }
    }
}

