package org.eclipse.uml2.diagram.profile.providers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.ui.services.modelingassistant.ModelingAssistantProvider;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.uml2.diagram.profile.edit.parts.ElementImport2EditPart;
import org.eclipse.uml2.diagram.profile.edit.parts.ElementImportEditPart;
import org.eclipse.uml2.diagram.profile.edit.parts.EnumerationEditPart;
import org.eclipse.uml2.diagram.profile.edit.parts.Profile2EditPart;
import org.eclipse.uml2.diagram.profile.edit.parts.Profile3EditPart;
import org.eclipse.uml2.diagram.profile.edit.parts.ProfileEditPart;
import org.eclipse.uml2.diagram.profile.edit.parts.Stereotype2EditPart;
import org.eclipse.uml2.diagram.profile.edit.parts.StereotypeEditPart;

import org.eclipse.uml2.diagram.profile.part.Messages;
import org.eclipse.uml2.diagram.profile.part.UMLDiagramEditorPlugin;

/**
 * @generated
 */
public class UMLModelingAssistantProvider extends ModelingAssistantProvider {

	/**
	 * @generated
	 */
	public List getTypesForPopupBar(IAdaptable host) {
		IGraphicalEditPart editPart = (IGraphicalEditPart) host.getAdapter(IGraphicalEditPart.class);
		if (editPart instanceof StereotypeEditPart) {
			List types = new ArrayList();
			types.add(UMLElementTypes.Property_3001);
			types.add(UMLElementTypes.Constraint_3008);
			return types;
		}
		if (editPart instanceof Profile2EditPart) {
			List types = new ArrayList();
			types.add(UMLElementTypes.Stereotype_3003);
			return types;
		}
		if (editPart instanceof EnumerationEditPart) {
			List types = new ArrayList();
			types.add(UMLElementTypes.EnumerationLiteral_3005);
			return types;
		}
		if (editPart instanceof Profile3EditPart) {
			List types = new ArrayList();
			types.add(UMLElementTypes.ElementImport_3009);
			return types;
		}
		if (editPart instanceof ProfileEditPart) {
			List types = new ArrayList();
			types.add(UMLElementTypes.Stereotype_2001);
			types.add(UMLElementTypes.Profile_2002);
			types.add(UMLElementTypes.Enumeration_2003);
			types.add(UMLElementTypes.ElementImport_2006);
			types.add(UMLElementTypes.Profile_2007);
			return types;
		}
		return Collections.EMPTY_LIST;
	}

	/**
	 * @generated
	 */
	public List getRelTypesOnSource(IAdaptable source) {
		IGraphicalEditPart sourceEditPart = (IGraphicalEditPart) source.getAdapter(IGraphicalEditPart.class);
		if (sourceEditPart instanceof StereotypeEditPart) {
			List types = new ArrayList();
			types.add(UMLElementTypes.Extension_4002);
			return types;
		}
		if (sourceEditPart instanceof Stereotype2EditPart) {
			List types = new ArrayList();
			types.add(UMLElementTypes.Extension_4002);
			return types;
		}
		return Collections.EMPTY_LIST;
	}

	/**
	 * @generated
	 */
	public List getRelTypesOnTarget(IAdaptable target) {
		IGraphicalEditPart targetEditPart = (IGraphicalEditPart) target.getAdapter(IGraphicalEditPart.class);
		if (targetEditPart instanceof ElementImportEditPart) {
			List types = new ArrayList();
			types.add(UMLElementTypes.Extension_4002);
			return types;
		}
		if (targetEditPart instanceof ElementImport2EditPart) {
			List types = new ArrayList();
			types.add(UMLElementTypes.Extension_4002);
			return types;
		}
		return Collections.EMPTY_LIST;
	}

	/**
	 * @generated
	 */
	public List getRelTypesOnSourceAndTarget(IAdaptable source, IAdaptable target) {
		IGraphicalEditPart sourceEditPart = (IGraphicalEditPart) source.getAdapter(IGraphicalEditPart.class);
		IGraphicalEditPart targetEditPart = (IGraphicalEditPart) target.getAdapter(IGraphicalEditPart.class);
		if (sourceEditPart instanceof StereotypeEditPart) {
			List types = new ArrayList();
			if (targetEditPart instanceof ElementImportEditPart) {
				types.add(UMLElementTypes.Extension_4002);
			}
			if (targetEditPart instanceof ElementImport2EditPart) {
				types.add(UMLElementTypes.Extension_4002);
			}
			return types;
		}
		if (sourceEditPart instanceof Stereotype2EditPart) {
			List types = new ArrayList();
			if (targetEditPart instanceof ElementImportEditPart) {
				types.add(UMLElementTypes.Extension_4002);
			}
			if (targetEditPart instanceof ElementImport2EditPart) {
				types.add(UMLElementTypes.Extension_4002);
			}
			return types;
		}
		return Collections.EMPTY_LIST;
	}

	/**
	 * @generated
	 */
	public List getTypesForSource(IAdaptable target, IElementType relationshipType) {
		IGraphicalEditPart targetEditPart = (IGraphicalEditPart) target.getAdapter(IGraphicalEditPart.class);
		if (targetEditPart instanceof ElementImportEditPart) {
			List types = new ArrayList();
			if (relationshipType == UMLElementTypes.Extension_4002) {
				types.add(UMLElementTypes.Stereotype_2001);
			}
			if (relationshipType == UMLElementTypes.Extension_4002) {
				types.add(UMLElementTypes.Stereotype_3003);
			}
			return types;
		}
		if (targetEditPart instanceof ElementImport2EditPart) {
			List types = new ArrayList();
			if (relationshipType == UMLElementTypes.Extension_4002) {
				types.add(UMLElementTypes.Stereotype_2001);
			}
			if (relationshipType == UMLElementTypes.Extension_4002) {
				types.add(UMLElementTypes.Stereotype_3003);
			}
			return types;
		}
		return Collections.EMPTY_LIST;
	}

	/**
	 * @generated
	 */
	public List getTypesForTarget(IAdaptable source, IElementType relationshipType) {
		IGraphicalEditPart sourceEditPart = (IGraphicalEditPart) source.getAdapter(IGraphicalEditPart.class);
		if (sourceEditPart instanceof StereotypeEditPart) {
			List types = new ArrayList();
			if (relationshipType == UMLElementTypes.Extension_4002) {
				types.add(UMLElementTypes.ElementImport_2006);
			}
			if (relationshipType == UMLElementTypes.Extension_4002) {
				types.add(UMLElementTypes.ElementImport_3009);
			}
			return types;
		}
		if (sourceEditPart instanceof Stereotype2EditPart) {
			List types = new ArrayList();
			if (relationshipType == UMLElementTypes.Extension_4002) {
				types.add(UMLElementTypes.ElementImport_2006);
			}
			if (relationshipType == UMLElementTypes.Extension_4002) {
				types.add(UMLElementTypes.ElementImport_3009);
			}
			return types;
		}
		return Collections.EMPTY_LIST;
	}

	/**
	 * @generated
	 */
	public EObject selectExistingElementForSource(IAdaptable target, IElementType relationshipType) {
		return selectExistingElement(target, getTypesForSource(target, relationshipType));
	}

	/**
	 * @generated
	 */
	public EObject selectExistingElementForTarget(IAdaptable source, IElementType relationshipType) {
		return selectExistingElement(source, getTypesForTarget(source, relationshipType));
	}

	/**
	 * @generated
	 */
	protected EObject selectExistingElement(IAdaptable host, Collection types) {
		if (types.isEmpty()) {
			return null;
		}
		IGraphicalEditPart editPart = (IGraphicalEditPart) host.getAdapter(IGraphicalEditPart.class);
		if (editPart == null) {
			return null;
		}
		Diagram diagram = (Diagram) editPart.getRoot().getContents().getModel();
		Collection elements = new HashSet();
		for (Iterator it = diagram.getElement().eAllContents(); it.hasNext();) {
			EObject element = (EObject) it.next();
			if (isApplicableElement(element, types)) {
				elements.add(element);
			}
		}
		if (elements.isEmpty()) {
			return null;
		}
		return selectElement((EObject[]) elements.toArray(new EObject[elements.size()]));
	}

	/**
	 * @generated
	 */
	protected boolean isApplicableElement(EObject element, Collection types) {
		IElementType type = ElementTypeRegistry.getInstance().getElementType(element);
		return types.contains(type);
	}

	/**
	 * @generated
	 */
	protected EObject selectElement(EObject[] elements) {
		Shell shell = Display.getCurrent().getActiveShell();
		ILabelProvider labelProvider = new AdapterFactoryLabelProvider(UMLDiagramEditorPlugin.getInstance().getItemProvidersAdapterFactory());
		ElementListSelectionDialog dialog = new ElementListSelectionDialog(shell, labelProvider);
		dialog.setMessage(Messages.UMLModelingAssistantProviderMessage);
		dialog.setTitle(Messages.UMLModelingAssistantProviderTitle);
		dialog.setMultipleSelection(false);
		dialog.setElements(elements);
		EObject selected = null;
		if (dialog.open() == Window.OK) {
			selected = (EObject) dialog.getFirstResult();
		}
		return selected;
	}
}
