/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.profile.part;

import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.uml2.diagram.profile.expressions.UMLAbstractExpression;
import org.eclipse.uml2.diagram.profile.expressions.UMLOCLFactory;
import org.eclipse.uml2.diagram.profile.part.UMLDiagramEditorPlugin;
import org.eclipse.uml2.diagram.profile.part.UMLNodeDescriptor;
import org.eclipse.uml2.uml.ElementImport;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.UMLPackage;

public class UMLVisualIDRegistry {
    private static final String DEBUG_KEY = "org.eclipse.uml2.diagram.profile/debug/visualID";
    private static UMLAbstractExpression Stereotype_2001_Constraint;
    private static UMLAbstractExpression ElementImport_2006_Constraint;
    private static UMLAbstractExpression Property_3001_Constraint;
    private static UMLAbstractExpression ElementImport_3009_Constraint;

    public static int getVisualID(View view) {
        if (view instanceof Diagram) {
            if ("UMLProfile".equals(view.getType())) {
                return 1000;
            }
            return -1;
        }
        return UMLVisualIDRegistry.getVisualID(view.getType());
    }

    public static String getModelID(View view) {
        Diagram diagram = view.getDiagram();
        while (view != diagram) {
            EAnnotation annotation = view.getEAnnotation("Shortcut");
            if (annotation != null) {
                return (String)annotation.getDetails().get((Object)"modelID");
            }
            view = (View)view.eContainer();
        }
        return diagram != null ? diagram.getType() : null;
    }

    public static int getVisualID(String type) {
        try {
            return Integer.parseInt(type);
        }
        catch (NumberFormatException numberFormatException) {
            if (Boolean.TRUE.toString().equalsIgnoreCase(Platform.getDebugOption((String)DEBUG_KEY))) {
                UMLDiagramEditorPlugin.getInstance().logError("Unable to parse view type as a visualID number: " + type);
            }
            return -1;
        }
    }

    public static String getType(int visualID) {
        return String.valueOf(visualID);
    }

    public static int getDiagramVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        if (UMLPackage.eINSTANCE.getProfile().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isDiagram((Profile)domainElement)) {
            return 1000;
        }
        return -1;
    }

    public static int getNodeVisualID(View containerView, EObject domainElement) {
        int containerVisualID;
        if (domainElement == null) {
            return -1;
        }
        String containerModelID = UMLVisualIDRegistry.getModelID(containerView);
        if (!"UMLProfile".equals(containerModelID)) {
            return -1;
        }
        if ("UMLProfile".equals(containerModelID)) {
            containerVisualID = UMLVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 1000;
        } else {
            return -1;
        }
        switch (containerVisualID) {
            case 7001: {
                if (!UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isProperty_3001((Property)domainElement)) break;
                return 3001;
            }
            case 7002: {
                if (!UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) break;
                return 3008;
            }
            case 7003: {
                if (!UMLPackage.eINSTANCE.getStereotype().isSuperTypeOf(domainElement.eClass())) break;
                return 3003;
            }
            case 7004: {
                if (!UMLPackage.eINSTANCE.getEnumerationLiteral().isSuperTypeOf(domainElement.eClass())) break;
                return 3005;
            }
            case 7005: {
                if (!UMLPackage.eINSTANCE.getElementImport().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isElementImport_3009((ElementImport)domainElement)) break;
                return 3009;
            }
            case 1000: {
                if (containerView instanceof Diagram && domainElement != null && domainElement.equals(containerView.getElement())) {
                    return 2007;
                }
                if (UMLPackage.eINSTANCE.getStereotype().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isStereotype_2001((Stereotype)domainElement)) {
                    return 2001;
                }
                if (UMLPackage.eINSTANCE.getProfile().isSuperTypeOf(domainElement.eClass())) {
                    return 2002;
                }
                if (UMLPackage.eINSTANCE.getEnumeration().isSuperTypeOf(domainElement.eClass())) {
                    return 2003;
                }
                if (!UMLPackage.eINSTANCE.getElementImport().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isElementImport_2006((ElementImport)domainElement)) break;
                return 2006;
            }
        }
        return -1;
    }

    public static boolean canCreateNode(View containerView, int nodeVisualID) {
        int containerVisualID;
        String containerModelID = UMLVisualIDRegistry.getModelID(containerView);
        if (!"UMLProfile".equals(containerModelID)) {
            return false;
        }
        if ("UMLProfile".equals(containerModelID)) {
            containerVisualID = UMLVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 1000;
        } else {
            return false;
        }
        switch (containerVisualID) {
            case 2001: {
                if (5001 == nodeVisualID) {
                    return true;
                }
                if (7001 == nodeVisualID) {
                    return true;
                }
                if (7002 != nodeVisualID) break;
                return true;
            }
            case 2002: {
                if (5003 == nodeVisualID) {
                    return true;
                }
                if (7003 != nodeVisualID) break;
                return true;
            }
            case 2003: {
                if (5005 == nodeVisualID) {
                    return true;
                }
                if (7004 != nodeVisualID) break;
                return true;
            }
            case 2006: {
                if (5008 != nodeVisualID) break;
                return true;
            }
            case 2007: {
                if (5009 == nodeVisualID) {
                    return true;
                }
                if (7005 != nodeVisualID) break;
                return true;
            }
            case 7001: {
                if (3001 != nodeVisualID) break;
                return true;
            }
            case 7002: {
                if (3008 != nodeVisualID) break;
                return true;
            }
            case 7003: {
                if (3003 != nodeVisualID) break;
                return true;
            }
            case 7004: {
                if (3005 != nodeVisualID) break;
                return true;
            }
            case 7005: {
                if (3009 != nodeVisualID) break;
                return true;
            }
            case 1000: {
                if (2001 == nodeVisualID) {
                    return true;
                }
                if (2002 == nodeVisualID) {
                    return true;
                }
                if (2003 == nodeVisualID) {
                    return true;
                }
                if (2006 == nodeVisualID) {
                    return true;
                }
                if (2007 != nodeVisualID) break;
                return true;
            }
            case 4002: {
                if (6001 != nodeVisualID) break;
                return true;
            }
        }
        return false;
    }

    public static int getLinkWithClassVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        if (UMLPackage.eINSTANCE.getGeneralization().isSuperTypeOf(domainElement.eClass())) {
            return 4001;
        }
        if (UMLPackage.eINSTANCE.getExtension().isSuperTypeOf(domainElement.eClass())) {
            return 4002;
        }
        return -1;
    }

    private static boolean isDiagram(Profile element) {
        return true;
    }

    private static boolean isStereotype_2001(Stereotype domainElement) {
        Object result;
        if (Stereotype_2001_Constraint == null) {
            Stereotype_2001_Constraint = UMLOCLFactory.getExpression("generalization.general->forAll(e | e.oclIsKindOf(uml::Stereotype)) and\r\ngeneralization.specific->forAll(e | e.oclIsKindOf(uml::Stereotype))", (EClassifier)UMLPackage.eINSTANCE.getStereotype());
        }
        return (result = Stereotype_2001_Constraint.evaluate(domainElement)) instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isElementImport_2006(ElementImport domainElement) {
        Object result;
        if (ElementImport_2006_Constraint == null) {
            ElementImport_2006_Constraint = UMLOCLFactory.getExpression("self.importedElement.oclIsUndefined() or self.importedElement.oclAsType(uml::Class).isMetaclass()", (EClassifier)UMLPackage.eINSTANCE.getElementImport());
        }
        return (result = ElementImport_2006_Constraint.evaluate(domainElement)) instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isProperty_3001(Property domainElement) {
        Object result;
        if (Property_3001_Constraint == null) {
            Property_3001_Constraint = UMLOCLFactory.getExpression("self.association.oclIsUndefined() or not self.association.oclIsKindOf(uml::Extension)", (EClassifier)UMLPackage.eINSTANCE.getProperty());
        }
        return (result = Property_3001_Constraint.evaluate(domainElement)) instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isElementImport_3009(ElementImport domainElement) {
        Object result;
        if (ElementImport_3009_Constraint == null) {
            ElementImport_3009_Constraint = UMLOCLFactory.getExpression("let imported : NamedElement = self.importedElement in \r\nimported.oclIsUndefined() or not imported.oclIsKindOf(Class) or not imported.oclAsType(Class).isMetaclass()\r\n", (EClassifier)UMLPackage.eINSTANCE.getElementImport());
        }
        return (result = ElementImport_3009_Constraint.evaluate(domainElement)) instanceof Boolean && (Boolean)result != false;
    }

    protected static boolean hasViewChild(View containerView, EObject domainElement, int visualId) {
        if (domainElement == null) {
            return false;
        }
        for (Object next : containerView.getChildren()) {
            View nextView = (View)next;
            if (!domainElement.equals(nextView.getElement()) || !UMLVisualIDRegistry.getType(visualId).equals(nextView.getType())) continue;
            return true;
        }
        return false;
    }

    public static int getChildDescriptorVisualID(UMLNodeDescriptor container, EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        switch (container.getVisualID()) {
            case 2001: {
                if (UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isProperty_3001((Property)domainElement)) {
                    return 3001;
                }
                if (!UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) break;
                return 3008;
            }
            case 2002: {
                if (!UMLPackage.eINSTANCE.getStereotype().isSuperTypeOf(domainElement.eClass())) break;
                return 3003;
            }
            case 2003: {
                if (!UMLPackage.eINSTANCE.getEnumerationLiteral().isSuperTypeOf(domainElement.eClass())) break;
                return 3005;
            }
            case 2007: {
                if (!UMLPackage.eINSTANCE.getElementImport().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isElementImport_3009((ElementImport)domainElement)) break;
                return 3009;
            }
            case 1000: {
                if (UMLPackage.eINSTANCE.getStereotype().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isStereotype_2001((Stereotype)domainElement)) {
                    return 2001;
                }
                if (UMLPackage.eINSTANCE.getProfile().isSuperTypeOf(domainElement.eClass())) {
                    return 2002;
                }
                if (UMLPackage.eINSTANCE.getEnumeration().isSuperTypeOf(domainElement.eClass())) {
                    return 2003;
                }
                if (UMLPackage.eINSTANCE.getElementImport().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isElementImport_2006((ElementImport)domainElement)) {
                    return 2006;
                }
                if (UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isProperty_3001((Property)domainElement)) {
                    return 3001;
                }
                if (UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3008;
                }
                if (UMLPackage.eINSTANCE.getStereotype().isSuperTypeOf(domainElement.eClass())) {
                    return 3003;
                }
                if (UMLPackage.eINSTANCE.getEnumerationLiteral().isSuperTypeOf(domainElement.eClass())) {
                    return 3005;
                }
                if (!UMLPackage.eINSTANCE.getElementImport().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isElementImport_3009((ElementImport)domainElement)) break;
                return 3009;
            }
        }
        return -1;
    }
}

