/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.properties.internal.checkers;

import java.util.Collection;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.infra.properties.environment.Environment;
import org.eclipse.papyrus.infra.properties.environment.EnvironmentPackage;
import org.eclipse.papyrus.infra.properties.environment.Namespace;
import org.eclipse.papyrus.infra.properties.environment.WidgetType;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.BuildPropertiesChecker;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.CustomModelChecker;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.ExtensionsChecker;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.IPluginChecker2;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.JavaClassDependencies;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.ModelDependenciesChecker;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.ModelValidationChecker;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.OpaqueResourceProvider;
import org.eclipse.papyrus.toolsmiths.validation.common.internal.utils.PluginErrorReporter;
import org.eclipse.papyrus.toolsmiths.validation.properties.internal.checkers.PropertiesEnvironmentCustomValidator;
import org.eclipse.papyrus.toolsmiths.validation.properties.internal.checkers.PropertiesEnvironmentPluginXMLValidator;
import org.eclipse.papyrus.toolsmiths.validation.properties.internal.messages.Messages;

public class PropertiesEnvironmentPluginChecker {
    public static final String XMI_EXTENSION = "xmi";
    public static final String ENVIRONMENT_EXTENSION = "environment";
    public static final String CONTENT_TYPE = "org.eclipse.papyrus.infra.properties.environment";
    private static final Set<String> ADDITIONAL_REQUIREMENTS = Set.of("org.eclipse.papyrus.infra.properties");

    public static IPluginChecker2.Factory modelValidationCheckerFactory() {
        return IPluginChecker2.Factory.forEMFResource(PropertiesEnvironmentPluginChecker::createModelValidationChecker);
    }

    private static ModelValidationChecker createModelValidationChecker(IProject project, IFile modelFile, Resource resource) {
        return new ModelValidationChecker(modelFile, resource, "org.eclipse.papyrus.toolsmiths.validation.properties.diagnostic");
    }

    public static IPluginChecker2.Factory buildPropertiesCheckerFactory() {
        return IPluginChecker2.Factory.forEMFResource(PropertiesEnvironmentPluginChecker::createBuildPropertiesChecker);
    }

    private static BuildPropertiesChecker createBuildPropertiesChecker(IProject project, IFile modelFile, Resource resource) {
        return new BuildPropertiesChecker(project, modelFile, resource, "org.eclipse.papyrus.toolsmiths.validation.properties.diagnostic");
    }

    public static IPluginChecker2.Factory modelDependenciesCheckerFactory() {
        return IPluginChecker2.Factory.forProject(PropertiesEnvironmentPluginChecker::createModelDependenciesChecker).or(IPluginChecker2.Factory.forEMFResource(PropertiesEnvironmentPluginChecker::createModelDependenciesChecker));
    }

    private static ModelDependenciesChecker createModelDependenciesChecker(IProject project) {
        return new ModelDependenciesChecker(project, null, null, "org.eclipse.papyrus.toolsmiths.validation.properties.diagnostic").addRequirements(ADDITIONAL_REQUIREMENTS).withSeverityFunction(bundle -> ADDITIONAL_REQUIREMENTS.contains(bundle) ? 2 : 4);
    }

    private static ModelDependenciesChecker createModelDependenciesChecker(IProject project, IFile modelFile, Resource resource) {
        return new ModelDependenciesChecker(project, modelFile, resource, "org.eclipse.papyrus.toolsmiths.validation.properties.diagnostic").withReferencedResources(PropertiesEnvironmentPluginChecker.createOpaqueResourceProvider(project));
    }

    private static OpaqueResourceProvider.EMF createOpaqueResourceProvider(IProject project) {
        JavaClassDependencies dependencies = new JavaClassDependencies(project);
        return OpaqueResourceProvider.EMF.create((Object)OpaqueResourceProvider.ResourceKind.CLASS, (String)"http://www.eclipse.org/papyrus/properties/environment/0.9", (EAttribute)EnvironmentPackage.Literals.WIDGET_TYPE__WIDGET_CLASS, (owner, attribute, className) -> PropertiesEnvironmentPluginChecker.getClassURI(owner, attribute, className, dependencies)).and(OpaqueResourceProvider.EMF.create((Object)OpaqueResourceProvider.ResourceKind.CLASS, (String)"http://www.eclipse.org/papyrus/properties/environment/0.9", (EAttribute)EnvironmentPackage.Literals.MODEL_ELEMENT_FACTORY_DESCRIPTOR__FACTORY_CLASS, (arg_0, arg_1, arg_2) -> ((JavaClassDependencies)dependencies).getClassURI(arg_0, arg_1, arg_2))).and(OpaqueResourceProvider.EMF.create((Object)OpaqueResourceProvider.ResourceKind.CLASS, (String)"http://www.eclipse.org/papyrus/properties/environment/0.9", (EAttribute)EnvironmentPackage.Literals.MISC_CLASS__CLASS, (arg_0, arg_1, arg_2) -> ((JavaClassDependencies)dependencies).getClassURI(arg_0, arg_1, arg_2)));
    }

    private static URI getClassURI(EObject owner, EAttribute attribute, String className, JavaClassDependencies dependencies) {
        WidgetType type;
        Namespace namespace;
        String qualifiedName = className;
        if (owner instanceof WidgetType && (namespace = (type = (WidgetType)owner).getNamespace()) != null) {
            qualifiedName = String.valueOf(namespace.getValue()) + "." + className;
        }
        return dependencies.getClassURI(owner, attribute, qualifiedName);
    }

    public static IPluginChecker2.Factory extensionsCheckerFactory() {
        return IPluginChecker2.Factory.forEMFResource(PropertiesEnvironmentPluginChecker::createExtensionsChecker);
    }

    private static ExtensionsChecker<Environment, PluginErrorReporter<Environment>> createExtensionsChecker(IProject project, IFile modelFile, Resource resource) {
        Collection environments = EcoreUtil.getObjectsByType((Collection)resource.getContents(), (EClassifier)EnvironmentPackage.Literals.ENVIRONMENT);
        return new ExtensionsChecker(project, modelFile, environments, "org.eclipse.papyrus.toolsmiths.validation.properties.diagnostic", PropertiesEnvironmentPluginChecker::createPluginErrorReporter);
    }

    private static PluginErrorReporter<Environment> createPluginErrorReporter(IFile pluginXML, IFile modelFile, Environment model) {
        PropertiesEnvironmentPluginXMLValidator validator = new PropertiesEnvironmentPluginXMLValidator(modelFile);
        return new PluginErrorReporter(pluginXML, modelFile, (EObject)model, "org.eclipse.papyrus.toolsmiths.validation.properties.diagnostic", __ -> Messages.PropertiesEnvironmentPluginChecker_0).requireExtensionPoint("org.eclipse.papyrus.infra.properties.environments", validator::matchExtension, null, validator::problemID);
    }

    public static IPluginChecker2.Factory customModelCheckerFactory() {
        return IPluginChecker2.Factory.forEMFResource(PropertiesEnvironmentPluginChecker::createCustomModelChecker);
    }

    private static CustomModelChecker createCustomModelChecker(IProject project, IFile modelFile, Resource resource) {
        return new CustomModelChecker(modelFile, resource, "org.eclipse.papyrus.toolsmiths.validation.properties.diagnostic").withValidator("http://www.eclipse.org/papyrus/properties/environment/0.9", PropertiesEnvironmentCustomValidator::new);
    }
}

