/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.text.FlowPage;
import org.eclipse.draw2d.text.TextFlow;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editpolicies.GraphicalEditPolicy;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.IMaskManagedLabelEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.CCombinedFragmentEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.LifelineEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.LifelineNameEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.util.LifelineLabelHelper;
import org.eclipse.papyrus.uml.tools.providers.UMLLabelProvider;
import org.eclipse.uml2.uml.CombinedFragment;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.DestructionOccurrenceSpecification;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.GeneralOrdering;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.InteractionOperand;
import org.eclipse.uml2.uml.InteractionOperatorKind;
import org.eclipse.uml2.uml.InteractionUse;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageSort;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.StateInvariant;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;

public class TooltipUtil {
    public static final String TOOLTIP_ROLE = "tooltip Edit Policy";
    private static final List<EClass> ELEMENT_SUPPORT_TOOLTIPS = new ArrayList<EClass>();

    static {
        ELEMENT_SUPPORT_TOOLTIPS.add(UMLPackage.Literals.LIFELINE);
        ELEMENT_SUPPORT_TOOLTIPS.add(UMLPackage.Literals.ACTION_EXECUTION_SPECIFICATION);
        ELEMENT_SUPPORT_TOOLTIPS.add(UMLPackage.Literals.BEHAVIOR_EXECUTION_SPECIFICATION);
        ELEMENT_SUPPORT_TOOLTIPS.add(UMLPackage.Literals.COMBINED_FRAGMENT);
        ELEMENT_SUPPORT_TOOLTIPS.add(UMLPackage.Literals.INTERACTION_OPERAND);
        ELEMENT_SUPPORT_TOOLTIPS.add(UMLPackage.Literals.MESSAGE);
        ELEMENT_SUPPORT_TOOLTIPS.add(UMLPackage.Literals.MESSAGE_END);
        ELEMENT_SUPPORT_TOOLTIPS.add(UMLPackage.Literals.EXECUTION_OCCURRENCE_SPECIFICATION);
        ELEMENT_SUPPORT_TOOLTIPS.add(UMLPackage.Literals.INTERACTION_USE);
        ELEMENT_SUPPORT_TOOLTIPS.add(UMLPackage.Literals.STATE_INVARIANT);
        ELEMENT_SUPPORT_TOOLTIPS.add(UMLPackage.Literals.DESTRUCTION_OCCURRENCE_SPECIFICATION);
        ELEMENT_SUPPORT_TOOLTIPS.add(UMLPackage.Literals.GENERAL_ORDERING);
    }

    public static void manageTooltipEditPolicy(EditPart editPart) {
        if (editPart == null || !(editPart instanceof GraphicalEditPart)) {
            return;
        }
        IFigure figure = ((GraphicalEditPart)editPart).getFigure();
        EClass semanticElementType = TooltipUtil.getSemanticElementType(editPart);
        if (TooltipUtil.supportTooltips(semanticElementType)) {
            editPart.installEditPolicy((Object)TOOLTIP_ROLE, (EditPolicy)new TooltipEditPolicy(new EditPartTooltipUpdater((GraphicalEditPart)editPart)));
        } else {
            editPart.removeEditPolicy((Object)TOOLTIP_ROLE);
            figure.setToolTip(null);
        }
    }

    private static boolean supportTooltips(EClass semanticType) {
        if (semanticType == null) {
            return false;
        }
        if (ELEMENT_SUPPORT_TOOLTIPS.contains(semanticType)) {
            return true;
        }
        for (EClass type : ELEMENT_SUPPORT_TOOLTIPS) {
            if (!type.isSuperTypeOf(semanticType)) continue;
            return true;
        }
        return false;
    }

    private static EClass getSemanticElementType(EditPart editPart) {
        EObject element = TooltipUtil.getSemanticElement(editPart);
        return element == null ? null : element.eClass();
    }

    private static EObject getSemanticElement(EditPart editPart) {
        if (editPart == null) {
            return null;
        }
        Object model = editPart.getModel();
        if (model instanceof View) {
            return ViewUtil.resolveSemanticElement((View)((View)model));
        }
        return null;
    }

    public static View getTopNodeView(Object model, EObject semanticElement) {
        EObject containerElement;
        if (model == null || !(model instanceof View)) {
            return null;
        }
        View view = (View)model;
        EObject elt = ViewUtil.resolveSemanticElement((View)view);
        if (elt == null || elt != semanticElement) {
            return null;
        }
        View containerView = ViewUtil.getContainerView((View)view);
        if (containerView != null && ((containerElement = ViewUtil.resolveSemanticElement((View)containerView)) == null || containerElement != semanticElement)) {
            return view;
        }
        return TooltipUtil.getTopNodeView(containerView, semanticElement);
    }

    public static class EditPartTooltipUpdater
    implements TooltipUpdater {
        private GraphicalEditPart editPart;

        public EditPartTooltipUpdater(GraphicalEditPart editPart) {
            Assert.isNotNull((Object)editPart);
            this.editPart = editPart;
        }

        @Override
        public String getTooltipName() {
            if (this.editPart instanceof CCombinedFragmentEditPart && ((CCombinedFragmentEditPart)this.editPart).isCoregion()) {
                return "Co Region";
            }
            EObject semanticElement = TooltipUtil.getSemanticElement((EditPart)this.editPart);
            if (semanticElement instanceof Message) {
                Message message = (Message)semanticElement;
                MessageSort messageSort = message.getMessageSort();
                switch (messageSort) {
                    case ASYNCH_CALL_LITERAL: {
                        return "Asynchronous Message";
                    }
                    case ASYNCH_SIGNAL_LITERAL: {
                        if (message.getSendEvent() == null) {
                            return "Found Message";
                        }
                        if (message.getReceiveEvent() == null) {
                            return "Lost Message";
                        }
                    }
                    case CREATE_MESSAGE_LITERAL: {
                        return "Create Message";
                    }
                    case DELETE_MESSAGE_LITERAL: {
                        return "Delete Message";
                    }
                    case REPLY_LITERAL: {
                        return "Reply Message";
                    }
                    case SYNCH_CALL_LITERAL: {
                        return "Synchronous Message";
                    }
                }
            } else if (semanticElement instanceof DestructionOccurrenceSpecification) {
                return "Destruction Event";
            }
            if (semanticElement != null) {
                return this.getDisplayName(semanticElement.eClass().getName());
            }
            return null;
        }

        private String getDisplayName(String name) {
            StringBuffer displayName = new StringBuffer();
            char[] charArray = name.toCharArray();
            int i = 0;
            while (i < charArray.length) {
                if (Character.isUpperCase(charArray[i])) {
                    displayName.append(" ");
                }
                displayName.append(charArray[i]);
                ++i;
            }
            return new String(displayName).trim();
        }

        @Override
        public String getTooltipDescription() {
            Interaction refersTo;
            EObject semanticElement = TooltipUtil.getSemanticElement((EditPart)this.editPart);
            if (semanticElement instanceof StateInvariant || semanticElement instanceof DestructionOccurrenceSpecification || semanticElement instanceof GeneralOrdering) {
                return null;
            }
            StringBuffer descBuf = new StringBuffer();
            descBuf.append("name: ");
            UMLLabelProvider labelProvider = new UMLLabelProvider();
            Object model = this.editPart.getModel();
            String label = null;
            View topNodeView = TooltipUtil.getTopNodeView(model, semanticElement);
            if (topNodeView != null && (label = labelProvider.getText((Object)topNodeView)) != null && label.startsWith("<UnknownElement")) {
                label = null;
            }
            if (semanticElement instanceof InteractionUse) {
                label = ((InteractionUse)semanticElement).getLabel();
            } else if (semanticElement instanceof Lifeline) {
                label = ((Lifeline)semanticElement).getLabel();
            }
            if (label == null && semanticElement instanceof NamedElement) {
                label = ((NamedElement)semanticElement).getLabel();
            }
            descBuf.append(label);
            descBuf.append("\n");
            if (!(!(semanticElement instanceof CombinedFragment) || this.editPart instanceof CCombinedFragmentEditPart && ((CCombinedFragmentEditPart)this.editPart).isCoregion())) {
                descBuf.append("operator: ");
                InteractionOperatorKind operator = ((CombinedFragment)semanticElement).getInteractionOperator();
                if (operator != null) {
                    descBuf.append(operator.getName());
                }
                descBuf.append("\n");
            } else if (semanticElement instanceof InteractionOperand) {
                InteractionOperatorKind operator;
                descBuf.append("parent:name: ");
                InteractionOperand interactionOperand = (InteractionOperand)semanticElement;
                Element owner = interactionOperand.getOwner();
                while (owner != null && !(owner instanceof CombinedFragment)) {
                    owner = owner.getOwner();
                }
                CombinedFragment parent = (CombinedFragment)owner;
                if (parent != null) {
                    descBuf.append(parent.getLabel());
                }
                descBuf.append("\n");
                descBuf.append("parent:operator: ");
                if (parent != null && (operator = parent.getInteractionOperator()) != null) {
                    descBuf.append(operator.getName());
                }
                descBuf.append("\n");
            } else if (semanticElement instanceof InteractionUse && (refersTo = ((InteractionUse)semanticElement).getRefersTo()) != null) {
                descBuf.append("ref: ");
                descBuf.append(refersTo.getLabel());
                descBuf.append("\n");
            }
            if (semanticElement instanceof Lifeline) {
                Lifeline lifeline;
                ConnectableElement represents;
                Collection displayValue = LifelineLabelHelper.DEFAULT_LABEL_DISPLAY;
                IMaskManagedLabelEditPolicy policy = null;
                if (this.editPart instanceof LifelineEditPart) {
                    policy = (IMaskManagedLabelEditPolicy)this.editPart.getEditPolicy((Object)"MaskManagedLabelPolicy");
                } else if (this.editPart instanceof LifelineNameEditPart) {
                    policy = (IMaskManagedLabelEditPolicy)this.editPart.getParent().getEditPolicy((Object)"MaskManagedLabelPolicy");
                }
                if (policy != null) {
                    displayValue = policy.getCurrentDisplayValue();
                }
                if ((represents = (lifeline = (Lifeline)semanticElement).getRepresents()) != null) {
                    descBuf.append("represent: ");
                    descBuf.append(represents.getLabel());
                    descBuf.append("\n");
                    Type type = represents.getType();
                    if (type != null) {
                        descBuf.append("represent type: ");
                        descBuf.append(type.getLabel());
                        descBuf.append("\n");
                    }
                }
            }
            return new String(descBuf).trim();
        }
    }

    public static class TooltipEditPolicy
    extends GraphicalEditPolicy {
        private TooltipUpdater updater;
        private MouseMotionListener updateListener;
        private Adapter modelListener;

        public TooltipEditPolicy(TooltipUpdater updater) {
            this.updater = updater;
        }

        public void activate() {
            super.activate();
            IFigure hostFigure = this.getHostFigure();
            final TooltipFigure tooltipFigure = new TooltipFigure(this.updater);
            hostFigure.setToolTip((IFigure)tooltipFigure);
            this.updateListener = new MouseMotionListener.Stub(){

                public void mouseEntered(MouseEvent me) {
                    tooltipFigure.update();
                }
            };
            hostFigure.addMouseMotionListener(this.updateListener);
            if (this.getHost() instanceof LifelineEditPart) {
                this.modelListener = new AdapterImpl(){

                    public void notifyChanged(Notification msg) {
                        if (msg.isTouch()) {
                            return;
                        }
                        tooltipFigure.update();
                    }
                };
                ((LifelineEditPart)this.getHost()).getPrimaryView().eAdapters().add((Object)this.modelListener);
            }
        }

        public void deactivate() {
            super.deactivate();
            if (this.updateListener != null) {
                this.getHostFigure().removeMouseMotionListener(this.updateListener);
            }
            if (this.getHost() instanceof LifelineEditPart) {
                ((LifelineEditPart)this.getHost()).getPrimaryView().eAdapters().remove((Object)this.modelListener);
            }
        }
    }

    public static class TooltipFigure
    extends Figure {
        private static final Border TOOLTIP_BORDER = new MarginBorder(0, 5, 1, 5);
        private TextFlow nameFigure;
        private TextFlow descriptionFigure;
        private TooltipUpdater updater;

        public TooltipFigure(TooltipUpdater updater) {
            this.updater = updater;
            this.setLayoutManager((LayoutManager)new ToolbarLayout(false));
            this.setBorder(TOOLTIP_BORDER);
            FlowPage namePage = new FlowPage();
            namePage.setOpaque(true);
            this.nameFigure = new TextFlow();
            namePage.add((IFigure)this.nameFigure);
            this.add((IFigure)namePage);
            namePage.setFont(JFaceResources.getBannerFont());
            FlowPage descPage = new FlowPage();
            descPage.setOpaque(true);
            this.descriptionFigure = new TextFlow();
            descPage.add((IFigure)this.descriptionFigure);
            this.add((IFigure)descPage);
            this.update();
        }

        public Dimension getPreferredSize(int wHint, int hHint) {
            Dimension d = super.getPreferredSize(-1, -1);
            return d;
        }

        public void setName(String name) {
            this.nameFigure.setText(name);
        }

        public String getName() {
            return this.nameFigure.getText();
        }

        public TextFlow getNameFigure() {
            return this.nameFigure;
        }

        public void setDescription(String description) {
            this.descriptionFigure.setText(description);
        }

        public String getDescription() {
            return this.descriptionFigure.getText();
        }

        public TextFlow getDescriptionFigure() {
            return this.descriptionFigure;
        }

        public void update() {
            if (this.updater == null) {
                return;
            }
            this.setName(this.updater.getTooltipName());
            this.setDescription(this.updater.getTooltipDescription());
        }
    }

    public static interface TooltipUpdater {
        public String getTooltipName();

        public String getTooltipDescription();
    }
}

