/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.policies;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewAndElementRequest;
import org.eclipse.gmf.runtime.draw2d.ui.figures.PolylineConnectionEx;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.common.editparts.RoundedCompartmentEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.AbstractExecutionSpecificationEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.AbstractMessageEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.LifelineEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.SenderRequestUtils;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.SequenceReferenceEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.UpdateWeakReferenceEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.part.UMLDiagramEditorPlugin;
import org.eclipse.papyrus.uml.diagram.sequence.util.CoordinateReferentialUtils;
import org.eclipse.papyrus.uml.diagram.sequence.util.LifelineEditPartUtil;
import org.eclipse.papyrus.uml.diagram.sequence.util.LogOptions;
import org.eclipse.papyrus.uml.diagram.sequence.util.SequenceUtil;
import org.eclipse.uml2.uml.ExecutionSpecification;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageEnd;
import org.eclipse.uml2.uml.OccurrenceSpecification;

public class UpdateWeakReferenceForMessageSpecEditPolicy
extends UpdateWeakReferenceEditPolicy {
    public static final String UDPATE_WEAK_REFERENCE_FOR_MESSAGE = "UpdateWeakReferenceForMessageSpecEditPolicy";

    public Command getCommand(Request request) {
        Command command = null;
        if (!SenderRequestUtils.isASender(request, this.getHost())) {
            if (request instanceof ReconnectRequest) {
                command = this.getUpdateWeakRefForMessageReconnect((ReconnectRequest)request);
            } else if (request instanceof CreateConnectionViewAndElementRequest) {
                command = this.getUpdateWeakRefForMessageCreate((CreateConnectionViewAndElementRequest)request);
            }
        }
        return command == null ? super.getCommand(request) : command;
    }

    private Command getUpdateWeakRefForMessageCreate(CreateConnectionViewAndElementRequest request) {
        EditPart targetEditPart;
        CompoundCommand command = null;
        CreateConnectionViewAndElementRequest createRequest = request;
        UMLDiagramEditorPlugin.log.trace(LogOptions.SEQUENCE_DEBUG, "Message creation request at:" + ((View)this.getHost().getAdapter(View.class)).getElement());
        createRequest.setLocation((Point)SequenceUtil.getSnappedLocation(this.getHost(), createRequest.getLocation()));
        Point reqlocationOnScreen = createRequest.getLocation().getCopy();
        this.getHostFigure().getParent().translateToRelative((Translatable)reqlocationOnScreen);
        UMLDiagramEditorPlugin.log.trace(LogOptions.SEQUENCE_DEBUG, "=> Request Location on screen: " + reqlocationOnScreen);
        ArrayList<OccurrenceSpecification> nextEventsFromPosition = new ArrayList<OccurrenceSpecification>();
        ArrayList<OccurrenceSpecification> previousEventsFromPosition = new ArrayList<OccurrenceSpecification>();
        EditPart sourceEditPart = createRequest.getSourceEditPart();
        if (sourceEditPart instanceof LifelineEditPart) {
            nextEventsFromPosition.addAll(LifelineEditPartUtil.getNextEventsFromPosition(reqlocationOnScreen, (LifelineEditPart)sourceEditPart));
            previousEventsFromPosition.addAll(LifelineEditPartUtil.getPreviousEventsFromPosition(new Point(reqlocationOnScreen.x, reqlocationOnScreen.y + deltaMoveAtCreationAndDeletion), (LifelineEditPart)sourceEditPart));
        }
        if ((targetEditPart = createRequest.getTargetEditPart()) instanceof LifelineEditPart) {
            nextEventsFromPosition.addAll(LifelineEditPartUtil.getNextEventsFromPosition(reqlocationOnScreen, (LifelineEditPart)targetEditPart));
            previousEventsFromPosition.addAll(LifelineEditPartUtil.getPreviousEventsFromPosition(new Point(reqlocationOnScreen.x, reqlocationOnScreen.y + deltaMoveAtCreationAndDeletion), (LifelineEditPart)targetEditPart));
        }
        if (!nextEventsFromPosition.isEmpty()) {
            CompoundCommand compoundCommand = new CompoundCommand();
            nextEventsFromPosition.retainAll(previousEventsFromPosition);
            for (OccurrenceSpecification nextEvent : nextEventsFromPosition) {
                UMLDiagramEditorPlugin.log.trace(LogOptions.SEQUENCE_DEBUG, "\tNext Event: " + nextEvent);
                IGraphicalEditPart sourceLifeLineEP = (IGraphicalEditPart)createRequest.getSourceEditPart();
                IGraphicalEditPart targetLifeLineEP = (IGraphicalEditPart)createRequest.getTargetEditPart();
                ArrayList<EditPart> senderList = SenderRequestUtils.getSenders((Request)request);
                ArrayList connectionsAndChildren = new ArrayList();
                if (sourceLifeLineEP != null) {
                    connectionsAndChildren.addAll(sourceLifeLineEP.getSourceConnections());
                    connectionsAndChildren.addAll(sourceLifeLineEP.getTargetConnections());
                    connectionsAndChildren.addAll(sourceLifeLineEP.getChildren());
                }
                if (targetLifeLineEP != null) {
                    connectionsAndChildren.addAll(targetLifeLineEP.getSourceConnections());
                    connectionsAndChildren.addAll(targetLifeLineEP.getTargetConnections());
                    connectionsAndChildren.addAll(targetLifeLineEP.getChildren());
                }
                for (Object editPart : connectionsAndChildren) {
                    Point moveDelta;
                    EObject element;
                    if (editPart instanceof AbstractMessageEditPart) {
                        element = ((View)((AbstractMessageEditPart)editPart).getAdapter(View.class)).getElement();
                        if ((!(element instanceof Message) || ((Message)element).getSendEvent() == null || !((Message)element).getSendEvent().equals(nextEvent)) && (!(element instanceof Message) || ((Message)element).getReceiveEvent() == null || !((Message)element).getReceiveEvent().equals(nextEvent))) continue;
                        moveDelta = new Point(0, 0);
                        PolylineConnectionEx polyline = (PolylineConnectionEx)((ConnectionEditPart)editPart).getFigure();
                        MessageEnd messageEnd = ((Message)element).getSendEvent();
                        Point anchorPositionOnScreen = messageEnd != null && messageEnd.equals(nextEvent) ? polyline.getTargetAnchor().getReferencePoint() : polyline.getSourceAnchor().getReferencePoint();
                        UMLDiagramEditorPlugin.log.trace(LogOptions.SEQUENCE_DEBUG, "\t\tanchorPositionOnScreen:\t" + anchorPositionOnScreen);
                        Point newLocation = new Point(0, createRequest.getLocation().y + deltaMoveAtCreationAndDeletion);
                        newLocation = SequenceUtil.getSnappedLocation(this.getHost(), newLocation);
                        UMLDiagramEditorPlugin.log.trace(LogOptions.SEQUENCE_DEBUG, "\t\tNew location to be set:\t" + newLocation);
                        moveDelta.y = newLocation.y - anchorPositionOnScreen.y;
                        UMLDiagramEditorPlugin.log.trace(LogOptions.SEQUENCE_DEBUG, "\t\tMoveDela:\t\t" + moveDelta.y);
                        UpdateWeakReferenceForMessageSpecEditPolicy.moveTargetConnectionEditPart(null, moveDelta, compoundCommand, (ConnectionEditPart)editPart, senderList);
                        UpdateWeakReferenceForMessageSpecEditPolicy.moveSourceConnectionEditPart(null, moveDelta, compoundCommand, (ConnectionEditPart)editPart, senderList);
                        continue;
                    }
                    if (!(editPart instanceof AbstractExecutionSpecificationEditPart) || !((element = ((View)((AbstractExecutionSpecificationEditPart)((Object)editPart)).getAdapter(View.class)).getElement()) instanceof ExecutionSpecification) || ((ExecutionSpecification)element).getStart() == null || !((ExecutionSpecification)element).getStart().equals(nextEvent)) continue;
                    moveDelta = new Point(0, 0);
                    Point figureLocation = ((AbstractExecutionSpecificationEditPart)((Object)editPart)).getFigure().getBounds().getLocation();
                    UMLDiagramEditorPlugin.log.trace(LogOptions.SEQUENCE_DEBUG, "\t\tlocationOfFigure:\t" + figureLocation);
                    Point newLocation = new Point(0, reqlocationOnScreen.y + deltaMoveAtCreationAndDeletion);
                    UMLDiagramEditorPlugin.log.trace(LogOptions.SEQUENCE_DEBUG, "\t\tNew location to be set:\t" + newLocation);
                    moveDelta.y = newLocation.y - figureLocation.y;
                    UMLDiagramEditorPlugin.log.trace(LogOptions.SEQUENCE_DEBUG, "\t\tMoveDela:\t\t" + moveDelta.y);
                    UpdateWeakReferenceForMessageSpecEditPolicy.moveRoundedEditPart(null, moveDelta, compoundCommand, (EditPart)editPart, senderList);
                }
            }
            if (!compoundCommand.isEmpty()) {
                command = compoundCommand;
            }
        }
        return command;
    }

    private Command getUpdateWeakRefForMessageReconnect(ReconnectRequest request) {
        Point anchorPositionOnScreen;
        CompoundCommand command = null;
        ReconnectRequest reconnectRequest = request;
        ConnectionEditPart hostConnectionEditPart = reconnectRequest.getConnectionEditPart();
        UMLDiagramEditorPlugin.log.trace(LogOptions.SEQUENCE_DEBUG, "+ MOVE ANCHORS of " + hostConnectionEditPart.getClass().getName());
        Point locationOnDiagram = CoordinateReferentialUtils.transformPointFromScreenToDiagramReferential(reconnectRequest.getLocation(), (GraphicalViewer)this.getHost().getViewer());
        UMLDiagramEditorPlugin.log.trace(LogOptions.SEQUENCE_DEBUG, "+-- LocationOnDiagram " + locationOnDiagram);
        Point moveDelta = new Point(0, 0);
        PolylineConnectionEx polyline = (PolylineConnectionEx)hostConnectionEditPart.getFigure();
        if ("Reconnection target".equals(reconnectRequest.getType())) {
            anchorPositionOnScreen = polyline.getTargetAnchor().getReferencePoint();
            moveDelta.y = reconnectRequest.getLocation().y - anchorPositionOnScreen.y;
        } else {
            anchorPositionOnScreen = polyline.getSourceAnchor().getReferencePoint();
            moveDelta.y = reconnectRequest.getLocation().y - anchorPositionOnScreen.y;
        }
        if (moveDelta.y != 0 && this.mustMove && hostConnectionEditPart.getEditPolicy((Object)"SEQUENCE_REFERENCE") != null) {
            SequenceReferenceEditPolicy references = (SequenceReferenceEditPolicy)hostConnectionEditPart.getEditPolicy((Object)"SEQUENCE_REFERENCE");
            if (!SenderRequestUtils.isASender((Request)request, this.getHost())) {
                CompoundCommand compoundCommand = new CompoundCommand();
                HashMap<EditPart, String> weakReferences = new HashMap<EditPart, String>();
                if (moveDelta.y > 0 && this.mustMoveBelowAtMovingDown) {
                    weakReferences.putAll(references.getWeakReferences());
                }
                for (EditPart editPart : weakReferences.keySet()) {
                    if (!SenderRequestUtils.isASender((Request)request, editPart)) {
                        UMLDiagramEditorPlugin.log.trace(LogOptions.SEQUENCE_DEBUG, "+--> try to Move " + editPart);
                        ArrayList<EditPart> senderList = SenderRequestUtils.getSenders((Request)request);
                        if (editPart instanceof ConnectionEditPart) {
                            ConnectionEditPart connectionEditPart = (ConnectionEditPart)editPart;
                            if (moveDelta.y > 0) {
                                UpdateWeakReferenceForMessageSpecEditPolicy.moveTargetConnectionEditPart((EditPart)hostConnectionEditPart, moveDelta, compoundCommand, connectionEditPart, senderList);
                                UpdateWeakReferenceForMessageSpecEditPolicy.moveSourceConnectionEditPart((EditPart)hostConnectionEditPart, moveDelta, compoundCommand, connectionEditPart, senderList);
                            } else {
                                UpdateWeakReferenceForMessageSpecEditPolicy.moveSourceConnectionEditPart((EditPart)hostConnectionEditPart, moveDelta, compoundCommand, connectionEditPart, senderList);
                                UpdateWeakReferenceForMessageSpecEditPolicy.moveTargetConnectionEditPart((EditPart)hostConnectionEditPart, moveDelta, compoundCommand, connectionEditPart, senderList);
                            }
                        }
                        if (editPart instanceof RoundedCompartmentEditPart) {
                            UpdateWeakReferenceForMessageSpecEditPolicy.moveRoundedEditPart((EditPart)hostConnectionEditPart, moveDelta, compoundCommand, editPart, senderList);
                        }
                    }
                    if (compoundCommand.isEmpty()) continue;
                    command = compoundCommand;
                }
            }
        }
        return command;
    }
}

