/**
 * Copyright (c) 2010 CEA LIST
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 * Yann Tanguy (CEA LIST) - initial API and implementation
 */
package utils;

import com.google.common.base.Objects;
import com.google.common.collect.Iterators;
import com.google.inject.Singleton;
import org.eclipse.gmf.codegen.gmfgen.GenNode;
import org.eclipse.gmf.codegen.gmfgen.TypeModelFacet;
import org.eclipse.papyrus.papyrusgmfgenextension.GenNodeConstraint;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;

@Singleton
@SuppressWarnings("all")
public class NodeConstraintUtils_qvto {
  public boolean hasNodeCreationConstraint(final GenNode it) {
    final Function1<GenNodeConstraint, Boolean> _function = new Function1<GenNodeConstraint, Boolean>() {
      @Override
      public Boolean apply(final GenNodeConstraint v) {
        return Boolean.valueOf((v.getGenNode().contains(it) && (!Objects.equal(v.getGenConstraint(), null))));
      }
    };
    int _size = IteratorExtensions.size(IteratorExtensions.<GenNodeConstraint>filter(Iterators.<GenNodeConstraint>filter(it.eResource().getAllContents(), GenNodeConstraint.class), _function));
    return (_size != 0);
  }
  
  public GenNodeConstraint getNodeCreationConstraint(final GenNode it) {
    boolean _hasNodeCreationConstraint = this.hasNodeCreationConstraint(it);
    if (_hasNodeCreationConstraint) {
      final Function1<GenNodeConstraint, Boolean> _function = new Function1<GenNodeConstraint, Boolean>() {
        @Override
        public Boolean apply(final GenNodeConstraint v) {
          return Boolean.valueOf((v.getGenNode().contains(it) && (!Objects.equal(v.getGenConstraint(), null))));
        }
      };
      return IteratorExtensions.<GenNodeConstraint>head(IteratorExtensions.<GenNodeConstraint>filter(Iterators.<GenNodeConstraint>filter(it.eResource().getAllContents(), GenNodeConstraint.class), _function));
    } else {
      return null;
    }
  }
  
  public GenNode getOwningGenNode(final TypeModelFacet it) {
    final Function1<GenNode, Boolean> _function = new Function1<GenNode, Boolean>() {
      @Override
      public Boolean apply(final GenNode v) {
        TypeModelFacet _modelFacet = v.getModelFacet();
        return Boolean.valueOf(Objects.equal(_modelFacet, it));
      }
    };
    return IteratorExtensions.<GenNode>head(IteratorExtensions.<GenNode>filter(Iterators.<GenNode>filter(it.eResource().getAllContents(), GenNode.class), _function));
  }
  
  public String getNodeCreationConstraintBody(final GenNode it) {
    GenNodeConstraint nodeConstraint = this.getNodeCreationConstraint(it);
    boolean _hasNodeCreationConstraint = this.hasNodeCreationConstraint(it);
    if (_hasNodeCreationConstraint) {
      if (((!Objects.equal(nodeConstraint.getGenConstraint(), null)) && (!Objects.equal(nodeConstraint.getGenConstraint().getBody(), null)))) {
        return nodeConstraint.getGenConstraint().getBody();
      }
    }
    return "No GenNodeConstraint found.";
  }
}
