/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.search.scope;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.plugin.RegistryReader;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.emf.utils.BusinessModelResolver;
import org.eclipse.papyrus.infra.onefile.model.IPapyrusFile;
import org.eclipse.papyrus.views.search.Activator;
import org.eclipse.papyrus.views.search.scope.IScopeCollector;
import org.eclipse.papyrus.views.search.scope.IScopeProvider;
import org.eclipse.papyrus.views.search.scope.WorkspaceScopeProvider;
import org.eclipse.search.ui.ISearchPageContainer;
import org.eclipse.ui.IWorkingSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScopeCollector
implements IScopeCollector {
    private static ScopeCollector instance = new ScopeCollector();
    private final Iterable<? extends IScopeProvider> scopeProviders = this.loadScopeProviders();

    private ScopeCollector() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final ScopeCollector getInstance() {
        Class<ScopeCollector> clazz = ScopeCollector.class;
        synchronized (ScopeCollector.class) {
            if (instance == null) {
                instance = new ScopeCollector();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public Collection<URI> computeSearchScope(ISearchPageContainer container) {
        HashSet<URI> results = new HashSet<URI>();
        if (container == null) {
            results.addAll(this.createWorkspaceScope());
        } else {
            switch (container.getSelectedScope()) {
                case 0: {
                    results.addAll(this.createWorkspaceScope());
                    break;
                }
                case 1: {
                    ISelection selection = container.getSelection();
                    if (!selection.isEmpty()) {
                        if (selection instanceof IStructuredSelection) {
                            results.addAll(this.createSelectionScope((IStructuredSelection)selection));
                            break;
                        }
                        results.addAll(this.createWorkspaceScope());
                        break;
                    }
                    results.addAll(this.createWorkspaceScope());
                    break;
                }
                case 3: {
                    String[] projects = container.getSelectedProjectNames();
                    results.addAll(this.createProjectsScope(projects));
                    break;
                }
                case 2: {
                    IWorkingSet[] workingSets = container.getSelectedWorkingSets();
                    results.addAll(this.createWorkingSetsScope(workingSets));
                    break;
                }
            }
        }
        return results;
    }

    protected List<URI> createSelectionScope(IStructuredSelection selection) {
        ArrayList<URI> results = new ArrayList<URI>();
        block0: for (Object next : selection) {
            if (!(next instanceof IPapyrusFile)) {
                if (next instanceof IContainer) {
                    IContainer iContainer = (IContainer)next;
                    ArrayList<URI> diFiles = new ArrayList<URI>();
                    IPath path = iContainer.getLocation();
                    IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
                    this.recursiveFindDiFiles(diFiles, path, workspaceRoot);
                    results.addAll(diFiles);
                    continue;
                }
                Object object = BusinessModelResolver.getInstance().getBusinessModel(next);
                if (object instanceof EObject) {
                    Resource eResource;
                    Resource resource = eResource = object instanceof Resource ? (Resource)object : ((EObject)object).eResource();
                    if (eResource != null) {
                        URI theURI = null;
                        if (eResource.getURI().fileExtension().equalsIgnoreCase("uml")) {
                            theURI = eResource.getURI().trimFileExtension();
                            theURI = theURI.appendFileExtension("di");
                        } else {
                            theURI = eResource.getURI();
                        }
                        results.add(theURI);
                        continue;
                    }
                    results.addAll(this.createWorkspaceScope());
                    continue;
                }
                results.addAll(this.createWorkspaceScope());
                continue;
            }
            for (IScopeProvider iScopeProvider : this.getScopeProviders()) {
                Collection<URI> scope = iScopeProvider.getScope(next);
                if (scope.isEmpty()) continue;
                results.addAll(scope);
                continue block0;
            }
        }
        if (results.isEmpty()) {
            results.addAll(this.createWorkspaceScope());
        }
        return results;
    }

    protected void recursiveFindDiFiles(ArrayList<URI> diFiles, IPath path, IWorkspaceRoot workspaceRoot) {
        IContainer container = workspaceRoot.getContainerForLocation(path);
        try {
            IResource[] iResources;
            IResource[] iResourceArray = iResources = container.members();
            int n = iResources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource iResource = iResourceArray[n2];
                IFile iFile = (IFile)iResource.getAdapter(IFile.class);
                if (iFile != null) {
                    if ("di".equalsIgnoreCase(iResource.getFileExtension())) {
                        URI theURI = URI.createPlatformResourceURI((String)iResource.getFullPath().toString(), (boolean)true);
                        diFiles.add(theURI);
                    }
                } else {
                    IPath tmpPath = iResource.getLocation();
                    this.recursiveFindDiFiles(diFiles, tmpPath, workspaceRoot);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    protected List<URI> createProjectsScope(String[] projects) {
        ArrayList<URI> results = new ArrayList<URI>();
        String[] stringArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            String projectName = stringArray[n2];
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            if (project.isOpen()) {
                results.addAll(WorkspaceScopeProvider.findPapyrusModels((IResource)project));
            }
            ++n2;
        }
        return results;
    }

    protected List<URI> createWorkingSetsScope(IWorkingSet[] workingSets) {
        ArrayList<URI> results = new ArrayList<URI>();
        if (workingSets != null && workingSets.length > 0) {
            IWorkingSet[] iWorkingSetArray = workingSets;
            int n = workingSets.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkingSet iWorkingSet = iWorkingSetArray[n2];
                IAdaptable[] iAdaptableArray = iWorkingSet.getElements();
                int n3 = iAdaptableArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IAdaptable element = iAdaptableArray[n4];
                    Object resource = element.getAdapter(IResource.class);
                    if (resource instanceof IResource) {
                        results.addAll(WorkspaceScopeProvider.findPapyrusModels((IResource)resource));
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return results;
    }

    protected Collection<URI> createWorkspaceScope() {
        ArrayList<URI> result = new ArrayList<URI>();
        for (IScopeProvider iScopeProvider : this.getScopeProviders()) {
            result.addAll(iScopeProvider.getScope());
        }
        return result;
    }

    private Iterable<? extends IScopeProvider> loadScopeProviders() {
        return new ProvidersReader().load();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Iterable<? extends IScopeProvider> getScopeProviders() {
        ArrayList<IScopeProvider> result = new ArrayList<IScopeProvider>();
        Iterable<? extends IScopeProvider> iterable = this.scopeProviders;
        synchronized (iterable) {
            for (IScopeProvider iScopeProvider : this.scopeProviders) {
                result.add(iScopeProvider);
            }
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PriorityScopeProvider
    implements IScopeProvider,
    Comparable<PriorityScopeProvider> {
        private final IScopeProvider delegate;
        private final int priority;

        public PriorityScopeProvider(IScopeProvider delegate, int priority) {
            this.delegate = delegate;
            this.priority = priority;
        }

        @Override
        public int compareTo(PriorityScopeProvider o) {
            return o.priority - this.priority;
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof PriorityScopeProvider && ((PriorityScopeProvider)obj).delegate.equals(this.delegate);
        }

        @Override
        public Collection<URI> getScope() {
            return this.delegate.getScope();
        }

        @Override
        public Collection<URI> getScope(Object selected) {
            return this.delegate.getScope(selected);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ProvidersReader
    extends RegistryReader {
        private static final String EXT_PT = "scopeProviders";
        private static final String TAG_PROVIDER = "scopeProvider";
        private static final String ATTR_CLASS = "class";
        private static final String ATTR_PRIORITY = "priority";
        private final SortedSet<PriorityScopeProvider> providers;

        ProvidersReader() {
            super(Platform.getExtensionRegistry(), "org.eclipse.papyrus.views.search", EXT_PT);
            this.providers = new TreeSet<PriorityScopeProvider>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Iterable<? extends IScopeProvider> load() {
            SortedSet<PriorityScopeProvider> sortedSet = this.providers;
            synchronized (sortedSet) {
                this.providers.clear();
                this.readRegistry();
            }
            return this.providers;
        }

        protected boolean readElement(IConfigurationElement element, boolean add) {
            boolean result = false;
            if (TAG_PROVIDER.equals(element.getName())) {
                result = true;
                String className = element.getAttribute(ATTR_CLASS);
                if (className == null || className.length() == 0) {
                    this.logMissingAttribute(element, ATTR_CLASS);
                } else if (add) {
                    this.addProvider(element, className);
                } else {
                    this.removeProvider(element, className);
                }
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addProvider(IConfigurationElement element, String className) {
            block9: {
                try {
                    Object provider = element.createExecutableExtension(ATTR_CLASS);
                    if (!(provider instanceof IScopeProvider)) {
                        Activator.log.error("Scope provider extension does not implement IScopeProvider interface: " + className, null);
                        break block9;
                    }
                    String priorityString = element.getAttribute(ATTR_PRIORITY);
                    int priority = 0;
                    try {
                        if (priorityString != null && priorityString.length() > 0 && (priority = Integer.parseInt(priorityString)) < 0) {
                            Activator.log.warn("Negative priority in scope provider " + className);
                            priority = 0;
                        }
                    }
                    catch (NumberFormatException e) {
                        Activator.log.warn("Not an integer priority in scope provider " + className);
                    }
                    SortedSet<PriorityScopeProvider> sortedSet = this.providers;
                    synchronized (sortedSet) {
                        this.providers.add(new PriorityScopeProvider((IScopeProvider)provider, priority));
                    }
                }
                catch (CoreException e) {
                    Activator.getDefault().getLog().log(e.getStatus());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeProvider(IConfigurationElement element, String className) {
            SortedSet<PriorityScopeProvider> sortedSet = this.providers;
            synchronized (sortedSet) {
                Iterator iter = this.providers.iterator();
                while (iter.hasNext()) {
                    if (!((PriorityScopeProvider)iter.next()).delegate.getClass().getName().equals(className)) continue;
                    iter.remove();
                }
            }
        }
    }
}

