/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.dnd.lifeline;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.papyrus.infra.gmfdiag.dnd.strategy.TransactionalDropStrategy;
import org.eclipse.swt.graphics.Image;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;

public class ClassifierToLifelineDropStrategy
extends TransactionalDropStrategy {
    public String getLabel() {
        return "Type a Lifeline";
    }

    public String getDescription() {
        return "Drop a classifier on a Lifeline to type it. This will create a new Property in the interaction, typed by the dropped classifier. The Lifeline will represent this property.It is also possible to drop directly an already existing Property to the lifeline.";
    }

    public Image getImage() {
        return null;
    }

    public String getID() {
        return "org.eclipse.papyrus.uml.diagram.dnd.lifeline.represents";
    }

    @Deprecated
    public int getPriority() {
        return 0;
    }

    protected Command doGetCommand(Request request, EditPart targetEditPart) {
        EObject targetElement = this.getTargetSemanticElement(targetEditPart);
        if (!(targetElement instanceof Lifeline)) {
            return null;
        }
        final Lifeline targetLifeline = (Lifeline)targetElement;
        final Interaction interaction = targetLifeline.getInteraction();
        if (interaction == null) {
            return null;
        }
        List sourceElements = this.getSourceEObjects(request);
        if (sourceElements.size() != 1) {
            return null;
        }
        EObject sourceElement = (EObject)sourceElements.get(0);
        if (sourceElement instanceof Type) {
            final Type sourceType = (Type)sourceElement;
            Command resultCommand = new Command(this.getLabel()){

                public void execute() {
                    Property property = interaction.createOwnedAttribute("", sourceType);
                    targetLifeline.setRepresents((ConnectableElement)property);
                }
            };
            return resultCommand;
        }
        if (sourceElement instanceof Property) {
            final Property property = (Property)sourceElement;
            Command resultCommand = new Command(this.getLabel()){

                public void execute() {
                    targetLifeline.setRepresents((ConnectableElement)property);
                }
            };
            return resultCommand;
        }
        return null;
    }
}

