/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.alf.libraries.helper;

import java.util.Iterator;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.uml.alf.libraries.helper.ApplyProfileCommand;
import org.eclipse.papyrus.uml.extensionpoints.profile.IRegisteredProfile;
import org.eclipse.papyrus.uml.extensionpoints.profile.RegisteredProfile;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Stereotype;

public class AlfUtil {
    private static AlfUtil singleton;

    private AlfUtil() {
    }

    public static AlfUtil getInstance() {
        if (singleton == null) {
            singleton = new AlfUtil();
        }
        return singleton;
    }

    public String getTextualRepresentation(Element element) {
        String representation = "";
        Comment textualRepresentationComment = this.getTextualRepresentationComment(element);
        if (textualRepresentationComment != null) {
            representation = textualRepresentationComment.getBody();
        }
        return representation;
    }

    public Comment getTextualRepresentationComment(Element element) {
        Comment textualRepresentationComment = null;
        Iterator commentsIterator = element.getOwnedComments().iterator();
        while (commentsIterator.hasNext() && textualRepresentationComment == null) {
            Comment comment = (Comment)commentsIterator.next();
            if (comment.getBody() == null || !this.isATextualRepresentationComment(comment)) continue;
            textualRepresentationComment = comment;
        }
        return textualRepresentationComment;
    }

    public Profile getStandardProfile(Model context) {
        return this.getAppliedProfile(context, "StandardProfile");
    }

    public Profile getActionLanguageProfile(Model context) {
        return this.getAppliedProfile(context, "ActionLanguage");
    }

    public Profile loadProfile(Model context, String name) {
        Resource modelResource;
        IRegisteredProfile registeredProfile;
        Profile searchedProfile = null;
        ResourceSet resourceSet = context.eResource().getResourceSet();
        if (resourceSet != null && (registeredProfile = RegisteredProfile.getRegisteredProfile((String)name)) != null) {
            Iterator resourceIterator = resourceSet.getResources().iterator();
            Resource searchedResource = null;
            while (searchedResource == null && resourceIterator.hasNext()) {
                searchedResource = (Resource)resourceIterator.next();
                if (searchedResource.getURI().equals(registeredProfile.getUri())) continue;
                searchedResource = null;
            }
            if (searchedResource != null) {
                searchedProfile = (Profile)searchedResource.getContents().get(0);
            }
        }
        if (searchedProfile == null && (registeredProfile = RegisteredProfile.getRegisteredProfile((String)name)) != null && (modelResource = context.eResource().getResourceSet().getResource(registeredProfile.getUri(), true)).getContents().get(0) instanceof Profile) {
            searchedProfile = (Profile)modelResource.getContents().get(0);
        }
        return searchedProfile;
    }

    protected boolean isProfileApplied(Model context, String profileName) {
        return this.getAppliedProfile(context, profileName) != null;
    }

    protected Profile getAppliedProfile(Model context, String profileName) {
        Iterator appliedProfilesIterator = context.getAppliedProfiles().iterator();
        Profile searchedProfile = null;
        while (searchedProfile == null && appliedProfilesIterator.hasNext()) {
            searchedProfile = (Profile)appliedProfilesIterator.next();
            if (searchedProfile.getName().equals(profileName)) continue;
            searchedProfile = null;
        }
        return searchedProfile;
    }

    private Stereotype getTextualRepresentationStereotype(Element context) {
        Profile actionLanguageProfile;
        if (context != null && (actionLanguageProfile = this.getAppliedProfile(context.getModel(), "ActionLanguage")) != null) {
            return actionLanguageProfile.getOwnedStereotype("TextualRepresentation");
        }
        return null;
    }

    public boolean isATextualRepresentationComment(Comment comment) {
        Stereotype textualRepresentationStereotype = this.getTextualRepresentationStereotype((Element)comment);
        return textualRepresentationStereotype != null && comment.getAppliedStereotypes().contains((Object)textualRepresentationStereotype) && "Alf".equals(comment.getValue(textualRepresentationStereotype, "language"));
    }

    public boolean isActionLanguageProfileApplied(Element context) {
        if (context.getModel() != null) {
            return this.isProfileApplied(context.getModel(), "ActionLanguage");
        }
        return false;
    }

    public boolean isStandardProfileApplied(Element context) {
        if (context.getModel() != null) {
            return this.isProfileApplied(context.getModel(), "StandardProfile");
        }
        return false;
    }

    protected boolean applyProfile(Model model, Profile profile) {
        if (model == null || profile == null) {
            return false;
        }
        ApplyProfileCommand command = new ApplyProfileCommand(profile, model);
        TransactionalEditingDomain domain = command.getEditingDomain();
        domain.getCommandStack().execute((Command)new GMFtoEMFCommandWrapper((ICommand)command));
        return command.getCommandResult().getStatus().isOK();
    }

    public boolean applyActionLanguageProfile(Element context) {
        boolean applied = this.isActionLanguageProfileApplied(context);
        if (!applied) {
            applied = this.applyProfile(context.getModel(), this.loadProfile(context.getModel(), "ActionLanguage"));
        }
        return applied;
    }

    public boolean applyStandardProfile(Element context) {
        boolean applied = this.isStandardProfileApplied(context);
        if (!applied) {
            applied = this.applyProfile(context.getModel(), this.loadProfile(context.getModel(), "Standard"));
        }
        return applied;
    }

    public boolean applyTextualRepresentation(Comment comment) {
        boolean applied = this.isActionLanguageProfileApplied((Element)comment);
        if (!applied) {
            applied = this.applyActionLanguageProfile((Element)comment);
        }
        if (applied && !this.isATextualRepresentationComment(comment)) {
            Stereotype textualRepresentation = this.getTextualRepresentationStereotype((Element)comment);
            comment.applyStereotype(textualRepresentation);
            comment.setValue(textualRepresentation, "language", (Object)"Alf");
        }
        return applied;
    }

    class AlfUtilConstants {
        protected static final String STANDARD_PROFILE_NAME = "Standard";
        protected static final String STANDARD_PROFILE_LOADING_NAME = "StandardProfile";
        protected static final String ACTION_LANGUAGE_PROFILE_NAME = "ActionLanguage";
        protected static final String TEXTUAL_REPRESENTATION_STEREOTYPE_NAME = "TextualRepresentation";
        protected static final String TEXTUALREPRESENTATION_LANGUAGE_ATTR_NAME = "language";

        AlfUtilConstants() {
        }
    }
}

