/*****************************************************************************
 * Copyright (c) 2022 CEA LIST
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *  Ibtihel Khemir (CEA LIST) <ibtihel.khemir@cea.fr> - Initial API and implementation
 *****************************************************************************/
package org.eclipse.papyrus.sirius.uml.diagram.statemachine.constants;

/**
 * This class provides creation tools ids for Sirius StateMachine Diagram odesign
 */
public class SMD_CreationToolsIds {

	private SMD_CreationToolsIds() {
		// to prevent instantiation
	}

	/* Nodes */

	public static final String CREATE__CHOICE__TOOL = "CreateChoiceTool"; //$NON-NLS-1$
	public static final String CREATE__COMMENT__TOOL = "CreateCommentTool"; //$NON-NLS-1$
	public static final String CREATE__CONSTRAINT__TOOL = "CreateConstraintTool"; //$NON-NLS-1$
	public static final String CREATE__DEEPHISTORY__TOOL = "CreateDeepHistoryTool"; //$NON-NLS-1$
	public static final String CREATE__ENTRYPOINT__TOOL = "CreateEntryPointTool"; //$NON-NLS-1$
	public static final String CREATE__EXITPOINT__TOOL = "CreateExitPointTool"; //$NON-NLS-1$
	public static final String CREATE__FINALSTATE__TOOL = "CreateFinalStateTool"; //$NON-NLS-1$
	public static final String CREATE__FORK__TOOL = "CreateForkTool"; //$NON-NLS-1$
	public static final String CREATE__INITIAL__TOOL = "CreateInitialTool"; //$NON-NLS-1$
	public static final String CREATE__JOIN__TOOL = "CreateJoinTool"; //$NON-NLS-1$
	public static final String CREATE__JUNCTION__TOOL = "CreateJunctionTool"; //$NON-NLS-1$
	public static final String CREATE__REGION__TOOL = "CreateRegionTool"; //$NON-NLS-1$
	public static final String CREATE__SHALLOWHISTORY__TOOL = "CreateShallowHistoryTool"; //$NON-NLS-1$
	public static final String CREATE__STATE__TOOL = "CreateStateTool"; //$NON-NLS-1$
	public static final String CREATE__TERMINATE__TOOL = "CreateTerminateTool"; //$NON-NLS-1$	

	/* Edges */

	public static final String CREATE__CONTEXTLINK__TOOL = "CreateContextLinkTool"; //$NON-NLS-1$
	public static final String CREATE__LINK__TOOL = "CreateLinkTool"; //$NON-NLS-1$
	public static final String CREATE__TRANSITION__TOOL = "CreateTransitionTool"; //$NON-NLS-1$

}
