/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.customization.properties.generation.wizard;

import java.util.List;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.databinding.wizard.WizardPageSupport;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.papyrus.customization.properties.generation.extensionpoint.LayoutExtensionPoint;
import org.eclipse.papyrus.customization.properties.generation.generators.IGenerator;
import org.eclipse.papyrus.customization.properties.generation.layout.ILayoutGenerator;
import org.eclipse.papyrus.customization.properties.generation.messages.Messages;
import org.eclipse.papyrus.customization.properties.generation.validators.SourceValidator;
import org.eclipse.papyrus.customization.properties.generation.validators.TargetValidator;
import org.eclipse.papyrus.customization.properties.generation.wizard.AbstractCreateContextPage;
import org.eclipse.papyrus.customization.properties.generation.wizard.widget.FileChooser;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class GeneratorPage
extends AbstractCreateContextPage
implements Listener {
    private final List<ILayoutGenerator> layoutGenerators;
    protected IGenerator generator;
    private Composite root;
    private Composite generatorControl;
    protected FileChooser targetFileChooser;
    private CCombo layoutCombo;
    protected IObservableValue srcTextObservable;
    protected IObservableValue targetTextObservable;
    protected UpdateValueStrategy srcFieldStrategy;
    protected UpdateValueStrategy targetFieldStrategy;
    protected SourceValidator srcValidator;
    protected TargetValidator targetValidator;
    protected Binding binding;
    protected DataBindingContext ctx = new DataBindingContext();
    protected boolean next = false;
    protected URI oldURI;

    public GeneratorPage() {
        super(Messages.GeneratorPage_title);
        this.srcFieldStrategy = new UpdateValueStrategy();
        this.targetFieldStrategy = new UpdateValueStrategy();
        this.layoutGenerators = new LayoutExtensionPoint().getGenerators();
    }

    public void setGenerator(IGenerator generator) {
        this.cleanGeneratorControl();
        generator.addListener(this);
        this.setDescription(generator.getDescription());
        this.generator = generator;
        generator.createControls(this.generatorControl, this.getWizard().getCurrentlySelectedFile().orElse(null));
        this.generatorControl.layout();
        this.srcTextObservable = this.generator.getObservableValue();
        this.root.layout();
    }

    public void dispose() {
        this.generator.removeListener(this);
    }

    public boolean isPageComplete() {
        return this.targetFileChooser.getFilePath() != null && this.generator != null && this.generator.isReady();
    }

    private void cleanGeneratorControl() {
        Control[] controlArray = this.generatorControl.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.dispose();
            ++n2;
        }
    }

    public void createControl(Composite parent) {
        this.root = new Composite(parent, 0);
        this.root.setLayout((Layout)new GridLayout(2, false));
        this.root.setLayoutData((Object)new GridData(4, 4, true, true));
        this.generatorControl = new Composite(this.root, 0);
        this.generatorControl.setLayout((Layout)new FillLayout());
        this.generatorControl.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        Label layoutGeneratorLabel = new Label(this.root, 0);
        layoutGeneratorLabel.setText(Messages.GeneratorPage_layoutGenerator);
        GridData data = new GridData();
        data.widthHint = 100;
        layoutGeneratorLabel.setLayoutData((Object)data);
        this.layoutCombo = new CCombo(this.root, 2048);
        this.layoutCombo.setLayoutData((Object)new GridData(4, 4, true, false));
        this.layoutCombo.setEditable(false);
        this.layoutCombo.setBackground(new Color((Device)this.layoutCombo.getDisplay(), 255, 255, 255));
        for (ILayoutGenerator layoutGenerator : this.layoutGenerators) {
            this.layoutCombo.add(layoutGenerator.getName());
        }
        this.layoutCombo.select(0);
        Label targetLabel = new Label(this.root, 0);
        targetLabel.setText(Messages.GeneratorPage_target);
        data = new GridData();
        data.widthHint = 100;
        targetLabel.setLayoutData((Object)data);
        this.targetFileChooser = new FileChooser(this.root, true);
        this.targetFileChooser.setLayoutData(new GridData(4, 4, true, false));
        this.targetFileChooser.addListener(this);
        this.targetTextObservable = this.targetFileChooser.getObservableValue();
        this.targetFileChooser.setFilterExtensions(new String[]{"ctx"});
        if (this.targetFieldStrategy != null) {
            this.targetFieldStrategy.setConverter(new IConverter(){

                public Object getToType() {
                    return String.class;
                }

                public Object getFromType() {
                    return String.class;
                }

                public String convert(Object fromObject) {
                    if (GeneratorPage.this.srcTextObservable != null) {
                        return (String)GeneratorPage.this.srcTextObservable.getValue();
                    }
                    if (GeneratorPage.this.targetFileChooser.getFilePath() != null) {
                        return GeneratorPage.this.targetFileChooser.getFilePath();
                    }
                    return "";
                }
            });
        }
        if (this.srcFieldStrategy != null) {
            this.srcFieldStrategy.setConverter(new IConverter(){

                public Object getToType() {
                    return String.class;
                }

                public Object getFromType() {
                    return String.class;
                }

                public String convert(Object fromObject) {
                    if (fromObject instanceof String) {
                        String stringObject = (String)fromObject;
                        if (stringObject.equals("")) {
                            return "";
                        }
                        String[] result = stringObject.split("/");
                        String filename = result[result.length - 1];
                        String[] ext = filename.split("\\.");
                        StringBuilder builder = new StringBuilder();
                        if (GeneratorPage.this.targetTextObservable != null) {
                            String s = (String)GeneratorPage.this.targetTextObservable.getValue();
                            if (!s.equals("")) {
                                String[] original = s.split("/");
                                builder.append("/");
                                int i = 1;
                                while (i < original.length - 1) {
                                    builder.append(original[i]);
                                    builder.append("/");
                                    ++i;
                                }
                            } else {
                                builder.append("/");
                                builder.append(result[1]);
                                builder.append("/properties/");
                            }
                        }
                        builder.append(ext[0]);
                        builder.append(".ctx");
                        return builder.toString();
                    }
                    return "";
                }
            });
        }
        WizardPageSupport.create((WizardPage)this, (DataBindingContext)this.ctx);
        this.setControl((Control)this.root);
    }

    public void handleEvent(Event event) {
        String filePath = this.targetFileChooser.getFilePath();
        if (filePath != null) {
            super.getContainer().updateButtons();
        }
    }

    public IWizardPage getNextPage() {
        int selection = this.layoutCombo.getSelectionIndex();
        this.getWizard().layoutGenerator = this.layoutGenerators.get(selection);
        this.oldURI = URI.createPlatformResourceURI((String)this.targetFileChooser.getFilePath(), (boolean)true);
        return super.getNextPage();
    }

    public void doBinding() {
        if (this.srcTextObservable != null || this.targetTextObservable != null) {
            this.srcValidator = new SourceValidator(this.generator);
            this.targetValidator = new TargetValidator();
            this.srcFieldStrategy.setAfterGetValidator((IValidator)this.srcValidator);
            this.srcFieldStrategy.setAfterConvertValidator((IValidator)this.targetValidator);
            this.targetFieldStrategy.setAfterGetValidator((IValidator)this.targetValidator);
            this.targetFieldStrategy.setAfterConvertValidator((IValidator)this.srcValidator);
            this.binding = this.ctx.bindValue(this.srcTextObservable, this.targetTextObservable, this.srcFieldStrategy, this.targetFieldStrategy);
            this.binding.getValidationStatus().addValueChangeListener(event -> {
                IStatus status = (IStatus)event.diff.getNewValue();
                if (status.isOK() || status.getSeverity() == 2) {
                    this.setNext(true);
                } else {
                    this.setNext(false);
                }
            });
            if (this.srcTextObservable.getValue() != null && !"".equals(this.srcTextObservable.getValue())) {
                this.binding.updateTargetToModel();
            }
        }
    }

    public boolean canFlipToNextPage() {
        return this.next;
    }

    public void setNext(boolean next) {
        this.next = next;
        super.getContainer().updateButtons();
    }

    public void setStrategy(int strategy) {
        this.generator.setStrategy(strategy);
    }
}

