/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.persistence.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.nebula.widgets.nattable.Messages;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.persistence.PersistenceHelper;
import org.eclipse.nebula.widgets.nattable.persistence.command.IStateChangedListener;
import org.eclipse.nebula.widgets.nattable.persistence.command.StateChangeEvent;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PersistenceDialog
extends Dialog {
    public static final String ACTIVE_VIEW_CONFIGURATION_KEY = "PersistenceDialog.activeViewConfiguration";
    public static final int SAVE_ID = 2;
    public static final int LOAD_ID = 3;
    public static final int DELETE_ID = 4;
    private NatTable natTable;
    private Properties properties;
    private TableViewer viewer;
    private ControlDecoration configNameDeco;
    private Text configNameText;
    private List<IStateChangedListener> stateChangeListeners = new ArrayList<IStateChangedListener>();

    public PersistenceDialog(Shell parentShell, NatTable natTable, Properties properties) {
        super(parentShell);
        this.setShellStyle(67696);
        if (natTable == null) {
            throw new IllegalArgumentException("natTable can not be null!");
        }
        if (properties == null) {
            throw new IllegalArgumentException("properties can not be null!");
        }
        this.natTable = natTable;
        this.properties = properties;
    }

    protected Control createDialogArea(Composite parent) {
        Composite control = (Composite)super.createDialogArea(parent);
        Label viewerLabel = new Label(control, 0);
        viewerLabel.setText(Messages.getString("PersistenceDialog.viewerLabel"));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)viewerLabel);
        this.viewer = new TableViewer(control);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewConfigurationNameLabelProvider());
        this.viewer.setComparator(new ViewerComparator());
        GridDataFactory.fillDefaults().grab(true, true).applyTo(this.viewer.getControl());
        Composite nameContainer = new Composite(control, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        nameContainer.setLayout((Layout)layout);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)nameContainer);
        Label label = new Label(nameContainer, 0);
        label.setText(Messages.getString("PersistenceDialog.nameLabel"));
        this.configNameText = new Text(nameContainer, 2048);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.configNameText);
        this.configNameText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 13 && event.stateMask == 0 || event.keyCode == 0x1000050 && event.stateMask == 0) {
                    PersistenceDialog.this.buttonPressed(2);
                }
            }
        });
        this.configNameText.addModifyListener(e -> {
            if (this.configNameText.getText().length() != 0) {
                this.configNameDeco.hide();
            }
        });
        this.configNameDeco = new ControlDecoration((Control)this.configNameText, 131072);
        Image image = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage();
        this.configNameDeco.setDescriptionText(Messages.getString("PersistenceDialog.nameErrorText"));
        this.configNameDeco.setImage(image);
        this.configNameDeco.hide();
        this.viewer.addSelectionChangedListener(event -> {
            ISelection selection = event.getSelection();
            if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
                String configName = ((IStructuredSelection)selection).getFirstElement().toString();
                this.configNameText.setText(configName);
            }
        });
        this.viewer.addDoubleClickListener(event -> this.buttonPressed(3));
        this.viewer.add(PersistenceHelper.getAvailableStates(this.properties).toArray());
        return control;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 4, Messages.getString("PersistenceDialog.buttonDelete"), false);
        this.createButton(parent, 2, Messages.getString("PersistenceDialog.buttonSave"), false);
        this.createButton(parent, 3, Messages.getString("PersistenceDialog.buttonLoad"), false);
        this.createButton(parent, 0, Messages.getString("PersistenceDialog.buttonDone"), false);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 2) {
            String configName = this.configNameText.getText();
            if (configName == null || configName.length() == 0) {
                this.configNameDeco.show();
                return;
            }
            this.configNameDeco.hide();
            this.natTable.saveState(configName, this.properties);
            String oldActiveName = this.getActiveViewConfigurationName();
            this.setActiveViewConfigurationName(configName);
            this.viewer.refresh((Object)oldActiveName, true);
            this.configNameText.setText("");
            int i = 0;
            while (i < this.viewer.getTable().getItemCount()) {
                String element = this.viewer.getElementAt(i).toString();
                if (configName.equals(element)) {
                    this.fireStateChange(new StateChangeEvent(configName, StateChangeEvent.StateChangeType.CHANGE));
                    return;
                }
                ++i;
            }
            this.viewer.add((Object)configName);
            this.fireStateChange(new StateChangeEvent(configName, StateChangeEvent.StateChangeType.CREATE));
        } else if (buttonId == 4) {
            ISelection selection = this.viewer.getSelection();
            if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
                String configName = ((IStructuredSelection)selection).getFirstElement().toString();
                PersistenceHelper.deleteState(configName, this.properties);
                this.viewer.getTable().deselectAll();
                this.viewer.remove((Object)configName);
                this.configNameText.setText("");
                this.fireStateChange(new StateChangeEvent(configName, StateChangeEvent.StateChangeType.DELETE));
            }
        } else if (buttonId == 3) {
            ISelection selection = this.viewer.getSelection();
            if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
                String configName = ((IStructuredSelection)selection).getFirstElement().toString();
                this.natTable.loadState(configName, this.properties);
                this.setActiveViewConfigurationName(configName);
                super.okPressed();
            }
        } else {
            super.buttonPressed(buttonId);
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.getString("PersistenceDialog.title"));
        newShell.setImage(GUIHelper.getImage("table_icon"));
    }

    protected Point getInitialSize() {
        return new Point(GUIHelper.convertHorizontalPixelToDpi(500, true), GUIHelper.convertVerticalPixelToDpi(300, true));
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public String getActiveViewConfigurationName() {
        return this.properties.getProperty(ACTIVE_VIEW_CONFIGURATION_KEY);
    }

    public void setActiveViewConfigurationName(String name) {
        this.properties.setProperty(ACTIVE_VIEW_CONFIGURATION_KEY, name);
    }

    public void addStateChangeListener(IStateChangedListener listener) {
        this.stateChangeListeners.add(listener);
    }

    public void addAllStateChangeListener(List<IStateChangedListener> listeners) {
        this.stateChangeListeners.addAll(listeners);
    }

    public void removeStateChangeListener(IStateChangedListener listener) {
        this.stateChangeListeners.remove(listener);
    }

    public void removeAllStateChangeListener(List<IStateChangedListener> listeners) {
        this.stateChangeListeners.removeAll(listeners);
    }

    public void fireStateChange(StateChangeEvent event) {
        for (IStateChangedListener listener : this.stateChangeListeners) {
            listener.handleStateChange(event);
        }
    }

    class ViewConfigurationNameLabelProvider
    extends StyledCellLabelProvider {
        private Font italicFont = GUIHelper.getFont(new FontData("Arial", 8, 2));
        private StyledString.Styler italicStyler = new StyledString.Styler(){

            public void applyStyles(TextStyle textStyle) {
                textStyle.font = ViewConfigurationNameLabelProvider.this.italicFont;
            }
        };

        ViewConfigurationNameLabelProvider() {
        }

        public void update(ViewerCell cell) {
            Object element = cell.getElement();
            String result = element == null ? "" : element.toString();
            String prefix = "";
            if (result.equals(PersistenceDialog.this.getActiveViewConfigurationName())) {
                prefix = "* ";
            }
            StyledString.Styler styler = null;
            if (result.length() == 0) {
                result = Messages.getString("PersistenceDialog.defaultStateConfigName");
                styler = this.italicStyler;
            }
            StyledString styledString = new StyledString(String.valueOf(prefix) + result, styler);
            cell.setText(styledString.toString());
            cell.setStyleRanges(styledString.getStyleRanges());
            super.update(cell);
        }
    }
}

