/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.domain.services.reconnect;

import java.util.Objects;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.uml.domain.services.IEditableChecker;
import org.eclipse.papyrus.uml.domain.services.IViewQuerier;
import org.eclipse.papyrus.uml.domain.services.internal.helpers.ConnectorHelper;
import org.eclipse.papyrus.uml.domain.services.internal.helpers.ControlFlowHelper;
import org.eclipse.papyrus.uml.domain.services.internal.helpers.ExtensionHelper;
import org.eclipse.papyrus.uml.domain.services.internal.helpers.ObjectFlowHelper;
import org.eclipse.papyrus.uml.domain.services.reconnect.IDomainBasedEdgeReconnectionTargetChecker;
import org.eclipse.papyrus.uml.domain.services.status.CheckStatus;
import org.eclipse.uml2.uml.Artifact;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.CommunicationPath;
import org.eclipse.uml2.uml.Component;
import org.eclipse.uml2.uml.ComponentRealization;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ControlFlow;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.Deployment;
import org.eclipse.uml2.uml.DeploymentTarget;
import org.eclipse.uml2.uml.Extend;
import org.eclipse.uml2.uml.Extension;
import org.eclipse.uml2.uml.Generalization;
import org.eclipse.uml2.uml.Include;
import org.eclipse.uml2.uml.InformationFlow;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.InterfaceRealization;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.Manifestation;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.ObjectFlow;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageImport;
import org.eclipse.uml2.uml.PackageMerge;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.StructuredClassifier;
import org.eclipse.uml2.uml.Substitution;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Usage;
import org.eclipse.uml2.uml.UseCase;
import org.eclipse.uml2.uml.Vertex;
import org.eclipse.uml2.uml.util.UMLSwitch;

public class ElementDomainBasedEdgeReconnectionTargetChecker
implements IDomainBasedEdgeReconnectionTargetChecker {
    private final IEditableChecker editableChecker;
    private final IViewQuerier representationQuery;

    public ElementDomainBasedEdgeReconnectionTargetChecker(IEditableChecker editableChecker, IViewQuerier representationQuery) {
        this.editableChecker = Objects.requireNonNull(editableChecker);
        this.representationQuery = Objects.requireNonNull(representationQuery);
    }

    @Override
    public CheckStatus canReconnect(EObject edgeToReconnect, EObject oldSemanticEdgeTarget, EObject newSemanticEdgeTarget, Object newTargetView, Object sourceView) {
        if (newSemanticEdgeTarget == null) {
            return CheckStatus.no("The new semantic edge target must not be null");
        }
        return (CheckStatus)new ElementDomainBasedEdgeReconnectionTargetCheckerSwitch(oldSemanticEdgeTarget, newSemanticEdgeTarget, newTargetView, sourceView, this.editableChecker, this.representationQuery).doSwitch(edgeToReconnect);
    }

    public static class ElementDomainBasedEdgeReconnectionTargetCheckerSwitch
    extends UMLSwitch<CheckStatus> {
        private static final String INVALID_USE_CASE_TARGET = "Invalid Use Case target";
        private static final String INVALID_PACKAGEABLE_ELEMENT_TARGET = "Invalid Packageable Element target";
        private static final String INVALID_PACKAGE_CONTAINER = "Invalid Package container";
        private static final String INVALID_NAMED_ELEMENT_TARGET = "Invalid Named Element target";
        private final EObject oldSemanticEdgeTarget;
        private final EObject newSemanticEdgeTarget;
        private final Object newTargetView;
        private final Object sourceView;
        private final IEditableChecker editableChecker;
        private final IViewQuerier representationQuery;

        public ElementDomainBasedEdgeReconnectionTargetCheckerSwitch(EObject oldSemanticEdgeTarget, EObject newSemanticEdgeTarget, Object newTargetView, Object sourceView, IEditableChecker editableChecker, IViewQuerier representationQuery) {
            this.oldSemanticEdgeTarget = oldSemanticEdgeTarget;
            this.newSemanticEdgeTarget = newSemanticEdgeTarget;
            this.newTargetView = newTargetView;
            this.sourceView = sourceView;
            this.editableChecker = editableChecker;
            this.representationQuery = representationQuery;
        }

        public CheckStatus caseAssociation(Association association) {
            CheckStatus result;
            Property targetProperty = (Property)association.getMemberEnds().get(1);
            if (!(this.oldSemanticEdgeTarget instanceof Classifier) || !(this.newSemanticEdgeTarget instanceof Classifier)) {
                result = CheckStatus.no("Invalid Association target: the new target should be a Classifier");
            } else if (!association.getOwnedEnds().contains((Object)targetProperty)) {
                boolean cannotContainProperty;
                boolean bl = cannotContainProperty = !(this.newSemanticEdgeTarget instanceof Artifact) && !(this.newSemanticEdgeTarget instanceof DataType) && !(this.newSemanticEdgeTarget instanceof Interface) && !(this.newSemanticEdgeTarget instanceof Signal) && !(this.newSemanticEdgeTarget instanceof StructuredClassifier);
                result = cannotContainProperty ? CheckStatus.no("Invalid Association target: the new target must be able to contain the TargetProperty attribute") : CheckStatus.YES;
            } else {
                result = CheckStatus.YES;
            }
            return result;
        }

        public CheckStatus caseCommunicationPath(CommunicationPath communicationPath) {
            CheckStatus result = !(this.newSemanticEdgeTarget instanceof Classifier) || !(this.newSemanticEdgeTarget instanceof DeploymentTarget) ? CheckStatus.no("The target of CommunicationPath should be a DeploymentTarget and a Classifier.") : CheckStatus.YES;
            return result;
        }

        public CheckStatus caseComponentRealization(ComponentRealization componentRealization) {
            CheckStatus result = !(this.newSemanticEdgeTarget instanceof Component) ? CheckStatus.no("The target of a ComponentRealization should be a Component") : (componentRealization.getRealizingClassifiers().contains((Object)this.newSemanticEdgeTarget) ? CheckStatus.no("The source and target of a ComponentRealization must be different") : CheckStatus.YES);
            return result;
        }

        public CheckStatus caseConnector(Connector connector) {
            ConnectorHelper connectorHelper = new ConnectorHelper();
            return connectorHelper.canCreateConnector(this.representationQuery, this.sourceView, this.newTargetView);
        }

        public CheckStatus caseControlFlow(ControlFlow controlFlow) {
            if (new ControlFlowHelper().canCreateControlFlow((EObject)controlFlow.getSource(), this.newSemanticEdgeTarget)) {
                return CheckStatus.YES;
            }
            return CheckStatus.no(INVALID_NAMED_ELEMENT_TARGET);
        }

        public CheckStatus caseDependency(Dependency object) {
            CheckStatus result = this.newSemanticEdgeTarget == null || !(this.newSemanticEdgeTarget instanceof NamedElement) ? CheckStatus.no("Dependency target can only be reconnected to a non null NamedElement.") : CheckStatus.YES;
            return result;
        }

        public CheckStatus caseDeployment(Deployment deployment) {
            CheckStatus result = !this.editableChecker.canEdit(this.newSemanticEdgeTarget) ? CheckStatus.no("Can't edit new target.") : (this.newSemanticEdgeTarget instanceof DeploymentTarget ? CheckStatus.YES : CheckStatus.no("Deployment target can only be reconnected to a DeploymentTarget."));
            return result;
        }

        public CheckStatus caseExtend(Extend extend) {
            CheckStatus result = this.newSemanticEdgeTarget == null || !(this.newSemanticEdgeTarget instanceof UseCase) ? CheckStatus.no("Extend target can only be reconnected to a non null UseCase.") : (extend.getExtension() == this.newSemanticEdgeTarget ? CheckStatus.no("Extend cannot use the same element for source and target.") : CheckStatus.YES);
            return result;
        }

        public CheckStatus caseExtension(Extension extension) {
            ExtensionHelper extensionHelper = new ExtensionHelper();
            CheckStatus result = extensionHelper.canCreate(extension.getStereotype(), this.newSemanticEdgeTarget) ? CheckStatus.YES : CheckStatus.no("Extension can only be connected between a Stereotype and a Metaclass.");
            return result;
        }

        public CheckStatus caseGeneralization(Generalization generalization) {
            CheckStatus result = !(this.oldSemanticEdgeTarget instanceof Classifier) || !(this.newSemanticEdgeTarget instanceof Classifier) ? CheckStatus.no("Invalid Classifier target") : (generalization.getSpecific() == this.newSemanticEdgeTarget ? CheckStatus.no("Generalization cannot use the same element for source and target.") : CheckStatus.YES);
            return result;
        }

        public CheckStatus caseInclude(Include include) {
            CheckStatus result = !(this.oldSemanticEdgeTarget instanceof UseCase) || !(this.newSemanticEdgeTarget instanceof UseCase) ? CheckStatus.no(INVALID_USE_CASE_TARGET) : (include.getIncludingCase() == this.newSemanticEdgeTarget ? CheckStatus.no("Include cannot use the same element for source and target.") : CheckStatus.YES);
            return result;
        }

        public CheckStatus caseInformationFlow(InformationFlow informationFlow) {
            CheckStatus result = !(this.newSemanticEdgeTarget instanceof NamedElement) ? CheckStatus.no(INVALID_NAMED_ELEMENT_TARGET) : (!(informationFlow.eContainer() instanceof Package) ? CheckStatus.no(INVALID_PACKAGE_CONTAINER) : CheckStatus.YES);
            return result;
        }

        public CheckStatus caseInterfaceRealization(InterfaceRealization interfaceRealization) {
            CheckStatus result = !(this.oldSemanticEdgeTarget instanceof Interface) || !(this.newSemanticEdgeTarget instanceof Interface) ? CheckStatus.no("The target of a InterfaceRealization should be an Interface") : CheckStatus.YES;
            return result;
        }

        public CheckStatus caseManifestation(Manifestation manifestation) {
            CheckStatus result = !(this.newSemanticEdgeTarget instanceof PackageableElement) ? CheckStatus.no(INVALID_PACKAGEABLE_ELEMENT_TARGET) : (this.newSemanticEdgeTarget == manifestation.getUtilizedElement() ? CheckStatus.no("Manifestation cannot use the same element for source and target.") : CheckStatus.YES);
            return result;
        }

        public CheckStatus caseMessage(Message message) {
            CheckStatus result = !(this.newSemanticEdgeTarget instanceof Lifeline) ? CheckStatus.no(INVALID_NAMED_ELEMENT_TARGET) : CheckStatus.YES;
            return result;
        }

        public CheckStatus caseObjectFlow(ObjectFlow objectFlow) {
            if (new ObjectFlowHelper().canCreateObjectFlow((EObject)objectFlow.getSource(), this.newSemanticEdgeTarget)) {
                return CheckStatus.YES;
            }
            return CheckStatus.no(INVALID_NAMED_ELEMENT_TARGET);
        }

        public CheckStatus casePackageImport(PackageImport object) {
            CheckStatus result = !(this.oldSemanticEdgeTarget instanceof Package) || !(this.newSemanticEdgeTarget instanceof Package) ? CheckStatus.no("Invalid PackageImport source or target") : (!(object.eContainer() instanceof Package) ? CheckStatus.no(INVALID_PACKAGE_CONTAINER) : CheckStatus.YES);
            return result;
        }

        public CheckStatus casePackageMerge(PackageMerge object) {
            CheckStatus result = !(this.oldSemanticEdgeTarget instanceof Package) || !(this.newSemanticEdgeTarget instanceof Package) ? CheckStatus.no("Invalid PackageMerge source or target") : (!(object.eContainer() instanceof Package) ? CheckStatus.no(INVALID_PACKAGE_CONTAINER) : CheckStatus.YES);
            return result;
        }

        public CheckStatus caseSubstitution(Substitution substitution) {
            CheckStatus result = !(this.newSemanticEdgeTarget instanceof Classifier) ? CheckStatus.no("Invalid Classifier target") : (substitution.getSubstitutingClassifier() == this.newSemanticEdgeTarget ? CheckStatus.no("Substitution cannot use the same element for source and target.") : CheckStatus.YES);
            return result;
        }

        public CheckStatus caseTransition(Transition transition) {
            CheckStatus result = !this.editableChecker.canEdit((EObject)transition) ? CheckStatus.no("Can't edit the Transition.") : (!(this.oldSemanticEdgeTarget instanceof Vertex) || !(this.newSemanticEdgeTarget instanceof Vertex) ? CheckStatus.no("Invalid semantic source") : CheckStatus.YES);
            return result;
        }

        public CheckStatus caseUsage(Usage usage) {
            CheckStatus result = !(this.oldSemanticEdgeTarget instanceof NamedElement) || !(this.newSemanticEdgeTarget instanceof NamedElement) ? CheckStatus.no(INVALID_NAMED_ELEMENT_TARGET) : CheckStatus.YES;
            return result;
        }

        public CheckStatus defaultCase(EObject object) {
            return CheckStatus.YES;
        }
    }
}

