/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.domain.services.profile;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.papyrus.uml.domain.services.profile.ProfileDefinition;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;

public class ProfileRedefinitionHelper {
    public static void redefineProfile(Package thepackage, ProfileDefinition profileDefinition) {
        if (thepackage instanceof Profile) {
            Profile profile = (Profile)thepackage;
            EPackage packageProfileDefinition = profile.getDefinition();
            for (EClassifier eclassifier : packageProfileDefinition.getEClassifiers()) {
                if (!(eclassifier instanceof EClass)) continue;
                ProfileRedefinitionHelper.redefineEclass((EClass)eclassifier);
            }
            if (profileDefinition != null) {
                profile.getDefinition().getEAnnotations().add((Object)profileDefinition.convertToEAnnotation());
            }
        }
        for (Package nextPackage : thepackage.getNestedPackages()) {
            ProfileRedefinitionHelper.redefineProfile(nextPackage, profileDefinition);
        }
    }

    public static void redefineEclass(EClass eclass) {
        if (ProfileRedefinitionHelper.isADirectDefinition(eclass)) {
            EList eSuperTypes = eclass.getESuperTypes();
            ArrayList superTypesList = new ArrayList();
            superTypesList.addAll(eSuperTypes);
            for (EClass currentSuperClass : superTypesList) {
                if (ProfileRedefinitionHelper.isADirectDefinition(currentSuperClass)) continue;
                EClass directSuperClass = (EClass)ProfileRedefinitionHelper.lookForDirectDefinitionFrom((EClassifier)currentSuperClass);
                eclass.getESuperTypes().remove((Object)currentSuperClass);
                eclass.getESuperTypes().add((Object)directSuperClass);
            }
            Iterator referencesIterator = eclass.getEReferences().iterator();
            while (referencesIterator.hasNext()) {
                ProfileRedefinitionHelper.redefineEReference((EReference)referencesIterator.next(), eclass.getEPackage());
            }
        }
    }

    public static void redefineEReference(EReference eReference, EPackage profileDefinition) {
        EReference oldEOpposite = eReference.getEOpposite();
        EClassifier oldType = eReference.getEType();
        if (oldType instanceof EClass) {
            eReference.setEType(ProfileRedefinitionHelper.lookForDirectDefinitionFrom(oldType));
            if (oldEOpposite != null) {
                eReference.setEOpposite(ProfileRedefinitionHelper.lookForEquivalentEreference((EClass)eReference.getEType(), oldEOpposite));
            }
        }
    }

    public static boolean isADirectDefinition(EClass eclass) {
        EAnnotation eAnnotation;
        if (eclass.getEAnnotations().size() > 0 && (eAnnotation = eclass.getEAnnotation("http://www.eclipse.org/uml2/2.0.0/UML")).getReferences().size() > 0) {
            if (!(eAnnotation.getReferences().get(0) instanceof Classifier)) {
                String string = "Problem because of the definition of " + eclass.getName() + " in " + eclass.getEPackage().getNsURI();
            } else {
                Classifier theClassifier = (Classifier)eAnnotation.getReferences().get(0);
                Package nearestPackage = theClassifier.getNearestPackage();
                if (nearestPackage instanceof Profile && eclass.equals(((Profile)nearestPackage).getDefinition((NamedElement)theClassifier))) {
                    return true;
                }
            }
        }
        return false;
    }

    public static EClassifier lookForDirectDefinitionFrom(EClassifier eClassifier) {
        Classifier theClassifier;
        Package nearestPackage;
        EAnnotation eAnnotation;
        if (eClassifier.getEAnnotations().size() > 0 && (eAnnotation = (EAnnotation)eClassifier.getEAnnotations().get(0)).getReferences().size() > 0 && (nearestPackage = (theClassifier = (Classifier)eAnnotation.getReferences().get(0)).getNearestPackage()) instanceof Profile) {
            return (EClassifier)((Profile)nearestPackage).getDefinition((NamedElement)theClassifier);
        }
        return eClassifier;
    }

    private static EReference lookForEquivalentEreference(EClass eclass, EReference eReference) {
        for (EReference currentEReference : eclass.getEReferences()) {
            if (!currentEReference.getName().equals(eReference.getName()) || !currentEReference.getEType().getName().endsWith(eReference.getEType().getName())) continue;
            return currentEReference;
        }
        return null;
    }

    public static void cleanProfile(Package thePackage) {
        if (thePackage instanceof Profile) {
            Profile profile = (Profile)thePackage;
            EPackage profileDefinition = profile.getDefinition();
            ArrayList<EClassifier> tempList = new ArrayList<EClassifier>();
            int i = 0;
            while (i < profileDefinition.getEClassifiers().size()) {
                tempList.add((EClassifier)profileDefinition.getEClassifiers().get(i));
                ++i;
            }
            for (EClassifier eclassifier : tempList) {
                if (!(eclassifier instanceof EClass) || ProfileRedefinitionHelper.isADirectDefinition((EClass)eclassifier)) continue;
                profileDefinition.getEClassifiers().remove((Object)eclassifier);
            }
        }
        for (Package p : thePackage.getNestedPackages()) {
            ProfileRedefinitionHelper.cleanProfile(p);
        }
    }

    public static void removeUndefinedVersion(Package packageElement) {
        ProfileDefinition tagVersion;
        EAnnotation firstAnnotation;
        EAnnotation umlAnnotation;
        if (packageElement instanceof Profile && (umlAnnotation = ((Profile)packageElement).getEAnnotation("http://www.eclipse.org/uml2/2.0.0/UML")) != null && (firstAnnotation = umlAnnotation.getEAnnotation("PapyrusVersion")) != null && ProfileDefinition.UNDEFINED_ANNOTATION.equals(tagVersion = ProfileDefinition.parseEAnnotation(firstAnnotation))) {
            umlAnnotation.getEAnnotations().remove((Object)firstAnnotation);
        }
    }
}

